/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.dmn.businessruletask;

import java.util.Map;
import org.camunda.bpm.engine.exception.dmn.DecisionDefinitionNotFoundException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.dmn.businessruletask.TestPojo;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public class DmnBusinessRuleTaskTest
extends PluggableProcessEngineTestCase {
    public static final String DECISION_PROCESS = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml";
    public static final String DECISION_PROCESS_EXPRESSION = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefExpression.bpmn20.xml";
    public static final String DECISION_PROCESS_LATEST = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefLatestBinding.bpmn20.xml";
    public static final String DECISION_PROCESS_DEPLOYMENT = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefDeploymentBinding.bpmn20.xml";
    public static final String DECISION_PROCESS_VERSION = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefVersionBinding.bpmn20.xml";
    public static final String DECISION_OKAY_DMN = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionOkay.dmn11.xml";
    public static final String DECISION_NOT_OKAY_DMN = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionNotOkay.dmn11.xml";
    public static final String DECISION_POJO_DMN = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testPojo.dmn11.xml";

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefExpression.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionOkay.dmn11.xml"})
    public void testDecisionRef() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        DmnBusinessRuleTaskTest.assertEquals((Object)"okay", (Object)this.getDecisionResult(processInstance));
        processInstance = this.startExpressionProcess("testDecision", 1);
        DmnBusinessRuleTaskTest.assertEquals((Object)"okay", (Object)this.getDecisionResult(processInstance));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefExpression.bpmn20.xml"})
    public void testNoDecisionFound() {
        try {
            this.runtimeService.startProcessInstanceByKey("testProcess");
            DmnBusinessRuleTaskTest.fail((String)"Exception expected");
        }
        catch (DecisionDefinitionNotFoundException e) {
            this.assertTextPresent("no decision definition deployed with key 'testDecision'", e.getMessage());
        }
        try {
            this.startExpressionProcess("testDecision", 1);
            DmnBusinessRuleTaskTest.fail((String)"Exception expected");
        }
        catch (DecisionDefinitionNotFoundException e) {
            this.assertTextPresent("no decision definition deployed with key = 'testDecision' and version = '1'", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefLatestBinding.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionOkay.dmn11.xml"})
    public void testDecisionRefLatestBinding() {
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(DECISION_NOT_OKAY_DMN).deploy().getId();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        DmnBusinessRuleTaskTest.assertEquals((Object)"not okay", (Object)this.getDecisionResult(processInstance));
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefDeploymentBinding.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionOkay.dmn11.xml"})
    public void testDecisionRefDeploymentBinding() {
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(DECISION_NOT_OKAY_DMN).deploy().getId();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        DmnBusinessRuleTaskTest.assertEquals((Object)"okay", (Object)this.getDecisionResult(processInstance));
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefVersionBinding.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefExpression.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionOkay.dmn11.xml"})
    public void testDecisionRefVersionBinding() {
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(DECISION_NOT_OKAY_DMN).deploy().getId();
        String thirdDeploymentId = this.repositoryService.createDeployment().addClasspathResource(DECISION_OKAY_DMN).deploy().getId();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        DmnBusinessRuleTaskTest.assertEquals((Object)"not okay", (Object)this.getDecisionResult(processInstance));
        processInstance = this.startExpressionProcess("testDecision", 2);
        DmnBusinessRuleTaskTest.assertEquals((Object)"not okay", (Object)this.getDecisionResult(processInstance));
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
        this.repositoryService.deleteDeployment(thirdDeploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testPojo.dmn11.xml"})
    public void testPojo() {
        VariableMap variables = Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37));
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        DmnBusinessRuleTaskTest.assertEquals((Object)"okay", (Object)this.getDecisionResult(processInstance));
    }

    protected ProcessInstance startExpressionProcess(Object decisionKey, Object version) {
        VariableMap variables = Variables.createVariables().putValue("decision", decisionKey).putValue("version", version);
        return this.runtimeService.startProcessInstanceByKey("testProcessExpression", (Map)variables);
    }

    protected Object getDecisionResult(ProcessInstance processInstance) {
        return this.runtimeService.getVariable(processInstance.getId(), "result");
    }
}

