/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.dmn.deployment;

import java.io.InputStream;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.test.Deployment;

public class DmnDeployerTest
extends PluggableProcessEngineTestCase {
    public void testDmnDeployment() {
        String resourceName = "org/camunda/bpm/engine/test/dmn/deployment/DmnDeployerTest.testDmnDeployment.dmn11.xml";
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(resourceName).deploy().getId();
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        DmnDeployerTest.assertEquals((long)1L, (long)deploymentQuery.count());
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        DmnDeployerTest.assertEquals((long)1L, (long)query.count());
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        DmnDeployerTest.assertTrue((boolean)decisionDefinition.getId().startsWith("decision:1:"));
        DmnDeployerTest.assertEquals((String)"http://camunda.org/schema/1.0/dmn", (String)decisionDefinition.getCategory());
        DmnDeployerTest.assertEquals((String)"CheckOrder", (String)decisionDefinition.getName());
        DmnDeployerTest.assertEquals((String)"decision", (String)decisionDefinition.getKey());
        DmnDeployerTest.assertEquals((int)1, (int)decisionDefinition.getVersion());
        DmnDeployerTest.assertEquals((String)resourceName, (String)decisionDefinition.getResourceName());
        DmnDeployerTest.assertEquals((String)deploymentId, (String)decisionDefinition.getDeploymentId());
        DmnDeployerTest.assertNull((Object)decisionDefinition.getDiagramResourceName());
        this.repositoryService.deleteDeployment(deploymentId);
    }

    public void testDmnDeploymentWithDmnSuffix() {
        String resourceName = "org/camunda/bpm/engine/test/dmn/deployment/DmnDeployerTest.testDmnDeployment.dmn";
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(resourceName).deploy().getId();
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        DmnDeployerTest.assertEquals((long)1L, (long)deploymentQuery.count());
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        DmnDeployerTest.assertEquals((long)1L, (long)query.count());
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        DmnDeployerTest.assertTrue((boolean)decisionDefinition.getId().startsWith("decision:1:"));
        DmnDeployerTest.assertEquals((String)"http://camunda.org/schema/1.0/dmn", (String)decisionDefinition.getCategory());
        DmnDeployerTest.assertEquals((String)"CheckOrder", (String)decisionDefinition.getName());
        DmnDeployerTest.assertEquals((String)"decision", (String)decisionDefinition.getKey());
        DmnDeployerTest.assertEquals((int)1, (int)decisionDefinition.getVersion());
        DmnDeployerTest.assertEquals((String)resourceName, (String)decisionDefinition.getResourceName());
        DmnDeployerTest.assertEquals((String)deploymentId, (String)decisionDefinition.getDeploymentId());
        DmnDeployerTest.assertNull((Object)decisionDefinition.getDiagramResourceName());
        this.repositoryService.deleteDeployment(deploymentId);
    }

    @Deployment
    public void testLongDecisionDefinitionKey() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        DmnDeployerTest.assertFalse((boolean)decisionDefinition.getId().startsWith("o123456789"));
        DmnDeployerTest.assertEquals((String)"o123456789o123456789o123456789o123456789o123456789o123456789o123456789", (String)decisionDefinition.getKey());
    }

    public void testDuplicateIdInDeployment() {
        try {
            String resourceName1 = "org/camunda/bpm/engine/test/dmn/deployment/DmnDeployerTest.testDuplicateIdInDeployment.dmn11.xml";
            String resourceName2 = "org/camunda/bpm/engine/test/dmn/deployment/DmnDeployerTest.testDuplicateIdInDeployment2.dmn11.xml";
            this.repositoryService.createDeployment().addClasspathResource(resourceName1).addClasspathResource(resourceName2).name("duplicateIds").deploy();
            DmnDeployerTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("duplicateDecision", e.getMessage());
            DmnDeployerTest.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/DmnDeployerTest.testDecisionDiagramResource.dmn11.xml", "org/camunda/bpm/engine/test/dmn/deployment/DmnDeployerTest.testDecisionDiagramResource.png"})
    public void testDecisionDiagramResource() {
        String resourcePrefix = "org/camunda/bpm/engine/test/dmn/deployment/DmnDeployerTest.testDecisionDiagramResource";
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        DmnDeployerTest.assertEquals((String)(resourcePrefix + ".dmn11.xml"), (String)decisionDefinition.getResourceName());
        DmnDeployerTest.assertEquals((String)"decision", (String)decisionDefinition.getKey());
        String diagramResourceName = decisionDefinition.getDiagramResourceName();
        DmnDeployerTest.assertEquals((String)(resourcePrefix + ".png"), (String)diagramResourceName);
        InputStream diagramStream = this.repositoryService.getResourceAsStream(this.deploymentId, diagramResourceName);
        byte[] diagramBytes = IoUtil.readInputStream((InputStream)diagramStream, (String)"diagram stream");
        DmnDeployerTest.assertEquals((int)2540, (int)diagramBytes.length);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/DmnDeployerTest.testMultipleDecisionDiagramResource.dmn11.xml", "org/camunda/bpm/engine/test/dmn/deployment/DmnDeployerTest.testMultipleDecisionDiagramResource.decision1.png", "org/camunda/bpm/engine/test/dmn/deployment/DmnDeployerTest.testMultipleDecisionDiagramResource.decision2.png", "org/camunda/bpm/engine/test/dmn/deployment/DmnDeployerTest.testMultipleDecisionDiagramResource.decision3.png"})
    public void testMultipleDiagramResourcesProvided() {
        String resourcePrefix = "org/camunda/bpm/engine/test/dmn/deployment/DmnDeployerTest.testMultipleDecisionDiagramResource.";
        DecisionDefinitionQuery decisionDefinitionQuery = this.repositoryService.createDecisionDefinitionQuery();
        DmnDeployerTest.assertEquals((long)3L, (long)decisionDefinitionQuery.count());
        for (DecisionDefinition decisionDefinition : decisionDefinitionQuery.list()) {
            DmnDeployerTest.assertEquals((String)(resourcePrefix + decisionDefinition.getKey() + ".png"), (String)decisionDefinition.getDiagramResourceName());
        }
    }
}

