/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInputInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;
import org.camunda.bpm.engine.history.NativeHistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInstanceEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.variables.JavaSerializable;
import org.camunda.bpm.engine.test.history.DecisionServiceDelegate;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.joda.time.DateTime;
import org.junit.Assert;

public class HistoricDecisionInstanceTest
extends PluggableProcessEngineTestCase {
    public static final String DECISION_CASE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.caseWithDecisionTask.cmmn";
    public static final String DECISION_CASE_WITH_DECISION_SERVICE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testCaseDecisionEvaluatedWithDecisionServiceInsideDelegate.cmmn";
    public static final String DECISION_CASE_WITH_DECISION_SERVICE_INSIDE_RULE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testManualActivationRuleEvaluatesDecision.cmmn";
    public static final String DECISION_CASE_WITH_DECISION_SERVICE_INSIDE_IF_PART = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testIfPartEvaluatesDecision.cmmn";
    public static final String DECISION_PROCESS = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml";
    public static final String DECISION_PROCESS_WITH_DECISION_SERVICE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideDelegation.bpmn20.xml";
    public static final String DECISION_PROCESS_WITH_START_LISTENER = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideStartListener.bpmn20.xml";
    public static final String DECISION_PROCESS_WITH_END_LISTENER = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideEndListener.bpmn20.xml";
    public static final String DECISION_PROCESS_WITH_TAKE_LISTENER = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideTakeListener.bpmn20.xml";
    public static final String DECISION_PROCESS_INSIDE_EXPRESSION = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideExpression.bpmn20.xml";
    public static final String DECISION_PROCESS_INSIDE_DELEGATE_EXPRESSION = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideDelegateExpression.bpmn20.xml";
    public static final String DECISION_SINGLE_OUTPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml";
    public static final String DECISION_MULTIPLE_OUTPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionMultipleOutput.dmn11.xml";
    public static final String DECISION_COMPOUND_OUTPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionCompoundOutput.dmn11.xml";
    public static final String DECISION_MULTIPLE_INPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionMultipleInput.dmn11.xml";
    public static final String DECISION_COLLECT_SUM_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionCollectSum.dmn11.xml";
    public static final String DECISION_RETURNS_TRUE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.returnsTrue.dmn11.xml";
    protected static final String DECISION_DEFINITION_KEY = "testDecision";

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionInstanceProperties() {
        this.startProcessInstanceAndEvaluateDecision();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinitionId));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DECISION_DEFINITION_KEY));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)processDefinition.getKey()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Object)processDefinition.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Object)"task"));
        Assert.assertThat((Object)historicDecisionInstance.getActivityInstanceId(), (Matcher)CoreMatchers.is((Object)activityInstanceId));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.caseWithDecisionTask.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testCaseDecisionInstanceProperties() {
        CaseInstance caseInstance = this.createCaseInstanceAndEvaluateDecision();
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionId(caseInstance.getCaseDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricCaseActivityInstance)this.historyService.createHistoricCaseActivityInstanceQuery().caseActivityId("PI_DecisionTask_1").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinitionId));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DECISION_DEFINITION_KEY));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionKey(), (Matcher)CoreMatchers.is((Object)caseDefinition.getKey()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionId(), (Matcher)CoreMatchers.is((Object)caseDefinition.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseInstanceId(), (Matcher)CoreMatchers.is((Object)caseInstance.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Object)"PI_DecisionTask_1"));
        Assert.assertThat((Object)historicDecisionInstance.getActivityInstanceId(), (Matcher)CoreMatchers.is((Object)activityInstanceId));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryIncludeInputs() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        try {
            ((HistoricDecisionInstance)query.singleResult()).getInputs();
            HistoricDecisionInstanceTest.fail((String)"expected exception: input not fetched");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        Assert.assertThat((Object)((HistoricDecisionInstance)query.includeInputs().singleResult()).getInputs().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryIncludeInputsForNonExistingDecision() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().includeInputs();
        Assert.assertThat((Object)query.singleResult(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.startProcessInstanceAndEvaluateDecision();
        Assert.assertThat((Object)query.decisionInstanceId("nonExisting").singleResult(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryIncludeOutputs() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        try {
            ((HistoricDecisionInstance)query.singleResult()).getOutputs();
            HistoricDecisionInstanceTest.fail((String)"expected exception: output not fetched");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        Assert.assertThat((Object)((HistoricDecisionInstance)query.includeOutputs().singleResult()).getOutputs().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryIncludeOutputsForNonExistingDecision() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().includeOutputs();
        Assert.assertThat((Object)query.singleResult(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.startProcessInstanceAndEvaluateDecision();
        Assert.assertThat((Object)query.decisionInstanceId("nonExisting").singleResult(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionInputInstanceProperties() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().singleResult();
        List inputs = historicDecisionInstance.getInputs();
        Assert.assertThat((Object)inputs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)inputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionInputInstance input = (HistoricDecisionInputInstance)inputs.get(0);
        Assert.assertThat((Object)input.getDecisionInstanceId(), (Matcher)CoreMatchers.is((Object)historicDecisionInstance.getId()));
        Assert.assertThat((Object)input.getClauseId(), (Matcher)CoreMatchers.is((Object)"in"));
        Assert.assertThat((Object)input.getClauseName(), (Matcher)CoreMatchers.is((Object)"input"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testMultipleDecisionInstances() {
        this.startProcessInstanceAndEvaluateDecision("a");
        this.waitASignificantAmountOfTime();
        this.startProcessInstanceAndEvaluateDecision("b");
        List historicDecisionInstances = ((HistoricDecisionInstanceQuery)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().orderByEvaluationTime().asc()).list();
        Assert.assertThat((Object)historicDecisionInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        List inputsOfFirstDecision = ((HistoricDecisionInstance)historicDecisionInstances.get(0)).getInputs();
        Assert.assertThat((Object)inputsOfFirstDecision.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((HistoricDecisionInputInstance)inputsOfFirstDecision.get(0)).getValue(), (Matcher)CoreMatchers.is((Object)"a"));
        List inputsOfSecondDecision = ((HistoricDecisionInstance)historicDecisionInstances.get(1)).getInputs();
        Assert.assertThat((Object)inputsOfSecondDecision.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((HistoricDecisionInputInstance)inputsOfSecondDecision.get(0)).getValue(), (Matcher)CoreMatchers.is((Object)"b"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionMultipleInput.dmn11.xml"})
    public void testMultipleDecisionInputInstances() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("input1", "a");
        variables.put("input2", 1);
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().singleResult();
        List inputs = historicDecisionInstance.getInputs();
        Assert.assertThat((Object)inputs.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((HistoricDecisionInputInstance)inputs.get(0)).getValue(), (Matcher)CoreMatchers.is((Object)"a"));
        Assert.assertThat((Object)((HistoricDecisionInputInstance)inputs.get(1)).getValue(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionInputInstanceStringValue() {
        this.startProcessInstanceAndEvaluateDecision("a");
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().singleResult();
        List inputs = historicDecisionInstance.getInputs();
        Assert.assertThat((Object)inputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionInputInstance input = (HistoricDecisionInputInstance)inputs.get(0);
        Assert.assertThat((Object)input.getTypeName(), (Matcher)CoreMatchers.is((Object)"string"));
        Assert.assertThat((Object)input.getValue(), (Matcher)CoreMatchers.is((Object)"a"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionInputInstanceLongValue() {
        this.startProcessInstanceAndEvaluateDecision(1L);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().singleResult();
        List inputs = historicDecisionInstance.getInputs();
        Assert.assertThat((Object)inputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionInputInstance input = (HistoricDecisionInputInstance)inputs.get(0);
        Assert.assertThat((Object)input.getTypeName(), (Matcher)CoreMatchers.is((Object)"long"));
        Assert.assertThat((Object)input.getValue(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionInputInstanceDoubleValue() {
        this.startProcessInstanceAndEvaluateDecision(2.5);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().singleResult();
        List inputs = historicDecisionInstance.getInputs();
        Assert.assertThat((Object)inputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionInputInstance input = (HistoricDecisionInputInstance)inputs.get(0);
        Assert.assertThat((Object)input.getTypeName(), (Matcher)CoreMatchers.is((Object)"double"));
        Assert.assertThat((Object)input.getValue(), (Matcher)CoreMatchers.is((Object)2.5));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionInputInstanceByteValue() {
        byte[] bytes = "object".getBytes();
        this.startProcessInstanceAndEvaluateDecision(bytes);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().singleResult();
        List inputs = historicDecisionInstance.getInputs();
        Assert.assertThat((Object)inputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionInputInstance input = (HistoricDecisionInputInstance)inputs.get(0);
        Assert.assertThat((Object)input.getTypeName(), (Matcher)CoreMatchers.is((Object)"bytes"));
        Assert.assertThat((Object)input.getValue(), (Matcher)CoreMatchers.is((Object)bytes));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionInputInstanceObjectValue() {
        JavaSerializable object = new JavaSerializable("foo");
        this.startProcessInstanceAndEvaluateDecision(object);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().singleResult();
        List inputs = historicDecisionInstance.getInputs();
        Assert.assertThat((Object)inputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionInputInstance input = (HistoricDecisionInputInstance)inputs.get(0);
        Assert.assertThat((Object)input.getTypeName(), (Matcher)CoreMatchers.is((Object)"object"));
        Assert.assertThat((Object)input.getValue(), (Matcher)CoreMatchers.is((Object)object));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDisableDecisionInputInstanceByteValue() {
        byte[] bytes = "object".getBytes();
        this.startProcessInstanceAndEvaluateDecision(bytes);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().disableBinaryFetching().singleResult();
        List inputs = historicDecisionInstance.getInputs();
        Assert.assertThat((Object)inputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionInputInstance input = (HistoricDecisionInputInstance)inputs.get(0);
        Assert.assertThat((Object)input.getTypeName(), (Matcher)CoreMatchers.is((Object)"bytes"));
        Assert.assertThat((Object)input.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionOutputInstanceProperties() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        List outputs = historicDecisionInstance.getOutputs();
        Assert.assertThat((Object)outputs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)outputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionOutputInstance output = (HistoricDecisionOutputInstance)outputs.get(0);
        Assert.assertThat((Object)output.getDecisionInstanceId(), (Matcher)CoreMatchers.is((Object)historicDecisionInstance.getId()));
        Assert.assertThat((Object)output.getClauseId(), (Matcher)CoreMatchers.is((Object)"out"));
        Assert.assertThat((Object)output.getClauseName(), (Matcher)CoreMatchers.is((Object)"output"));
        Assert.assertThat((Object)output.getRuleId(), (Matcher)CoreMatchers.is((Object)"rule"));
        Assert.assertThat((Object)output.getRuleOrder(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)output.getVariableName(), (Matcher)CoreMatchers.is((Object)"result"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionMultipleOutput.dmn11.xml"})
    public void testMultipleDecisionOutputInstances() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        List outputs = historicDecisionInstance.getOutputs();
        Assert.assertThat((Object)outputs.size(), (Matcher)CoreMatchers.is((Object)2));
        HistoricDecisionOutputInstance firstOutput = (HistoricDecisionOutputInstance)outputs.get(0);
        Assert.assertThat((Object)firstOutput.getClauseId(), (Matcher)CoreMatchers.is((Object)"out1"));
        Assert.assertThat((Object)firstOutput.getRuleId(), (Matcher)CoreMatchers.is((Object)"rule1"));
        Assert.assertThat((Object)firstOutput.getRuleOrder(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)firstOutput.getVariableName(), (Matcher)CoreMatchers.is((Object)"result1"));
        Assert.assertThat((Object)firstOutput.getValue(), (Matcher)CoreMatchers.is((Object)"okay"));
        HistoricDecisionOutputInstance secondOutput = (HistoricDecisionOutputInstance)outputs.get(1);
        Assert.assertThat((Object)secondOutput.getClauseId(), (Matcher)CoreMatchers.is((Object)"out1"));
        Assert.assertThat((Object)secondOutput.getRuleId(), (Matcher)CoreMatchers.is((Object)"rule2"));
        Assert.assertThat((Object)secondOutput.getRuleOrder(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)secondOutput.getVariableName(), (Matcher)CoreMatchers.is((Object)"result1"));
        Assert.assertThat((Object)secondOutput.getValue(), (Matcher)CoreMatchers.is((Object)"not okay"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionCompoundOutput.dmn11.xml"})
    public void testCompoundDecisionOutputInstances() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        List outputs = historicDecisionInstance.getOutputs();
        Assert.assertThat((Object)outputs.size(), (Matcher)CoreMatchers.is((Object)2));
        HistoricDecisionOutputInstance firstOutput = (HistoricDecisionOutputInstance)outputs.get(0);
        Assert.assertThat((Object)firstOutput.getClauseId(), (Matcher)CoreMatchers.is((Object)"out1"));
        Assert.assertThat((Object)firstOutput.getRuleId(), (Matcher)CoreMatchers.is((Object)"rule1"));
        Assert.assertThat((Object)firstOutput.getRuleOrder(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)firstOutput.getVariableName(), (Matcher)CoreMatchers.is((Object)"result1"));
        Assert.assertThat((Object)firstOutput.getValue(), (Matcher)CoreMatchers.is((Object)"okay"));
        HistoricDecisionOutputInstance secondOutput = (HistoricDecisionOutputInstance)outputs.get(1);
        Assert.assertThat((Object)secondOutput.getClauseId(), (Matcher)CoreMatchers.is((Object)"out2"));
        Assert.assertThat((Object)secondOutput.getRuleId(), (Matcher)CoreMatchers.is((Object)"rule1"));
        Assert.assertThat((Object)secondOutput.getRuleOrder(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)secondOutput.getVariableName(), (Matcher)CoreMatchers.is((Object)"result2"));
        Assert.assertThat((Object)secondOutput.getValue(), (Matcher)CoreMatchers.is((Object)"not okay"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionOutputInstanceStringValue() {
        this.startProcessInstanceAndEvaluateDecision("a");
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        List outputs = historicDecisionInstance.getOutputs();
        Assert.assertThat((Object)outputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionOutputInstance output = (HistoricDecisionOutputInstance)outputs.get(0);
        Assert.assertThat((Object)output.getTypeName(), (Matcher)CoreMatchers.is((Object)"string"));
        Assert.assertThat((Object)output.getValue(), (Matcher)CoreMatchers.is((Object)"a"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionOutputInstanceLongValue() {
        this.startProcessInstanceAndEvaluateDecision(1L);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        List outputs = historicDecisionInstance.getOutputs();
        Assert.assertThat((Object)outputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionOutputInstance output = (HistoricDecisionOutputInstance)outputs.get(0);
        Assert.assertThat((Object)output.getTypeName(), (Matcher)CoreMatchers.is((Object)"long"));
        Assert.assertThat((Object)output.getValue(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionOutputInstanceDoubleValue() {
        this.startProcessInstanceAndEvaluateDecision(2.5);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        List outputs = historicDecisionInstance.getOutputs();
        Assert.assertThat((Object)outputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionOutputInstance output = (HistoricDecisionOutputInstance)outputs.get(0);
        Assert.assertThat((Object)output.getTypeName(), (Matcher)CoreMatchers.is((Object)"double"));
        Assert.assertThat((Object)output.getValue(), (Matcher)CoreMatchers.is((Object)2.5));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionOutputInstanceByteValue() {
        byte[] bytes = "object".getBytes();
        this.startProcessInstanceAndEvaluateDecision(bytes);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        List outputs = historicDecisionInstance.getOutputs();
        Assert.assertThat((Object)outputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionOutputInstance output = (HistoricDecisionOutputInstance)outputs.get(0);
        Assert.assertThat((Object)output.getTypeName(), (Matcher)CoreMatchers.is((Object)"bytes"));
        Assert.assertThat((Object)output.getValue(), (Matcher)CoreMatchers.is((Object)bytes));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionOutputInstanceObjectValue() {
        JavaSerializable object = new JavaSerializable("foo");
        this.startProcessInstanceAndEvaluateDecision(object);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        List outputs = historicDecisionInstance.getOutputs();
        Assert.assertThat((Object)outputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionOutputInstance output = (HistoricDecisionOutputInstance)outputs.get(0);
        Assert.assertThat((Object)output.getTypeName(), (Matcher)CoreMatchers.is((Object)"object"));
        Assert.assertThat((Object)output.getValue(), (Matcher)CoreMatchers.is((Object)object));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionOutputInstanceObjectListValue() {
        ArrayList<JavaSerializable> object = new ArrayList<JavaSerializable>();
        object.add(new JavaSerializable("foo"));
        this.startProcessInstanceAndEvaluateDecision(object);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        List outputs = historicDecisionInstance.getOutputs();
        Assert.assertThat((Object)outputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionOutputInstance output = (HistoricDecisionOutputInstance)outputs.get(0);
        Assert.assertThat((Object)output.getTypeName(), (Matcher)CoreMatchers.is((Object)"object"));
        Assert.assertThat((Object)output.getValue(), (Matcher)CoreMatchers.is(object));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionCollectSum.dmn11.xml"})
    public void testCollectResultValue() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance.getCollectResultValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCollectResultValue(), (Matcher)CoreMatchers.is((Object)3.0));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryPaging() {
        this.startProcessInstanceAndEvaluateDecision();
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.listPage(0, 2).size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)query.listPage(1, 1).size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQuerySortByEvaluationTime() {
        this.startProcessInstanceAndEvaluateDecision();
        this.waitASignificantAmountOfTime();
        this.startProcessInstanceAndEvaluateDecision();
        List orderAsc = ((HistoricDecisionInstanceQuery)this.historyService.createHistoricDecisionInstanceQuery().orderByEvaluationTime().asc()).list();
        Assert.assertThat((Object)((HistoricDecisionInstance)orderAsc.get(0)).getEvaluationTime().before(((HistoricDecisionInstance)orderAsc.get(1)).getEvaluationTime()), (Matcher)CoreMatchers.is((Object)true));
        List orderDesc = ((HistoricDecisionInstanceQuery)this.historyService.createHistoricDecisionInstanceQuery().orderByEvaluationTime().desc()).list();
        Assert.assertThat((Object)((HistoricDecisionInstance)orderDesc.get(0)).getEvaluationTime().after(((HistoricDecisionInstance)orderDesc.get(1)).getEvaluationTime()), (Matcher)CoreMatchers.is((Object)true));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByDecisionInstanceId() {
        ProcessInstance pi1 = this.startProcessInstanceAndEvaluateDecision();
        ProcessInstance pi2 = this.startProcessInstanceAndEvaluateDecision();
        String decisionInstanceId1 = ((HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().processInstanceId(pi1.getId()).singleResult()).getId();
        String decisionInstanceId2 = ((HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().processInstanceId(pi2.getId()).singleResult()).getId();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.decisionInstanceId(decisionInstanceId1).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.decisionInstanceId(decisionInstanceId2).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.decisionInstanceId("unknown").count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByDecisionInstanceIds() {
        ProcessInstance pi1 = this.startProcessInstanceAndEvaluateDecision();
        ProcessInstance pi2 = this.startProcessInstanceAndEvaluateDecision();
        String decisionInstanceId1 = ((HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().processInstanceId(pi1.getId()).singleResult()).getId();
        String decisionInstanceId2 = ((HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().processInstanceId(pi2.getId()).singleResult()).getId();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.decisionInstanceIdIn(new String[]{decisionInstanceId1}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.decisionInstanceIdIn(new String[]{decisionInstanceId2}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.decisionInstanceIdIn(new String[]{decisionInstanceId1, decisionInstanceId2}).count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByDecisionDefinitionId() {
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.decisionDefinitionId(decisionDefinitionId).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.decisionDefinitionId("other id").count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByDecisionDefinitionKey() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.decisionDefinitionKey(DECISION_DEFINITION_KEY).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.decisionDefinitionKey("other key").count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByDecisionDefinitionName() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.decisionDefinitionName("sample decision").count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.decisionDefinitionName("other name").count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByProcessDefinitionKey() {
        String processDefinitionKey = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getKey();
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.processDefinitionKey(processDefinitionKey).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.processDefinitionKey("other process").count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByProcessDefinitionId() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.processDefinitionId(processDefinitionId).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.processDefinitionId("other process").count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByProcessInstanceId() {
        this.startProcessInstanceAndEvaluateDecision();
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult()).getId();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.processInstanceId(processInstanceId).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.processInstanceId("other process").count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByActivityId() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.activityIdIn(new String[]{"task"}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.activityIdIn(new String[]{"other activity"}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.activityIdIn(new String[]{"task", "other activity"}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByActivityInstanceId() {
        this.startProcessInstanceAndEvaluateDecision();
        String activityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task").singleResult()).getId();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.activityInstanceIdIn(new String[]{activityInstanceId}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.activityInstanceIdIn(new String[]{"other activity"}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.activityInstanceIdIn(new String[]{activityInstanceId, "other activity"}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByEvaluatedBefore() {
        Date beforeEvaluated = new Date(1441612000L);
        Date evaluated = new Date(1441613000L);
        Date afterEvaluated = new Date(1441614000L);
        ClockUtil.setCurrentTime((Date)evaluated);
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.evaluatedBefore(afterEvaluated).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.evaluatedBefore(evaluated).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.evaluatedBefore(beforeEvaluated).count(), (Matcher)CoreMatchers.is((Object)0L));
        ClockUtil.reset();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByEvaluatedAfter() {
        Date beforeEvaluated = new Date(1441612000L);
        Date evaluated = new Date(1441613000L);
        Date afterEvaluated = new Date(1441614000L);
        ClockUtil.setCurrentTime((Date)evaluated);
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.evaluatedAfter(beforeEvaluated).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.evaluatedAfter(evaluated).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.evaluatedAfter(afterEvaluated).count(), (Matcher)CoreMatchers.is((Object)0L));
        ClockUtil.reset();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.caseWithDecisionTask.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByCaseDefinitionKey() {
        this.createCaseInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.caseDefinitionKey("case").count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByInvalidCaseDefinitionKey() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.caseDefinitionKey("invalid").count(), (Matcher)CoreMatchers.is((Object)0L));
        try {
            query.caseDefinitionKey(null);
            HistoricDecisionInstanceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.caseWithDecisionTask.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByCaseDefinitionId() {
        CaseInstance caseInstance = this.createCaseInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.caseDefinitionId(caseInstance.getCaseDefinitionId()).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByInvalidCaseDefinitionId() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.caseDefinitionId("invalid").count(), (Matcher)CoreMatchers.is((Object)0L));
        try {
            query.caseDefinitionId(null);
            HistoricDecisionInstanceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.caseWithDecisionTask.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testQueryByCaseInstanceId() {
        CaseInstance caseInstance = this.createCaseInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.caseInstanceId(caseInstance.getId()).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByInvalidCaseInstanceId() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.caseInstanceId("invalid").count(), (Matcher)CoreMatchers.is((Object)0L));
        try {
            query.caseInstanceId(null);
            HistoricDecisionInstanceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testTableNames() {
        Assert.assertThat((Object)this.managementService.getTableName(HistoricDecisionInstance.class), (Matcher)CoreMatchers.is((Object)"ACT_HI_DECINST"));
        Assert.assertThat((Object)this.managementService.getTableName(HistoricDecisionInstanceEntity.class), (Matcher)CoreMatchers.is((Object)"ACT_HI_DECINST"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testNativeQuery() {
        this.startProcessInstanceAndEvaluateDecision();
        NativeHistoricDecisionInstanceQuery nativeQuery = (NativeHistoricDecisionInstanceQuery)this.historyService.createNativeHistoricDecisionInstanceQuery().sql("SELECT * FROM ACT_HI_DECINST");
        Assert.assertThat((Object)nativeQuery.list().size(), (Matcher)CoreMatchers.is((Object)1));
        NativeHistoricDecisionInstanceQuery nativeQueryWithParameter = (NativeHistoricDecisionInstanceQuery)this.historyService.createNativeHistoricDecisionInstanceQuery().sql("SELECT * FROM ACT_HI_DECINST H WHERE H.DEC_DEF_KEY_ = #{decisionDefinitionKey}");
        Assert.assertThat((Object)((NativeHistoricDecisionInstanceQuery)nativeQueryWithParameter.parameter("decisionDefinitionKey", (Object)DECISION_DEFINITION_KEY)).list().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((NativeHistoricDecisionInstanceQuery)nativeQueryWithParameter.parameter("decisionDefinitionKey", (Object)"other decision")).list().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testNativeCountQuery() {
        this.startProcessInstanceAndEvaluateDecision();
        NativeHistoricDecisionInstanceQuery nativeQuery = (NativeHistoricDecisionInstanceQuery)this.historyService.createNativeHistoricDecisionInstanceQuery().sql("SELECT count(*) FROM ACT_HI_DECINST");
        Assert.assertThat((Object)nativeQuery.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testNativeQueryPaging() {
        this.startProcessInstanceAndEvaluateDecision();
        this.startProcessInstanceAndEvaluateDecision();
        NativeHistoricDecisionInstanceQuery nativeQuery = (NativeHistoricDecisionInstanceQuery)this.historyService.createNativeHistoricDecisionInstanceQuery().sql("SELECT * FROM ACT_HI_DECINST");
        Assert.assertThat((Object)nativeQuery.listPage(0, 2).size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)nativeQuery.listPage(1, 1).size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDeleteHistoricDecisionInstances() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY);
        this.startProcessInstanceAndEvaluateDecision();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        this.historyService.deleteHistoricDecisionInstance(decisionDefinition.getId());
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testDeleteHistoricDecisionInstanceByUndeployment() {
        String firstDeploymentId = this.repositoryService.createDeployment().addClasspathResource(DECISION_PROCESS).addClasspathResource(DECISION_SINGLE_OUTPUT_DMN).deploy().getId();
        this.startProcessInstanceAndEvaluateDecision();
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(DECISION_PROCESS).addClasspathResource(DECISION_MULTIPLE_OUTPUT_DMN).deploy().getId();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        this.repositoryService.deleteDeployment(firstDeploymentId, true);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionEvaluatedWithDecisionService() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("input1", "test");
        this.decisionService.evaluateDecisionTableByKey(DECISION_DEFINITION_KEY, variables);
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinitionId));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DECISION_DEFINITION_KEY));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getUserId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideDelegation.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionEvaluatedWithDecisionServiceInsideDelegate() {
        this.startProcessInstanceAndEvaluateDecision();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinitionId));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DECISION_DEFINITION_KEY));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)processDefinition.getKey()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Object)processDefinition.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Object)"task"));
        Assert.assertThat((Object)historicDecisionInstance.getActivityInstanceId(), (Matcher)CoreMatchers.is((Object)activityInstanceId));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideStartListener.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionEvaluatedWithDecisionServiceInsideStartListener() {
        this.startProcessInstanceAndEvaluateDecision();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinitionId));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DECISION_DEFINITION_KEY));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)processDefinition.getKey()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Object)processDefinition.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Object)"task"));
        Assert.assertThat((Object)historicDecisionInstance.getActivityInstanceId(), (Matcher)CoreMatchers.is((Object)activityInstanceId));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideEndListener.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionEvaluatedWithDecisionServiceInsideEndListener() {
        this.startProcessInstanceAndEvaluateDecision();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinitionId));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DECISION_DEFINITION_KEY));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)processDefinition.getKey()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Object)processDefinition.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Object)"task"));
        Assert.assertThat((Object)historicDecisionInstance.getActivityInstanceId(), (Matcher)CoreMatchers.is((Object)activityInstanceId));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideExpression.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionEvaluatedWithDecisionServiceInsideExpression() {
        VariableMap variables = Variables.createVariables().putValue("input1", null).putValue("myBean", (Object)new DecisionServiceDelegate());
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinitionId));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DECISION_DEFINITION_KEY));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)processDefinition.getKey()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Object)processDefinition.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Object)"task"));
        Assert.assertThat((Object)historicDecisionInstance.getActivityInstanceId(), (Matcher)CoreMatchers.is((Object)activityInstanceId));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideDelegateExpression.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionEvaluatedWithDecisionServiceInsideDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("input1", null).putValue("myBean", (Object)new DecisionServiceDelegate());
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinitionId));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DECISION_DEFINITION_KEY));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)processDefinition.getKey()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Object)processDefinition.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Object)"task"));
        Assert.assertThat((Object)historicDecisionInstance.getActivityInstanceId(), (Matcher)CoreMatchers.is((Object)activityInstanceId));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideTakeListener.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionEvaluatedWithDecisionServiceInsideTakeListener() {
        this.startProcessInstanceAndEvaluateDecision();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinitionId));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DECISION_DEFINITION_KEY));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)processDefinition.getKey()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Object)processDefinition.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Object)"start"));
        Assert.assertThat((Object)historicDecisionInstance.getActivityInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionEvaluatedWithAuthenticatedUser() {
        this.identityService.setAuthenticatedUserId("demo");
        VariableMap variables = Variables.putValue((String)"input1", (Object)"test");
        this.decisionService.evaluateDecisionTableByKey(DECISION_DEFINITION_KEY, (Map)variables);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getUserId(), (Matcher)CoreMatchers.is((Object)"demo"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionEvaluatedWithAuthenticatedUserFromProcess() {
        this.identityService.setAuthenticatedUserId("demo");
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getUserId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testCaseDecisionEvaluatedWithDecisionServiceInsideDelegate.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionEvaluatedWithAuthenticatedUserFromCase() {
        this.identityService.setAuthenticatedUserId("demo");
        CaseInstance caseInstance = this.createCaseInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getUserId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testCaseDecisionEvaluatedWithDecisionServiceInsideDelegate.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testCaseDecisionEvaluatedWithDecisionServiceInsideDelegate() {
        CaseInstance caseInstance = this.createCaseInstanceAndEvaluateDecision();
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionId(caseInstance.getCaseDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricCaseActivityInstance)this.historyService.createHistoricCaseActivityInstanceQuery().caseActivityId("PI_HumanTask_1").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinitionId));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DECISION_DEFINITION_KEY));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionKey(), (Matcher)CoreMatchers.is((Object)caseDefinition.getKey()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionId(), (Matcher)CoreMatchers.is((Object)caseDefinition.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseInstanceId(), (Matcher)CoreMatchers.is((Object)caseInstance.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Object)"PI_HumanTask_1"));
        Assert.assertThat((Object)historicDecisionInstance.getActivityInstanceId(), (Matcher)CoreMatchers.is((Object)activityInstanceId));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testManualActivationRuleEvaluatesDecision.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.returnsTrue.dmn11.xml"})
    public void testManualActivationRuleEvaluatesDecision() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").setVariable("input1", null).setVariable("myBean", (Object)new DecisionServiceDelegate()).create();
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionId(caseInstance.getCaseDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricCaseActivityInstance)this.historyService.createHistoricCaseActivityInstanceQuery().caseActivityId("PI_HumanTask_1").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinitionId));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DECISION_DEFINITION_KEY));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionKey(), (Matcher)CoreMatchers.is((Object)caseDefinition.getKey()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionId(), (Matcher)CoreMatchers.is((Object)caseDefinition.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseInstanceId(), (Matcher)CoreMatchers.is((Object)caseInstance.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Object)"PI_HumanTask_1"));
        Assert.assertThat((Object)historicDecisionInstance.getActivityInstanceId(), (Matcher)CoreMatchers.is((Object)activityInstanceId));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testIfPartEvaluatesDecision.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.returnsTrue.dmn11.xml"})
    public void testIfPartEvaluatesDecision() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").setVariable("input1", null).setVariable("myBean", (Object)new DecisionServiceDelegate()).create();
        String humanTask1 = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.completeCaseExecution(humanTask1);
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionId(caseInstance.getCaseDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricCaseActivityInstance)this.historyService.createHistoricCaseActivityInstanceQuery().caseActivityId("PI_HumanTask_1").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinitionId));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DECISION_DEFINITION_KEY));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionKey(), (Matcher)CoreMatchers.is((Object)caseDefinition.getKey()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionId(), (Matcher)CoreMatchers.is((Object)caseDefinition.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseInstanceId(), (Matcher)CoreMatchers.is((Object)caseInstance.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Object)"PI_HumanTask_1"));
        Assert.assertThat((Object)historicDecisionInstance.getActivityInstanceId(), (Matcher)CoreMatchers.is((Object)activityInstanceId));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    protected ProcessInstance startProcessInstanceAndEvaluateDecision() {
        return this.startProcessInstanceAndEvaluateDecision(null);
    }

    protected ProcessInstance startProcessInstanceAndEvaluateDecision(Object input) {
        return this.runtimeService.startProcessInstanceByKey("testProcess", (Map)this.getVariables(input));
    }

    protected CaseInstance createCaseInstanceAndEvaluateDecision() {
        return this.createCaseInstanceAndEvaluateDecision(null);
    }

    protected CaseInstance createCaseInstanceAndEvaluateDecision(Object input) {
        return this.caseService.withCaseDefinitionByKey("case").setVariables((Map)this.getVariables(input)).create();
    }

    protected VariableMap getVariables(Object input) {
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"input1", input);
        return variables;
    }

    protected void waitASignificantAmountOfTime() {
        DateTime now = new DateTime((Object)ClockUtil.getCurrentTime());
        ClockUtil.setCurrentTime((Date)now.plusSeconds(10).toDate());
    }
}

