/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.test.AbstractProcessEngineTestCase;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.jobexecutor.ControllableJobExecutor;
import org.camunda.bpm.engine.test.jobexecutor.RecordingAcquireJobsRunnable;

public class JobAcquisitionBackoffIdleTest
extends AbstractProcessEngineTestCase {
    protected ControllableJobExecutor jobExecutor;
    protected ConcurrencyTestCase.ThreadControl acquisitionThread;
    public static final int BASE_IDLE_WAIT_TIME = 5000;
    public static final int MAX_IDLE_WAIT_TIME = 30000;

    protected void initializeProcessEngine() {
        this.jobExecutor = new ControllableJobExecutor();
        this.jobExecutor.setMaxJobsPerAcquisition(1);
        this.jobExecutor.setWaitTimeInMillis(5000);
        this.jobExecutor.setMaxWait(30000L);
        this.acquisitionThread = this.jobExecutor.getAcquisitionThreadControl();
        ProcessEngineConfigurationImpl engineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"camunda.cfg.xml");
        engineConfiguration.setJobExecutor((JobExecutor)this.jobExecutor);
        this.processEngine = engineConfiguration.buildProcessEngine();
    }

    protected void closeDownProcessEngine() {
        super.closeDownProcessEngine();
        this.processEngine.close();
        this.processEngine = null;
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testIdlingAfterConcurrentJobAddedNotification() {
        this.jobExecutor.start();
        this.acquisitionThread.waitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        this.acquisitionThread.makeContinueAndWaitForSync();
        this.assertJobExecutorWaitEvent(0L);
        this.triggerReconfigurationAndNextCycle();
        this.assertJobExecutorWaitEvent(0L);
        this.triggerReconfigurationAndNextCycle();
        this.assertJobExecutorWaitEvent(5000L);
        this.triggerReconfigurationAndNextCycle();
        this.assertJobExecutorWaitEvent(10000L);
        this.triggerReconfigurationAndNextCycle();
        this.assertJobExecutorWaitEvent(20000L);
        this.triggerReconfigurationAndNextCycle();
        this.assertJobExecutorWaitEvent(30000L);
    }

    protected void triggerReconfigurationAndNextCycle() {
        this.acquisitionThread.makeContinueAndWaitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
    }

    protected void assertJobExecutorWaitEvent(long expectedTimeout) {
        List<RecordingAcquireJobsRunnable.RecordedWaitEvent> waitEvents = this.jobExecutor.getAcquireJobsRunnable().getWaitEvents();
        JobAcquisitionBackoffIdleTest.assertEquals((int)1, (int)waitEvents.size());
        JobAcquisitionBackoffIdleTest.assertEquals((long)expectedTimeout, (long)waitEvents.get(0).getTimeBetweenAcquisitions());
        waitEvents.clear();
    }
}

