/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.ProcessApplicationService;
import org.camunda.bpm.ProcessEngineService;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.application.ProcessApplicationInfo;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.container.ExecutorService;
import org.camunda.bpm.container.RuntimeContainerDelegate;
import org.camunda.bpm.container.impl.ContainerIntegrationLogger;
import org.camunda.bpm.container.impl.deployment.DeployProcessArchivesStep;
import org.camunda.bpm.container.impl.deployment.ParseProcessesXmlStep;
import org.camunda.bpm.container.impl.deployment.PostDeployInvocationStep;
import org.camunda.bpm.container.impl.deployment.PreUndeployInvocationStep;
import org.camunda.bpm.container.impl.deployment.ProcessesXmlStartProcessEnginesStep;
import org.camunda.bpm.container.impl.deployment.ProcessesXmlStopProcessEnginesStep;
import org.camunda.bpm.container.impl.deployment.StartProcessApplicationServiceStep;
import org.camunda.bpm.container.impl.deployment.StopProcessApplicationServiceStep;
import org.camunda.bpm.container.impl.deployment.UndeployProcessArchivesStep;
import org.camunda.bpm.container.impl.jmx.MBeanServiceContainer;
import org.camunda.bpm.container.impl.jmx.services.JmxManagedProcessApplication;
import org.camunda.bpm.container.impl.jmx.services.JmxManagedProcessEngine;
import org.camunda.bpm.container.impl.spi.PlatformServiceContainer;
import org.camunda.bpm.container.impl.spi.ServiceTypes;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class RuntimeContainerDelegateImpl
implements RuntimeContainerDelegate,
ProcessEngineService,
ProcessApplicationService {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;
    protected MBeanServiceContainer serviceContainer = new MBeanServiceContainer();
    public static final String SERVICE_NAME_EXECUTOR = "executor-service";
    public static final String SERVICE_NAME_PLATFORM_PLUGINS = "bpm-platform-plugins";

    @Override
    public void registerProcessEngine(ProcessEngine processEngine) {
        EnsureUtil.ensureNotNull("Cannot register process engine in Jmx Runtime Container", "process engine", (Object)processEngine);
        String processEngineName = processEngine.getName();
        JmxManagedProcessEngine managedProcessEngine = new JmxManagedProcessEngine(processEngine);
        this.serviceContainer.startService(ServiceTypes.PROCESS_ENGINE, processEngineName, managedProcessEngine);
    }

    @Override
    public void unregisterProcessEngine(ProcessEngine processEngine) {
        EnsureUtil.ensureNotNull("Cannot unregister process engine in Jmx Runtime Container", "process engine", (Object)processEngine);
        this.serviceContainer.stopService(ServiceTypes.PROCESS_ENGINE, processEngine.getName());
    }

    @Override
    public void deployProcessApplication(AbstractProcessApplication processApplication) {
        EnsureUtil.ensureNotNull("Process application", (Object)processApplication);
        String operationName = "Deployment of Process Application " + processApplication.getName();
        this.serviceContainer.createDeploymentOperation(operationName).addAttachment("processApplication", processApplication).addStep(new ParseProcessesXmlStep()).addStep(new ProcessesXmlStartProcessEnginesStep()).addStep(new DeployProcessArchivesStep()).addStep(new StartProcessApplicationServiceStep()).addStep(new PostDeployInvocationStep()).execute();
        LOG.paDeployed(processApplication.getName());
    }

    @Override
    public void undeployProcessApplication(AbstractProcessApplication processApplication) {
        EnsureUtil.ensureNotNull("Process application", (Object)processApplication);
        String processAppName = processApplication.getName();
        if (this.serviceContainer.getService(ServiceTypes.PROCESS_APPLICATION, processAppName) == null) {
            return;
        }
        String operationName = "Undeployment of Process Application " + processAppName;
        this.serviceContainer.createUndeploymentOperation(operationName).addAttachment("processApplication", processApplication).addStep(new PreUndeployInvocationStep()).addStep(new UndeployProcessArchivesStep()).addStep(new ProcessesXmlStopProcessEnginesStep()).addStep(new StopProcessApplicationServiceStep()).execute();
        LOG.paUndeployed(processApplication.getName());
    }

    @Override
    public ProcessEngineService getProcessEngineService() {
        return this;
    }

    @Override
    public ProcessApplicationService getProcessApplicationService() {
        return this;
    }

    @Override
    public ExecutorService getExecutorService() {
        return (ExecutorService)this.serviceContainer.getServiceValue(ServiceTypes.BPM_PLATFORM, SERVICE_NAME_EXECUTOR);
    }

    @Override
    public ProcessEngine getDefaultProcessEngine() {
        return (ProcessEngine)this.serviceContainer.getServiceValue(ServiceTypes.PROCESS_ENGINE, "default");
    }

    @Override
    public ProcessEngine getProcessEngine(String name) {
        return (ProcessEngine)this.serviceContainer.getServiceValue(ServiceTypes.PROCESS_ENGINE, name);
    }

    @Override
    public List<ProcessEngine> getProcessEngines() {
        return this.serviceContainer.getServiceValuesByType(ServiceTypes.PROCESS_ENGINE);
    }

    @Override
    public Set<String> getProcessEngineNames() {
        HashSet<String> processEngineNames = new HashSet<String>();
        List<ProcessEngine> processEngines = this.getProcessEngines();
        for (ProcessEngine processEngine : processEngines) {
            processEngineNames.add(processEngine.getName());
        }
        return processEngineNames;
    }

    @Override
    public Set<String> getProcessApplicationNames() {
        List processApplications = this.serviceContainer.getServiceValuesByType(ServiceTypes.PROCESS_APPLICATION);
        HashSet<String> processApplicationNames = new HashSet<String>();
        for (JmxManagedProcessApplication jmxManagedProcessApplication : processApplications) {
            processApplicationNames.add(jmxManagedProcessApplication.getProcessApplicationName());
        }
        return processApplicationNames;
    }

    @Override
    public ProcessApplicationInfo getProcessApplicationInfo(String processApplicationName) {
        JmxManagedProcessApplication processApplicationService = (JmxManagedProcessApplication)this.serviceContainer.getServiceValue(ServiceTypes.PROCESS_APPLICATION, processApplicationName);
        if (processApplicationService == null) {
            return null;
        }
        return processApplicationService.getProcessApplicationInfo();
    }

    @Override
    public ProcessApplicationReference getDeployedProcessApplication(String processApplicationName) {
        JmxManagedProcessApplication processApplicationService = (JmxManagedProcessApplication)this.serviceContainer.getServiceValue(ServiceTypes.PROCESS_APPLICATION, processApplicationName);
        if (processApplicationService == null) {
            return null;
        }
        return processApplicationService.getProcessApplicationReference();
    }

    public PlatformServiceContainer getServiceContainer() {
        return this.serviceContainer;
    }
}

