/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.authorization;

import org.camunda.bpm.engine.authorization.Permission;

public enum Permissions implements Permission
{
    NONE("NONE", 0),
    ALL("ALL", Integer.MAX_VALUE),
    READ("READ", 2),
    UPDATE("UPDATE", 4),
    CREATE("CREATE", 8),
    DELETE("DELETE", 16),
    ACCESS("ACCESS", 32),
    READ_TASK("READ_TASK", 64),
    UPDATE_TASK("UPDATE_TASK", 128),
    CREATE_INSTANCE("CREATE_INSTANCE", 256),
    READ_INSTANCE("READ_INSTANCE", 512),
    UPDATE_INSTANCE("UPDATE_INSTANCE", 1024),
    DELETE_INSTANCE("DELETE_INSTANCE", 2048),
    READ_HISTORY("READ_HISTORY", 4096),
    DELETE_HISTORY("DELETE_HISTORY", 8192);

    private String name;
    private int id;

    private Permissions(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getValue() {
        return this.id;
    }

    public static Permission forName(String name) {
        return Permissions.valueOf(name);
    }
}

