/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.AbstractSetJobStateCmd;
import org.camunda.bpm.engine.impl.cmd.AbstractSetStateCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.TaskManager;

public abstract class AbstractSetProcessInstanceStateCmd
extends AbstractSetStateCmd {
    protected final String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;

    public AbstractSetProcessInstanceStateCmd(String processInstanceId, String processDefinitionId, String processDefinitionKey) {
        super(true, null);
        this.processInstanceId = processInstanceId;
        this.processDefinitionId = processDefinitionId;
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    protected void checkParameters(CommandContext commandContext) {
        if (this.processInstanceId == null && this.processDefinitionId == null && this.processDefinitionKey == null) {
            throw new ProcessEngineException("ProcessInstanceId, ProcessDefinitionId nor ProcessDefinitionKey cannot be null.");
        }
    }

    @Override
    protected void checkAuthorization(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        if (this.processInstanceId != null) {
            authorizationManager.checkUpdateProcessInstanceById(this.processInstanceId);
        } else if (this.processDefinitionId != null) {
            authorizationManager.checkUpdateProcessInstanceByProcessDefinitionId(this.processDefinitionId);
        } else if (this.processDefinitionKey != null) {
            authorizationManager.checkUpdateProcessInstanceByProcessDefinitionKey(this.processDefinitionKey);
        }
    }

    @Override
    protected void updateSuspensionState(CommandContext commandContext, SuspensionState suspensionState) {
        ExecutionManager executionManager = commandContext.getExecutionManager();
        TaskManager taskManager = commandContext.getTaskManager();
        ExternalTaskManager externalTaskManager = commandContext.getExternalTaskManager();
        if (this.processInstanceId != null) {
            executionManager.updateExecutionSuspensionStateByProcessInstanceId(this.processInstanceId, suspensionState);
            taskManager.updateTaskSuspensionStateByProcessInstanceId(this.processInstanceId, suspensionState);
            externalTaskManager.updateExternalTaskSuspensionStateByProcessInstanceId(this.processInstanceId, suspensionState);
        } else if (this.processDefinitionId != null) {
            executionManager.updateExecutionSuspensionStateByProcessDefinitionId(this.processDefinitionId, suspensionState);
            taskManager.updateTaskSuspensionStateByProcessDefinitionId(this.processDefinitionId, suspensionState);
            externalTaskManager.updateExternalTaskSuspensionStateByProcessDefinitionId(this.processDefinitionId, suspensionState);
        } else if (this.processDefinitionKey != null) {
            executionManager.updateExecutionSuspensionStateByProcessDefinitionKey(this.processDefinitionKey, suspensionState);
            taskManager.updateTaskSuspensionStateByProcessDefinitionKey(this.processDefinitionKey, suspensionState);
            externalTaskManager.updateExternalTaskSuspensionStateByProcessDefinitionKey(this.processDefinitionKey, suspensionState);
        }
    }

    @Override
    protected void logUserOperation(CommandContext commandContext) {
        PropertyChange propertyChange = new PropertyChange("suspensionState", null, this.getNewSuspensionState().getName());
        commandContext.getOperationLogManager().logProcessInstanceOperation(this.getLogEntryOperation(), this.processInstanceId, this.processDefinitionId, this.processDefinitionKey, propertyChange);
    }

    @Override
    protected abstract AbstractSetJobStateCmd getNextCommand();
}

