/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.incident;

import java.util.List;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.incident.IncidentHandler;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.runtime.Incident;

public class DefaultIncidentHandler
implements IncidentHandler {
    protected String type;

    public DefaultIncidentHandler(String type) {
        this.type = type;
    }

    @Override
    public String getIncidentHandlerType() {
        return this.type;
    }

    @Override
    public void handleIncident(String processDefinitionId, String activityId, String executionId, String jobId, String message) {
        this.createIncident(processDefinitionId, activityId, executionId, jobId, message);
    }

    public Incident createIncident(String processDefinitionId, String activityId, String executionId, String jobId, String message) {
        IncidentEntity newIncident;
        if (executionId != null) {
            newIncident = IncidentEntity.createAndInsertIncident(this.type, executionId, jobId, message);
            newIncident.createRecursiveIncidents();
        } else {
            newIncident = IncidentEntity.createAndInsertIncident(this.type, processDefinitionId, activityId, jobId, message);
        }
        return newIncident;
    }

    @Override
    public void resolveIncident(String processDefinitionId, String activityId, String executionId, String configuration) {
        this.removeIncident(processDefinitionId, activityId, executionId, configuration, true);
    }

    @Override
    public void deleteIncident(String processDefinitionId, String activityId, String executionId, String configuration) {
        this.removeIncident(processDefinitionId, activityId, executionId, configuration, false);
    }

    protected void removeIncident(String processDefinitionId, String activityId, String executionId, String configuration, boolean incidentResolved) {
        List<Incident> incidents = Context.getCommandContext().getIncidentManager().findIncidentByConfiguration(configuration);
        for (Incident currentIncident : incidents) {
            IncidentEntity incident = (IncidentEntity)currentIncident;
            if (incidentResolved) {
                incident.resolve();
                continue;
            }
            incident.delete();
        }
    }
}

