/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableInstance;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.DbEntityLifecycleAware;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.util.ByteArrayField;
import org.camunda.bpm.engine.impl.persistence.entity.util.TypedValueField;
import org.camunda.bpm.engine.impl.persistence.entity.util.TypedValueUpdateListener;
import org.camunda.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class VariableInstanceEntity
implements VariableInstance,
CoreVariableInstance,
ValueFields,
DbEntity,
DbEntityLifecycleAware,
TypedValueUpdateListener,
HasDbRevision,
Serializable {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision;
    protected String name;
    protected String processInstanceId;
    protected String executionId;
    protected String taskId;
    protected String caseInstanceId;
    protected String caseExecutionId;
    protected String activityInstanceId;
    protected Long longValue;
    protected Double doubleValue;
    protected String textValue;
    protected String textValue2;
    protected ByteArrayField byteArrayField = new ByteArrayField(this);
    protected TypedValueField typedValueField = new TypedValueField(this, true);
    boolean forcedUpdate;
    protected String configuration;
    protected long sequenceCounter = 1L;
    protected boolean isConcurrentLocal = false;
    protected boolean isTransient = false;

    public VariableInstanceEntity() {
        this.typedValueField.addImplicitUpdateListener(this);
    }

    public static VariableInstanceEntity createAndInsert(String name, TypedValue value) {
        VariableInstanceEntity variableInstance = VariableInstanceEntity.create(name, value);
        VariableInstanceEntity.insert(variableInstance);
        return variableInstance;
    }

    public static void insert(VariableInstanceEntity variableInstance) {
        Context.getCommandContext().getDbEntityManager().insert(variableInstance);
    }

    public static VariableInstanceEntity create(String name, TypedValue value) {
        VariableInstanceEntity variableInstance = new VariableInstanceEntity();
        variableInstance.name = name;
        variableInstance.setValue(value);
        return variableInstance;
    }

    public void delete() {
        this.clearValueFields();
        if (!this.isTransient) {
            Context.getCommandContext().getDbEntityManager().delete(this);
        }
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        if (this.typedValueField.getSerializerName() != null) {
            persistentState.put("serializerName", this.typedValueField.getSerializerName());
        }
        if (this.longValue != null) {
            persistentState.put("longValue", this.longValue);
        }
        if (this.doubleValue != null) {
            persistentState.put("doubleValue", this.doubleValue);
        }
        if (this.textValue != null) {
            persistentState.put("textValue", this.textValue);
        }
        if (this.textValue2 != null) {
            persistentState.put("textValue2", this.textValue2);
        }
        if (this.byteArrayField.getByteArrayId() != null) {
            persistentState.put("byteArrayValueId", this.byteArrayField.getByteArrayId());
        }
        if (this.forcedUpdate) {
            persistentState.put("forcedUpdate", Boolean.TRUE);
        }
        persistentState.put("sequenceCounter", this.getSequenceCounter());
        persistentState.put("concurrentLocal", this.isConcurrentLocal);
        return persistentState;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    public String getByteArrayValueId() {
        return this.byteArrayField.getByteArrayId();
    }

    public void setByteArrayValueId(String byteArrayValueId) {
        this.byteArrayField.setByteArrayId(byteArrayValueId);
    }

    @Override
    public byte[] getByteArrayValue() {
        return this.byteArrayField.getByteArrayValue();
    }

    @Override
    public void setByteArrayValue(byte[] bytes) {
        if (!this.isTransient) {
            this.byteArrayField.setByteArrayValue(bytes);
        }
    }

    protected void deleteByteArrayValue() {
        this.byteArrayField.deleteByteArrayValue();
    }

    @Override
    public Object getValue() {
        return this.typedValueField.getValue();
    }

    @Override
    public TypedValue getTypedValue() {
        return this.typedValueField.getTypedValue();
    }

    @Override
    public TypedValue getTypedValue(boolean deserializeValue) {
        return this.typedValueField.getTypedValue(deserializeValue);
    }

    public TypedValue setValue(TypedValue value) {
        this.clearValueFields();
        return this.typedValueField.setValue(value);
    }

    public void clearValueFields() {
        this.longValue = null;
        this.doubleValue = null;
        this.textValue = null;
        this.textValue2 = null;
        this.typedValueField.clear();
        if (this.byteArrayField.getByteArrayId() != null) {
            this.deleteByteArrayValue();
            this.setByteArrayValueId(null);
        }
    }

    @Override
    public String getTypeName() {
        return this.typedValueField.getTypeName();
    }

    @Override
    public void postLoad() {
        this.typedValueField.postLoad();
    }

    public ExecutionEntity getExecution() {
        if (this.executionId != null) {
            return Context.getCommandContext().getExecutionManager().findExecutionById(this.executionId);
        }
        return null;
    }

    public void setExecution(ExecutionEntity execution) {
        this.executionId = execution.getId();
        this.processInstanceId = execution.getProcessInstanceId();
        this.forcedUpdate = true;
    }

    public CaseExecutionEntity getCaseExecution() {
        if (this.caseExecutionId != null) {
            return Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(this.caseExecutionId);
        }
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTextValue() {
        return this.textValue;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    @Override
    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    @Override
    public Long getLongValue() {
        return this.longValue;
    }

    @Override
    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    @Override
    public Double getDoubleValue() {
        return this.doubleValue;
    }

    @Override
    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    public void setSerializer(TypedValueSerializer<?> serializer) {
        this.typedValueField.setSerializerName(serializer.getName());
    }

    public void setSerializerName(String type) {
        this.typedValueField.setSerializerName(type);
    }

    public TypedValueSerializer<?> getSerializer() {
        return this.typedValueField.getSerializer();
    }

    @Override
    public String getTextValue2() {
        return this.textValue2;
    }

    @Override
    public void setTextValue2(String textValue2) {
        this.textValue2 = textValue2;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    public String getSerializerName() {
        return this.typedValueField.getSerializerName();
    }

    @Override
    public String getErrorMessage() {
        return this.typedValueField.getErrorMessage();
    }

    public String getVariableScopeId() {
        if (this.taskId != null) {
            return this.taskId;
        }
        if (this.executionId != null) {
            return this.executionId;
        }
        return this.caseExecutionId;
    }

    protected VariableScope getVariableScope() {
        if (this.taskId != null) {
            return this.getTask();
        }
        if (this.executionId != null) {
            return this.getExecution();
        }
        if (this.caseExecutionId != null) {
            return this.getCaseExecution();
        }
        return null;
    }

    protected TaskEntity getTask() {
        if (this.taskId != null) {
            return Context.getCommandContext().getTaskManager().findTaskById(this.taskId);
        }
        return null;
    }

    public long getSequenceCounter() {
        return this.sequenceCounter;
    }

    public void setSequenceCounter(long sequenceCounter) {
        this.sequenceCounter = sequenceCounter;
    }

    public void incrementSequenceCounter() {
        ++this.sequenceCounter;
    }

    public boolean isConcurrentLocal() {
        return this.isConcurrentLocal;
    }

    public void setConcurrentLocal(boolean isConcurrentLocal) {
        this.isConcurrentLocal = isConcurrentLocal;
    }

    @Override
    public void onImplicitValueUpdate(final TypedValue updatedValue) {
        ProcessApplicationReference targetProcessApplication = this.getContextProcessApplication();
        if (targetProcessApplication != null) {
            Context.executeWithinProcessApplication(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    VariableInstanceEntity.this.getVariableScope().setVariableLocal(VariableInstanceEntity.this.name, updatedValue);
                    return null;
                }
            }, targetProcessApplication);
        } else {
            this.getVariableScope().setVariableLocal(this.name, updatedValue);
        }
    }

    protected ProcessApplicationReference getContextProcessApplication() {
        if (this.taskId != null) {
            return ProcessApplicationContextUtil.getTargetProcessApplication(this.getTask());
        }
        if (this.executionId != null) {
            return ProcessApplicationContextUtil.getTargetProcessApplication(this.getExecution());
        }
        if (this.caseExecutionId != null) {
            return ProcessApplicationContextUtil.getTargetProcessApplication(this.getCaseExecution());
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", revision=" + this.revision + ", name=" + this.name + ", processInstanceId=" + this.processInstanceId + ", executionId=" + this.executionId + ", caseInstanceId=" + this.caseInstanceId + ", caseExecutionId=" + this.caseExecutionId + ", taskId=" + this.taskId + ", activityInstanceId=" + this.activityInstanceId + ", longValue=" + this.longValue + ", doubleValue=" + this.doubleValue + ", textValue=" + this.textValue + ", textValue2=" + this.textValue2 + ", byteArrayValueId=" + this.getByteArrayValueId() + ", forcedUpdate=" + this.forcedUpdate + ", configuration=" + this.configuration + ", isConcurrentLocal=" + this.isConcurrentLocal + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableInstanceEntity other = (VariableInstanceEntity)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public boolean isTransient() {
        return this.isTransient;
    }
}

