/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.camunda.bpm.engine.migration;

import java.util.List;

/**
 * @author Thorben Lindhauer
 *
 */
public interface MigrationInstructionInstanceValidationFailure {

  /**
   * @return the reason why the instruction cannot be applied
   */
  String getErrorMessage();

  /**
   * @return the instruction that cannot be applied
   */
  MigrationInstruction getMigrationInstruction();

  /**
   * @return the list of activity instances that cannot be migrated with the given instruction
   */
  List<String> getActivityInstanceIds();

}
