/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.camunda.bpm.application.impl.EmbeddedProcessApplication;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.test.ResourceProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class ProcessApplicationEventListenerTest
extends ResourceProcessEngineTestCase {
    public ProcessApplicationEventListenerTest() {
        super("org/camunda/bpm/application/impl/event/pa.event.listener.camunda.cfg.xml");
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void closeDownProcessEngine() {
        this.managementService.unregisterProcessApplication(this.deploymentId, false);
        super.closeDownProcessEngine();
    }

    @Deployment(resources={"org/camunda/bpm/application/impl/event/ProcessApplicationEventListenerTest.testExecutionListener.bpmn20.xml"})
    public void testExecutionListenerNull() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("startToEnd");
    }

    @Deployment
    public void testExecutionListener() {
        final AtomicInteger eventCount = new AtomicInteger();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public ExecutionListener getExecutionListener() {
                return new ExecutionListener(){

                    public void notify(DelegateExecution execution) throws Exception {
                        eventCount.incrementAndGet();
                    }
                };
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("startToEnd");
        ProcessApplicationEventListenerTest.assertEquals((int)5, (int)eventCount.get());
    }

    @Deployment
    public void testExecutionListenerWithErrorBoundaryEvent() {
        final AtomicInteger eventCount = new AtomicInteger();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public ExecutionListener getExecutionListener() {
                return new ExecutionListener(){

                    public void notify(DelegateExecution execution) throws Exception {
                        eventCount.incrementAndGet();
                    }
                };
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("executionListener");
        ProcessApplicationEventListenerTest.assertEquals((int)8, (int)eventCount.get());
        eventCount.set(0);
        this.runtimeService.startProcessInstanceByKey("executionListener", Collections.singletonMap("shouldThrowError", true));
        ProcessApplicationEventListenerTest.assertEquals((int)10, (int)eventCount.get());
    }

    @Deployment
    public void testExecutionListenerWithTimerBoundaryEvent() {
        final AtomicInteger eventCount = new AtomicInteger();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public ExecutionListener getExecutionListener() {
                return new ExecutionListener(){

                    public void notify(DelegateExecution execution) throws Exception {
                        eventCount.incrementAndGet();
                    }
                };
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("executionListener");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        ProcessApplicationEventListenerTest.assertEquals((int)8, (int)eventCount.get());
        eventCount.set(0);
        this.runtimeService.startProcessInstanceByKey("executionListener");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        ProcessApplicationEventListenerTest.assertEquals((int)10, (int)eventCount.get());
    }

    @Deployment
    public void testExecutionListenerWithSignalBoundaryEvent() {
        final AtomicInteger eventCount = new AtomicInteger();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public ExecutionListener getExecutionListener() {
                return new ExecutionListener(){

                    public void notify(DelegateExecution execution) throws Exception {
                        eventCount.incrementAndGet();
                    }
                };
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("executionListener");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        ProcessApplicationEventListenerTest.assertEquals((int)8, (int)eventCount.get());
        eventCount.set(0);
        this.runtimeService.startProcessInstanceByKey("executionListener");
        this.runtimeService.signalEventReceived("signal");
        ProcessApplicationEventListenerTest.assertEquals((int)10, (int)eventCount.get());
    }

    @Deployment
    public void testExecutionListenerWithMultiInstanceBody() {
        final AtomicInteger eventCountForMultiInstanceBody = new AtomicInteger();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public ExecutionListener getExecutionListener() {
                return new ExecutionListener(){

                    public void notify(DelegateExecution execution) throws Exception {
                        if ("miTasks#multiInstanceBody".equals(execution.getCurrentActivityId()) && ("start".equals(execution.getEventName()) || "end".equals(execution.getEventName()))) {
                            eventCountForMultiInstanceBody.incrementAndGet();
                        }
                    }
                };
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("executionListener");
        List miTasks = this.taskService.createTaskQuery().list();
        for (Task task : miTasks) {
            this.taskService.complete(task.getId());
        }
        ProcessApplicationEventListenerTest.assertEquals((int)2, (int)eventCountForMultiInstanceBody.get());
    }

    @Deployment
    public void testTaskListener() {
        final ArrayList events = new ArrayList();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public TaskListener getTaskListener() {
                return new TaskListener(){

                    public void notify(DelegateTask delegateTask) {
                        events.add(delegateTask.getEventName());
                    }
                };
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        ProcessInstance taskListenerProcess = this.runtimeService.startProcessInstanceByKey("taskListenerProcess");
        ProcessApplicationEventListenerTest.assertEquals((int)1, (int)events.size());
        ProcessApplicationEventListenerTest.assertEquals((String)"create", (String)((String)events.get(0)));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setAssignee(task.getId(), "jonny");
        ProcessApplicationEventListenerTest.assertEquals((int)2, (int)events.size());
        ProcessApplicationEventListenerTest.assertEquals((String)"assignment", (String)((String)events.get(1)));
        this.taskService.complete(task.getId());
        ProcessApplicationEventListenerTest.assertEquals((int)4, (int)events.size());
        ProcessApplicationEventListenerTest.assertEquals((String)"complete", (String)((String)events.get(2)));
        ProcessApplicationEventListenerTest.assertEquals((String)"create", (String)((String)events.get(3)));
        this.runtimeService.deleteProcessInstance(taskListenerProcess.getProcessInstanceId(), "test delete event");
        ProcessApplicationEventListenerTest.assertEquals((int)5, (int)events.size());
        ProcessApplicationEventListenerTest.assertEquals((String)"delete", (String)((String)events.get(4)));
    }

    @Deployment
    public void testIntermediateTimerEvent() {
        final ArrayList timerEvents = new ArrayList();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public ExecutionListener getExecutionListener() {
                return new ExecutionListener(){

                    public void notify(DelegateExecution delegateExecution) {
                        String currentActivityId = delegateExecution.getCurrentActivityId();
                        String eventName = delegateExecution.getEventName();
                        if ("timer".equals(currentActivityId) && ("start".equals(eventName) || "end".equals(eventName))) {
                            timerEvents.add(delegateExecution.getEventName());
                        }
                    }
                };
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        ProcessApplicationEventListenerTest.assertEquals((int)2, (int)timerEvents.size());
        ProcessApplicationEventListenerTest.assertEquals((String)"start", (String)((String)timerEvents.get(0)));
        ProcessApplicationEventListenerTest.assertEquals((String)"end", (String)((String)timerEvents.get(1)));
    }

    @Deployment
    public void testIntermediateSignalEvent() {
        final ArrayList timerEvents = new ArrayList();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public ExecutionListener getExecutionListener() {
                return new ExecutionListener(){

                    public void notify(DelegateExecution delegateExecution) {
                        String currentActivityId = delegateExecution.getCurrentActivityId();
                        String eventName = delegateExecution.getEventName();
                        if ("signal".equals(currentActivityId) && ("start".equals(eventName) || "end".equals(eventName))) {
                            timerEvents.add(delegateExecution.getEventName());
                        }
                    }
                };
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.signalEventReceived("abort");
        ProcessApplicationEventListenerTest.assertEquals((int)2, (int)timerEvents.size());
        ProcessApplicationEventListenerTest.assertEquals((String)"start", (String)((String)timerEvents.get(0)));
        ProcessApplicationEventListenerTest.assertEquals((String)"end", (String)((String)timerEvents.get(1)));
    }
}

