/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.RuntimeServiceImpl;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class ProcessInstanceAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected static final String MESSAGE_START_PROCESS_KEY = "messageStartProcess";
    protected static final String MESSAGE_BOUNDARY_PROCESS_KEY = "messageBoundaryProcess";
    protected static final String SIGNAL_BOUNDARY_PROCESS_KEY = "signalBoundaryProcess";
    protected static final String SIGNAL_START_PROCESS_KEY = "signalStartProcess";
    protected static final String THROW_WARNING_SIGNAL_PROCESS_KEY = "throwWarningSignalProcess";
    protected static final String THROW_ALERT_SIGNAL_PROCESS_KEY = "throwAlertSignalProcess";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/messageStartEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/messageBoundaryEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/signalBoundaryEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/signalStartEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/throwWarningSignalEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/throwAlertSignalEventProcess.bpmn20.xml").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
    }

    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testSimpleQueryWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)instance);
        ProcessInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)instance.getId());
    }

    public void testSimpleQueryWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)instance);
        ProcessInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)instance.getId());
    }

    public void testSimpleQueryWithReadInstancesPermissionOnOneTaskProcess() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)instance);
        ProcessInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)instance.getId());
    }

    public void testSimpleQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)instance);
        ProcessInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)instance.getId());
    }

    public void testQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithReadPermissionOnProcessInstance() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)instance);
        ProcessInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)instance.getId());
    }

    public void testQueryWithReadPermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 7);
    }

    public void testQueryWithReadInstancesPermissionOnOneTaskProcess() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 3);
    }

    public void testQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 7);
    }

    public void testStartProcessInstanceByKeyWithoutAuthorization() {
        try {
            this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByKeyWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'oneTaskProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByKeyWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByKey() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testStartProcessInstanceByIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceById(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByIdWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceById(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'oneTaskProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByIdWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceById(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceById() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testStartProcessInstanceAtActivitiesByKey() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(PROCESS_KEY).startBeforeActivity("theTask")).execute();
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testStartProcessInstanceAtActivitiesByKeyWithoutAuthorization() {
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(PROCESS_KEY).startBeforeActivity("theTask")).execute();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceAtActivitiesByKeyWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(PROCESS_KEY).startBeforeActivity("theTask")).execute();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'oneTaskProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceAtActivitiesByKeyWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(PROCESS_KEY).startBeforeActivity("theTask")).execute();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceAtActivitiesById() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinitionId).startBeforeActivity("theTask")).execute();
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testStartProcessInstanceAtActivitiesByIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinitionId).startBeforeActivity("theTask")).execute();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceAtActivitiesByIdWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinitionId).startBeforeActivity("theTask")).execute();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'oneTaskProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceAtActivitiesByIdWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinitionId).startBeforeActivity("theTask")).execute();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessageWithoutAuthorization() {
        try {
            this.runtimeService.startProcessInstanceByMessage("startInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessageWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.startProcessInstanceByMessage("startInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'messageStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessageWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.startProcessInstanceByMessage("startInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessage() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.runtimeService.startProcessInstanceByMessage("startInvoiceMessage");
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testStartProcessInstanceByMessageAndProcDefIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(MESSAGE_START_PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("startInvoiceMessage", processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessageAndProcDefIdWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(MESSAGE_START_PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("startInvoiceMessage", processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'messageStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessageAndProcDefIdWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        String processDefinitionId = this.selectProcessDefinitionByKey(MESSAGE_START_PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("startInvoiceMessage", processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessageAndProcDefId() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(MESSAGE_START_PROCESS_KEY).getId();
        this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("startInvoiceMessage", processDefinitionId);
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testDeleteProcessInstanceWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.deleteProcessInstance(processInstanceId, null);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete a process instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.DELETE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.DELETE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testDeleteProcessInstanceWithDeletePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.DELETE});
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        this.assertProcessEnded(processInstanceId);
        this.enableAuthorization();
    }

    public void testDeleteProcessInstanceWithDeletePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.DELETE});
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        this.assertProcessEnded(processInstanceId);
        this.enableAuthorization();
    }

    public void testDeleteProcessInstanceWithDeleteInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_INSTANCE});
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        this.assertProcessEnded(processInstanceId);
        this.enableAuthorization();
    }

    public void testDeleteProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.DELETE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_INSTANCE});
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        this.assertProcessEnded(processInstanceId);
        this.enableAuthorization();
    }

    public void testGetActiveActivityIdsWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.getActiveActivityIds(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to retrieve active ativity ids");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    public void testGetActiveActivityIdsWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        List activityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityIds);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)activityIds.isEmpty());
    }

    public void testGetActiveActivityIdsWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        List activityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityIds);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)activityIds.isEmpty());
    }

    public void testGetActiveActivityIdsWithReadInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List activityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityIds);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)activityIds.isEmpty());
    }

    public void testGetActiveActivityIds() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List activityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityIds);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)activityIds.isEmpty());
    }

    public void testGetActivityInstanceWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.getActivityInstance(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to retrieve ativity instances");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetActivityInstanceWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityInstance);
    }

    public void testGetActivityInstanceWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityInstance);
    }

    public void testGetActivityInstanceWithReadInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityInstance);
    }

    public void testGetActivityInstanceIds() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityInstance);
    }

    public void testSignalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.signal(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to signal an execution");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSignalWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signal(processInstanceId);
        this.assertProcessEnded(processInstanceId);
    }

    public void testSignalWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signal(processInstanceId);
        this.assertProcessEnded(processInstanceId);
    }

    public void testSignalWithUpdateInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.signal(processInstanceId);
        this.assertProcessEnded(processInstanceId);
    }

    public void testSignal() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityInstance);
    }

    public void testSignalEventReceivedWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.runtimeService.signalEventReceived("alert");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to trigger a signal event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(SIGNAL_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSignalEventReceivedWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signalEventReceived("alert");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceivedWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signalEventReceived("alert");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceivedWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.signalEventReceived("alert");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceived() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.signalEventReceived("alert");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceivedTwoExecutionsShouldFail() {
        String firstProcessInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        String secondProcessInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.signalEventReceived("alert");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to trigger a signal event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(secondProcessInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(SIGNAL_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSignalEventReceivedTwoExecutionsShouldSuccess() {
        String firstProcessInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        String secondProcessInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, secondProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signalEventReceived("alert");
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)tasks.isEmpty());
        for (Task task : tasks) {
            ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
        }
        this.enableAuthorization();
    }

    public void testSignalEventReceivedByExecutionIdWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        String executionId = this.selectSingleTask().getExecutionId();
        try {
            this.runtimeService.signalEventReceived("alert", executionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to trigger a signal event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(SIGNAL_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSignalEventReceivedByExecutionIdWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.signalEventReceived("alert", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceivedByExecutionIdWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.signalEventReceived("alert", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceivedByExecutionIdWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.signalEventReceived("alert", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceivedByExecutionId() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.signalEventReceived("alert", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testStartProcessInstanceBySignalEventReceivedWithoutAuthorization() {
        try {
            this.runtimeService.signalEventReceived("warning");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceBySignalEventReceivedWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.signalEventReceived("warning");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'signalStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceBySignalEventReceived() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.runtimeService.signalEventReceived("warning");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
    }

    public void FAILING_testStartProcessInstanceByThrowSignalEventWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, THROW_WARNING_SIGNAL_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.startProcessInstanceByKey(THROW_WARNING_SIGNAL_PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'signalStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByThrowSignalEvent() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, THROW_WARNING_SIGNAL_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.runtimeService.startProcessInstanceByKey(THROW_WARNING_SIGNAL_PROCESS_KEY);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
    }

    public void FAILING_testThrowSignalEventWithoutAuthorization() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, THROW_ALERT_SIGNAL_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceByKey(THROW_ALERT_SIGNAL_PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(SIGNAL_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testThrowSignalEvent() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, THROW_ALERT_SIGNAL_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.startProcessInstanceByKey(THROW_ALERT_SIGNAL_PROCESS_KEY);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testMessageEventReceivedWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        String executionId = this.selectSingleTask().getExecutionId();
        try {
            this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to trigger a message event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testMessageEventReceivedByExecutionIdWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testMessageEventReceivedByExecutionIdWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testMessageEventReceivedByExecutionIdWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testMessageEventReceivedByExecutionId() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateMessageExecutionWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.runtimeService.correlateMessage("boundaryInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testCorrelateMessageExecutionWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.correlateMessage("boundaryInvoiceMessage");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateMessageExecutionWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.correlateMessage("boundaryInvoiceMessage");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateMessageExecutionWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.correlateMessage("boundaryInvoiceMessage");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateMessageExecution() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.correlateMessage("boundaryInvoiceMessage");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateMessageProcessDefinitionWithoutAuthorization() {
        try {
            this.runtimeService.correlateMessage("startInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testCorrelateMessageProcessDefinitionWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.correlateMessage("startInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'messageStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testCorrelateMessageProcessDefinitionWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.correlateMessage("startInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testCorrelateMessageProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.runtimeService.correlateMessage("startInvoiceMessage");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateAllExecutionWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testCorrelateAllExecutionWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateAllExecutionWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateAllExecutionWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateAllExecution() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateAllTwoExecutionsShouldFail() {
        String firstProcessInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        String secondProcessInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to trigger a signal event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(secondProcessInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testCorrelateAllTwoExecutionsShouldSuccess() {
        String firstProcessInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        String secondProcessInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, secondProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)tasks.isEmpty());
        for (Task task : tasks) {
            ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
        }
        this.enableAuthorization();
    }

    public void testCorrelateAllProcessDefinitionWithoutAuthorization() {
        try {
            this.runtimeService.createMessageCorrelation("startInvoiceMessage").correlateAll();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testCorrelateAllProcessDefinitionWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.createMessageCorrelation("startInvoiceMessage").correlateAll();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'messageStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testCorrelateAllProcessDefinitionWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.createMessageCorrelation("startInvoiceMessage").correlateAll();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testCorrelateAllProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.runtimeService.createMessageCorrelation("startInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
    }

    public void testSuspendProcessInstanceByIdWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.suspendProcessInstanceById(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendProcessInstanceByIdWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByIdWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByIdWithUpdateInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceById() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByIdWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        try {
            this.runtimeService.activateProcessInstanceById(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to activate a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateProcessInstanceByIdWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByIdWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByIdWithUpdateInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceById() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByProcessDefinitionIdWithoutAuthorization() {
        String processDefinitionId = this.startProcessInstanceByKey(PROCESS_KEY).getProcessDefinitionId();
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendProcessInstanceByProcessDefinitionIdWithUpdatePermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendProcessInstanceByProcessDefinitionIdWithUpdatePermissionOnAnyProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByProcessDefinitionIdWithUpdateInstancesPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByProcessDefinitionId() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByProcessDefinitionIdWithoutAuthorization() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateProcessInstanceByProcessDefinitionIdWithUpdatePermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateProcessInstanceByProcessDefinitionIdWithUpdatePermissionOnAnyProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByProcessDefinitionIdWithUpdateInstancesPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByProcessDefinitionId() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByProcessDefinitionKeyWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendProcessInstanceByProcessDefinitionKeyWithUpdatePermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendProcessInstanceByProcessDefinitionKeyWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByProcessDefinitionKeyWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByProcessDefinitionKey() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByProcessDefinitionKeyWithoutAuthorization() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateProcessInstanceByProcessDefinitionKeyWithUpdatePermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateProcessInstanceByProcessDefinitionKeyWithUpdatePermissionOnAnyProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByProcessDefinitionKeyWithUpdateInstancesPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByProcessDefinitionKey() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testModifyProcessInstanceWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        try {
            ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testModifyProcessInstanceWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)tasks.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)2, (int)tasks.size());
    }

    public void testModifyProcessInstanceWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)tasks.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)2, (int)tasks.size());
    }

    public void testModifyProcessInstanceWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)tasks.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)2, (int)tasks.size());
    }

    public void testModifyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)tasks.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)2, (int)tasks.size());
    }

    public void testDeleteProcessInstanceByModifyingWithoutDeleteAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        try {
            this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("task").execute();
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.DELETE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.DELETE_INSTANCE.getName(), message);
            this.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testDeleteProcessInstanceByModifyingWithoutDeletePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.DELETE});
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("task").execute();
        this.assertProcessEnded(processInstanceId);
    }

    public void testDeleteProcessInstanceByModifyingWithoutDeletePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.DELETE});
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("task").execute();
        this.assertProcessEnded(processInstanceId);
    }

    public void testDeleteProcessInstanceByModifyingWithoutDeleteInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        Authorization authorization = this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY);
        authorization.setUserId(this.userId);
        authorization.addPermission((Permission)Permissions.UPDATE_INSTANCE);
        authorization.addPermission((Permission)Permissions.DELETE_INSTANCE);
        this.saveAuthorization(authorization);
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("task").execute();
        this.assertProcessEnded(processInstanceId);
    }

    public void testClearProcessInstanceAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.ALL});
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.ALL});
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(processInstanceId).singleResult();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)authorization);
        String taskId = this.selectSingleTask().getId();
        this.taskService.complete(taskId);
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(processInstanceId).singleResult();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertNull((Object)authorization);
    }

    public void testDeleteProcessInstanceClearAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.ALL});
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(processInstanceId).singleResult();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)authorization);
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(processInstanceId).singleResult();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertNull((Object)authorization);
    }

    public void testGetVariableWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariable(processInstanceId, "aVariableName");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariableWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        Object variable = this.runtimeService.getVariable(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        Object variable = this.runtimeService.getVariable(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Object variable = this.runtimeService.getVariable(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Object variable = this.runtimeService.getVariable(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableLocalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariableLocalWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        Object variable = this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableLocalWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        Object variable = this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableLocalWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Object variable = this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableLocalWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Object variable = this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableTypedWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariableTypedWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        TypedValue typedValue = this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariableTypedWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        TypedValue typedValue = this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariableTypedWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        TypedValue typedValue = this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariableTypedWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        TypedValue typedValue = this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariableLocalTypedWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariableLocalTypedWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        TypedValue typedValue = this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariableLocalTypedWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        TypedValue typedValue = this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariableLocalTypedWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        TypedValue typedValue = this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariableLocalTypedWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        TypedValue typedValue = this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariablesWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariables(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariablesWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariables(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariables(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariables(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariables(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesLocalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariablesLocal(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariablesLocalWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesLocalWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesLocalWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesLocalWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesTypedWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariablesTyped(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariablesTypedWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesTypedWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesTypedWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesTypedWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesLocalTypedWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariablesLocalTyped(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariablesLocalTypedWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesLocalTypedWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesLocalTypedWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesLocalTypedWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesByNameWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariablesByNameWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesByNameWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesByNameWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesByNameWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesLocalByNameWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariablesLocalByNameWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesLocalByNameWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesLocalByNameWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesLocalByNameWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesTypedByNameWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariablesTypedByNameWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesTypedByNameWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesTypedByNameWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesTypedByNameWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesLocalTypedByNameWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariablesLocalTypedByNameWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesLocalTypedByNameWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesLocalTypedByNameWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesLocalTypedByNameWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testSetVariableWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.setVariable(processInstanceId, "aVariableName", (Object)"aVariableValue");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSetVariableWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.setVariable(processInstanceId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testSetVariableWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.setVariable(processInstanceId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testSetVariableWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.setVariable(processInstanceId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testSetVariableWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.setVariable(processInstanceId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testSetVariableLocalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.setVariableLocal(processInstanceId, "aVariableName", (Object)"aVariableValue");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSetVariableLocalWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.setVariableLocal(processInstanceId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testSetVariableLocalWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.setVariableLocal(processInstanceId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testSetVariableLocalWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.setVariableLocal(processInstanceId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testSetVariableLocalWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.setVariableLocal(processInstanceId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testSetVariablesWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.setVariables(processInstanceId, (Map)this.getVariables());
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSetVariablesWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.setVariables(processInstanceId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testSetVariablesWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.setVariables(processInstanceId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testSetVariablesWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.setVariables(processInstanceId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testSetVariablesWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.setVariables(processInstanceId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testSetVariablesLocalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.setVariablesLocal(processInstanceId, (Map)this.getVariables());
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSetVariablesLocalWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.setVariablesLocal(processInstanceId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testSetVariablesLocalWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.setVariablesLocal(processInstanceId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testSetVariablesLocalWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.setVariablesLocal(processInstanceId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testSetVariablesLocalWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.setVariablesLocal(processInstanceId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testRemoveVariableWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.removeVariable(processInstanceId, "aVariableName");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testRemoveVariableWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.removeVariable(processInstanceId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testRemoveVariableWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.removeVariable(processInstanceId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testRemoveVariableWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.removeVariable(processInstanceId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testRemoveVariableWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.removeVariable(processInstanceId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testRemoveVariableLocalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.removeVariableLocal(processInstanceId, "aVariableName");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testRemoveVariableLocalWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.removeVariableLocal(processInstanceId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testRemoveVariableLocalWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.removeVariableLocal(processInstanceId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testRemoveVariableLocalWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.removeVariableLocal(processInstanceId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testRemoveVariableLocalWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.removeVariableLocal(processInstanceId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testRemoveVariablesWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.removeVariables(processInstanceId, Arrays.asList("aVariableName"));
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testRemoveVariablesWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.removeVariables(processInstanceId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testRemoveVariablesWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.removeVariables(processInstanceId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testRemoveVariablesWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.removeVariables(processInstanceId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testRemoveVariablesWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.removeVariables(processInstanceId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testRemoveVariablesLocalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.removeVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testRemoveVariablesLocalWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.removeVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testRemoveVariablesLocalWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.removeVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testRemoveVariablesLocalWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.removeVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testRemoveVariablesLocalWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.removeVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testUpdateVariablesWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, (Map)this.getVariables(), null);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        try {
            ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, null, Arrays.asList("aVariableName"));
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        try {
            ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testUpdateVariablesWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testUpdateVariablesWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testUpdateVariablesWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testUpdateVariablesWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testUpdateVariablesLocalWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, (Map)this.getVariables(), null);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        try {
            ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, null, Arrays.asList("aVariableName"));
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        try {
            ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testUpdateVariablesLocalWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testUpdateVariablesLocalWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testUpdateVariablesLocalWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testUpdateVariablesLocalWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    protected void verifyQueryResults(ProcessInstanceQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected void verifyQueryResults(VariableInstanceQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }
}

