/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.TaskServiceImpl;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class TaskAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected static final String CASE_KEY = "oneTaskCase";
    protected static final String DEMO_ASSIGNEE_PROCESS_KEY = "demoAssigneeProcess";
    protected static final String CANDIDATE_USERS_PROCESS_KEY = "candidateUsersProcess";
    protected static final String CANDIDATE_GROUPS_PROCESS_KEY = "candidateGroupsProcess";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn", "org/camunda/bpm/engine/test/api/authorization/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/candidateUsersProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/candidateGroupsProcess.bpmn20.xml").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
    }

    public void testSimpleQueryWithTaskInsideProcessWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testSimpleQueryWithTaskInsideProcessWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithTaskInsideProcessWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithTaskInsideProcessWithReadPermissionOnOneTaskProcess() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithTaskInsideProcessWithReadPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testQueryWithTaskInsideProcessWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithTaskInsideProcessWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.disableAuthorization();
        String taskId = ((Task)this.taskService.createTaskQuery().processDefinitionKey(PROCESS_KEY).listPage(0, 1).get(0)).getId();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testQueryWithTaskInsideProcessWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 7);
    }

    public void testQueryWithTaskInsideProcessWithReadPermissionOnOneTaskProcess() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 3);
    }

    public void testQueryWithTaskInsideProcessWithReadPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 7);
    }

    public void testQueryWithTaskInsideCaseWithoutAuthorization() {
        this.createCaseInstanceByKey(CASE_KEY);
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testQueryWithStandaloneTaskWithoutAuthorization() {
        String taskId = "newTask";
        this.createTask(taskId);
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 0);
        this.deleteTask(taskId, true);
    }

    public void testQueryWithStandaloneTaskWithReadPermissionOnTask() {
        String taskId = "newTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
        this.deleteTask(taskId, true);
    }

    public void testNewTaskWithoutAuthorization() {
        try {
            this.taskService.newTask();
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to create a new task.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'Task'", e.getMessage());
        }
    }

    public void testNewTask() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE});
        Task task = this.taskService.newTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
    }

    public void testSaveTaskInsertWithoutAuthorization() {
        TaskEntity task = TaskEntity.create();
        try {
            this.taskService.saveTask((Task)task);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to save a task.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'Task'", e.getMessage());
        }
    }

    public void testSaveTaskInsert() {
        TaskEntity task = TaskEntity.create();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.taskService.saveTask((Task)task);
        task = (TaskEntity)this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
        String taskId = task.getId();
        this.deleteTask(taskId, true);
    }

    public void testSaveStandaloneTaskUpdateWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        Task task = this.selectSingleTask();
        try {
            this.taskService.saveTask(task);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to save a task.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'UPDATE' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testSaveStandaloneTaskUpdate() {
        String taskId = "myTask";
        this.createTask(taskId);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    public void testSaveProcessTaskUpdateWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        try {
            this.taskService.saveTask(task);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to save a task.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(task.getId(), message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSaveProcessTaskUpdateWithUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.TASK, task.getId(), this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testSaveProcessTaskUpdateWithUpdatePermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testSaveProcessTaskUpdateWithUpdateTasksPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testSaveCaseTaskUpdate() {
        this.createCaseInstanceByKey(CASE_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testDeleteTaskWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.deleteTask(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete a task.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'DELETE' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testDeleteTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.DELETE});
        this.taskService.deleteTask(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNull((Object)task);
        this.deleteTask(taskId, true);
    }

    public void testDeleteTasksWithoutAuthorization() {
        String firstTaskId = "myTask1";
        this.createTask(firstTaskId);
        String secondTaskId = "myTask2";
        this.createTask(secondTaskId);
        try {
            this.taskService.deleteTasks(Arrays.asList(firstTaskId, secondTaskId));
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete tasks.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'DELETE' permission on resource 'myTask1' of type 'Task'", e.getMessage());
        }
        this.deleteTask(firstTaskId, true);
        this.deleteTask(secondTaskId, true);
    }

    public void testDeleteTasksWithDeletePermissionOnFirstTask() {
        String firstTaskId = "myTask1";
        this.createTask(firstTaskId);
        this.createGrantAuthorization((Resource)Resources.TASK, firstTaskId, this.userId, new Permission[]{Permissions.DELETE});
        String secondTaskId = "myTask2";
        this.createTask(secondTaskId);
        try {
            this.taskService.deleteTasks(Arrays.asList(firstTaskId, secondTaskId));
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete tasks.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'DELETE' permission on resource 'myTask2' of type 'Task'", e.getMessage());
        }
        this.deleteTask(firstTaskId, true);
        this.deleteTask(secondTaskId, true);
    }

    public void testDeleteTasks() {
        String firstTaskId = "myTask1";
        this.createTask(firstTaskId);
        String secondTaskId = "myTask2";
        this.createTask(secondTaskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.DELETE});
        this.taskService.deleteTasks(Arrays.asList(firstTaskId, secondTaskId));
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNull((Object)task);
        this.deleteTask(firstTaskId, true);
        this.deleteTask(secondTaskId, true);
    }

    public void testStandaloneTaskSetAssigneeWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.setAssignee(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to set an assignee");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'UPDATE' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetAssignee() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskSetAssigneeWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.setAssignee(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to set an assignee");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskSetAssigneeWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskSetAssigneeWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskSetAssigneeWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskSetAssignee() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testCaseTaskSetAssignee() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testStandaloneTaskSetOwnerWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.setOwner(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to set an owner");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'UPDATE' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetOwner() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getOwner());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskSetOwnerWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.setOwner(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to set an owner");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskSetOwnerWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getOwner());
    }

    public void testProcessTaskSetOwnerWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getOwner());
    }

    public void testProcessTaskSetOwnerWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getOwner());
    }

    public void testProcessTaskSetOwner() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getOwner());
    }

    public void testCaseTaskSetOwner() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getOwner());
    }

    public void testStandaloneTaskAddCandidateUserWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.addCandidateUser(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to add a candidate user");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'UPDATE' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskAddCandidateUser() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskAddCandidateUserWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.addCandidateUser(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to add a candidate user");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskAddCandidateUserWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateUserWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateUserWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateUser() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testCaseTaskAddCandidateUser() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testStandaloneTaskAddCandidateGroupWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.addCandidateGroup(taskId, "accounting");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to add a candidate group");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'UPDATE' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskAddCandidateGroup() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskAddCandidateGroupWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.addCandidateGroup(taskId, "accounting");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to add a candidate group");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskAddCandidateGroupWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateGroupWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateGroupWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateGroup() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testCaseTaskAddCandidateGroup() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testStandaloneTaskAddUserIdentityLinkWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to add an user identity link");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'UPDATE' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskAddUserIdentityLink() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskAddUserIdentityLinkWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to add an user identity link");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskAddUserIdentityLinkWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddUserIdentityLinkWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddUserIdentityLinkWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddUserIdentityLink() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testCaseTaskAddUserIdentityLink() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testStandaloneTaskAddGroupIdentityLinkWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to add a group identity link");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'UPDATE' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskAddGroupIdentityLink() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskAddGroupIdentityLinkWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to add a group identity link");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskAddGroupIdentityLinkWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddGroupIdentityLinkWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddGroupIdentityLinkWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddGroupIdentityLink() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testCaseTaskAddGroupIdentityLink() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testStandaloneTaskDeleteCandidateUserWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        try {
            this.taskService.deleteCandidateUser(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete a candidate user");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'UPDATE' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskDeleteCandidateUser() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskDeleteCandidateUserWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        try {
            this.taskService.deleteCandidateUser(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete a candidate user");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskDeleteCandidateUserWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteCandidateUserWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteCandidateUserWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteCandidateUser() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testCaseTaskDeleteCandidateUser() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testStandaloneTaskDeleteCandidateGroupWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateGroup(taskId, "accounting");
        try {
            this.taskService.deleteCandidateGroup(taskId, "accounting");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete a candidate group");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'UPDATE' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskDeleteCandidateGroup() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskDeleteCandidateGroupWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        try {
            this.taskService.deleteCandidateGroup(taskId, "accounting");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete a candidate group");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskDeleteCandidateGroupWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteCandidateGroupWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteCandidateGroupWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteCandidateGroup() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testCaseTaskDeleteCandidateGroup() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testStandaloneTaskDeleteUserIdentityLinkWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        try {
            this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete an user identity link");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'UPDATE' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskDeleteUserIdentityLink() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskDeleteUserIdentityLinkWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        try {
            this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete an user identity link");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskDeleteUserIdentityLinkWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteUserIdentityLinkWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteUserIdentityLinkWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteUserIdentityLink() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testCaseTaskDeleteUserIdentityLink() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testStandaloneTaskDeleteGroupIdentityLinkWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateGroup(taskId, "accounting");
        try {
            this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete a group identity link");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'UPDATE' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskDeleteGroupIdentityLink() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskDeleteGroupIdentityLinkWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        try {
            this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete a group identity link");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskDeleteGroupIdentityLinkWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteGroupIdentityLinkWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteGroupIdentityLinkWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteGroupIdentityLink() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testCaseTaskDeleteGroupIdentityLink() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testStandaloneTaskGetIdentityLinksWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        try {
            this.taskService.getIdentityLinksForTask(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to get identity links");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'READ' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetIdentityLinks() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        List identityLinksForTask = this.taskService.getIdentityLinksForTask(taskId);
        TaskAuthorizationTest.assertNotNull((Object)identityLinksForTask);
        TaskAuthorizationTest.assertFalse((boolean)identityLinksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskGetIdentityLinksWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        try {
            this.taskService.getIdentityLinksForTask(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the identity links");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskGetIdentityLinksWithReadPersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        List identityLinksForTask = this.taskService.getIdentityLinksForTask(taskId);
        TaskAuthorizationTest.assertNotNull((Object)identityLinksForTask);
        TaskAuthorizationTest.assertFalse((boolean)identityLinksForTask.isEmpty());
    }

    public void testProcessTaskGetIdentityLinksWithReadPersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        List identityLinksForTask = this.taskService.getIdentityLinksForTask(taskId);
        TaskAuthorizationTest.assertNotNull((Object)identityLinksForTask);
        TaskAuthorizationTest.assertFalse((boolean)identityLinksForTask.isEmpty());
    }

    public void testProcessTaskGetIdentityLinksWithReadTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        List identityLinksForTask = this.taskService.getIdentityLinksForTask(taskId);
        TaskAuthorizationTest.assertNotNull((Object)identityLinksForTask);
        TaskAuthorizationTest.assertFalse((boolean)identityLinksForTask.isEmpty());
    }

    public void testProcessTaskGetIdentityLinks() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        List identityLinksForTask = this.taskService.getIdentityLinksForTask(taskId);
        TaskAuthorizationTest.assertNotNull((Object)identityLinksForTask);
        TaskAuthorizationTest.assertFalse((boolean)identityLinksForTask.isEmpty());
    }

    public void testCaseTaskGetIdentityLinks() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        List identityLinksForTask = this.taskService.getIdentityLinksForTask(taskId);
        TaskAuthorizationTest.assertNotNull((Object)identityLinksForTask);
        TaskAuthorizationTest.assertFalse((boolean)identityLinksForTask.isEmpty());
    }

    public void testStandaloneTaskClaimTaskWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.claim(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to claim the task.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'UPDATE' permission on resource 'myTask' of type 'Task'.", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskClaimTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskClaimTaskWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.claim(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to claim the task");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskClaimTaskWithUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskClaimTaskWithUpdatePermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskClaimTaskWithUpdateTasksPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskClaimTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testCaseTaskClaimTask() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testStandaloneTaskCompleteTaskWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.complete(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to complete a task");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'UPDATE' permission on resource 'myTask' of type 'Task'.", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskCompleteTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNull((Object)task);
        this.historyService.deleteHistoricTaskInstance(taskId);
    }

    public void testProcessTaskCompleteTaskWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.complete(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to complete a task");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskCompleteTaskWithUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNull((Object)task);
    }

    public void testProcessTaskCompleteTaskWithUpdatePermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNull((Object)task);
    }

    public void testProcessTaskCompleteTaskWithUpdateTasksPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNull((Object)task);
    }

    public void testProcessTaskCompleteTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNull((Object)task);
    }

    public void testCaseTaskCompleteTask() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNull((Object)task);
    }

    public void testStandaloneTaskDelegateTaskWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.delegateTask(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delegate a task");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'UPDATE' permission on resource 'myTask' of type 'Task'.", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskDelegateTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskDelegateTaskWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.delegateTask(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delegate a task");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskDelegateTaskWithUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskDelegateTaskWithUpdatePermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskDelegateTaskWithUpdateTasksPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskDelegateTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testCaseTaskDelegateTask() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testStandaloneTaskResolveTaskWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.resolveTask(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to resolve a task");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'UPDATE' permission on resource 'myTask' of type 'Task'.", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskResolveTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.setAssignee(taskId, this.userId);
        this.delegateTask(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.resolveTask(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)this.userId, (String)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskResolveTaskWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.resolveTask(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to resolve a task");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskResolveTaskWithUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, this.userId);
        this.delegateTask(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.resolveTask(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)this.userId, (String)task.getAssignee());
    }

    public void testProcessTaskResolveTaskWithUpdatePermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, this.userId);
        this.delegateTask(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.resolveTask(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)this.userId, (String)task.getAssignee());
    }

    public void testProcessTaskResolveTaskWithUpdateTasksPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, this.userId);
        this.delegateTask(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.resolveTask(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)this.userId, (String)task.getAssignee());
    }

    public void testProcessTaskResolveTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, this.userId);
        this.delegateTask(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.resolveTask(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)this.userId, (String)task.getAssignee());
    }

    public void testCaseTaskResolveTask() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, this.userId);
        this.delegateTask(taskId, "demo");
        this.taskService.resolveTask(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)this.userId, (String)task.getAssignee());
    }

    public void testStandaloneTaskSetPriorityWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.setPriority(taskId, 80);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to set a priority");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'UPDATE' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetPriority() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((int)80, (int)task.getPriority());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskSetPriorityWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.setPriority(taskId, 80);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to set a priority");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskSetPriorityWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((int)80, (int)task.getPriority());
    }

    public void testProcessTaskSetPriorityWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((int)80, (int)task.getPriority());
    }

    public void testProcessTaskSetPriorityWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((int)80, (int)task.getPriority());
    }

    public void testProcessTaskSetPriority() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((int)80, (int)task.getPriority());
    }

    public void testCaseTaskSetPriority() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((int)80, (int)task.getPriority());
    }

    public void testStandaloneTaskGetSubTasksWithoutAuthorization() {
        String parentTaskId = "parentTaskId";
        this.createTask(parentTaskId);
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        TaskAuthorizationTest.assertTrue((boolean)subTasks.isEmpty());
        this.deleteTask(parentTaskId, true);
    }

    public void testStandaloneTaskGetSubTasksWithReadPermissionOnSub1() {
        String parentTaskId = "parentTaskId";
        this.createTask(parentTaskId);
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, "sub1", this.userId, new Permission[]{Permissions.READ});
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        TaskAuthorizationTest.assertFalse((boolean)subTasks.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)subTasks.size());
        TaskAuthorizationTest.assertEquals((String)"sub1", (String)((Task)subTasks.get(0)).getId());
        this.deleteTask(parentTaskId, true);
    }

    public void testStandaloneTaskGetSubTasks() {
        String parentTaskId = "parentTaskId";
        this.createTask(parentTaskId);
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        TaskAuthorizationTest.assertFalse((boolean)subTasks.isEmpty());
        TaskAuthorizationTest.assertEquals((int)2, (int)subTasks.size());
        this.deleteTask(parentTaskId, true);
    }

    public void testProcessTaskGetSubTasksWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String parentTaskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        TaskAuthorizationTest.assertTrue((boolean)subTasks.isEmpty());
    }

    public void testProcessTaskGetSubTasksWithReadPermissionOnSub1() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String parentTaskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, "sub1", this.userId, new Permission[]{Permissions.READ});
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        TaskAuthorizationTest.assertFalse((boolean)subTasks.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)subTasks.size());
        TaskAuthorizationTest.assertEquals((String)"sub1", (String)((Task)subTasks.get(0)).getId());
    }

    public void testProcessTaskGetSubTasks() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String parentTaskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        TaskAuthorizationTest.assertFalse((boolean)subTasks.isEmpty());
        TaskAuthorizationTest.assertEquals((int)2, (int)subTasks.size());
    }

    public void testCaseTaskGetSubTasksWithoutAuthorization() {
        this.createCaseInstanceByKey(CASE_KEY);
        String parentTaskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        TaskAuthorizationTest.assertTrue((boolean)subTasks.isEmpty());
    }

    public void testCaseTaskGetSubTasksWithReadPermissionOnSub1() {
        this.createCaseInstanceByKey(CASE_KEY);
        String parentTaskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, "sub1", this.userId, new Permission[]{Permissions.READ});
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        TaskAuthorizationTest.assertFalse((boolean)subTasks.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)subTasks.size());
        TaskAuthorizationTest.assertEquals((String)"sub1", (String)((Task)subTasks.get(0)).getId());
    }

    public void testCaseTaskGetSubTasks() {
        this.createCaseInstanceByKey(CASE_KEY);
        String parentTaskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        TaskAuthorizationTest.assertFalse((boolean)subTasks.isEmpty());
        TaskAuthorizationTest.assertEquals((int)2, (int)subTasks.size());
    }

    public void testStandaloneTaskClearAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(taskId).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        this.taskService.complete(taskId);
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(taskId).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNull((Object)authorization);
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskClearAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(taskId).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        this.taskService.complete(taskId);
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(taskId).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNull((Object)authorization);
    }

    public void testStandaloneTaskSetAssigneeCreateNewAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetAssigneeUpdateAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.setAssignee(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetAssigneeToNullAuthorizationStillAvailable() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.taskService.setAssignee(taskId, null);
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.deleteTask(taskId, true);
    }

    public void testQueryStandaloneTaskSetAssignee() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetAssigneeOutsideCommandContextInsert() {
        String taskId = "myTask";
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        Task task = this.taskService.newTask(taskId);
        task.setAssignee("demo");
        this.taskService.saveTask(task);
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetAssigneeOutsideCommandContextSave() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.taskService.saveTask(task);
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskSetAssigneeCreateNewAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
    }

    public void testProcessTaskSetAssigneeUpdateAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.setAssignee(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
    }

    public void testProcessTaskSetAssigneeToNullAuthorizationStillAvailable() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.taskService.setAssignee(taskId, null);
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
    }

    public void testQueryProcessTaskSetAssignee() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
    }

    public void testProcessTaskAssignee() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, DEMO_ASSIGNEE_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.runtimeService.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
    }

    public void testCaseTaskSetAssigneeNoAuthorization() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNull((Object)authorization);
    }

    public void testStandaloneTaskSetOwnerCreateNewAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetOwnerUpdateAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.setOwner(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.deleteTask(taskId, true);
    }

    public void testQueryStandaloneTaskSetOwner() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetOwnerOutsideCommandContextInsert() {
        String taskId = "myTask";
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        Task task = this.taskService.newTask(taskId);
        task.setOwner("demo");
        this.taskService.saveTask(task);
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetOwnerOutsideCommandContextSave() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        Task task = this.selectSingleTask();
        task.setOwner("demo");
        this.taskService.saveTask(task);
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskSetOwnerCreateNewAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
    }

    public void testProcessTaskSetOwnerUpdateAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.setOwner(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
    }

    public void testQueryProcessTaskSetOwner() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
    }

    public void testCaseTaskSetOwnerNoAuthorization() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNull((Object)authorization);
    }

    public void testStandaloneTaskAddCandidateUserCreateNewAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskAddCandidateUserUpdateAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.deleteTask(taskId, true);
    }

    public void testQueryStandaloneTaskAddCandidateUser() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskAddCandidateUserCreateNewAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
    }

    public void testProcessTaskAddCandidateUserUpdateAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
    }

    public void testQueryProcessTaskAddCandidateUser() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
    }

    public void testProcessTaskCandidateUsers() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, CANDIDATE_USERS_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.runtimeService.startProcessInstanceByKey(CANDIDATE_USERS_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"test"}).resourceId(taskId).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
    }

    public void testCaseTaskAddCandidateUserNoAuthorization() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNull((Object)authorization);
    }

    public void testStandaloneTaskAddCandidateGroupCreateNewAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"management"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskAddCandidateGroupUpdateAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"management"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.deleteTask(taskId, true);
    }

    public void testQueryStandaloneTaskAddCandidateGroup() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", Arrays.asList("management"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskAddCandidateGroupCreateNewAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"management"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
    }

    public void testProcessTaskAddCandidateGroupUpdateAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"management"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
    }

    public void testQueryProcessTaskAddCandidateGroup() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", Arrays.asList("management"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
    }

    public void testProcessTaskCandidateGroups() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, CANDIDATE_GROUPS_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.runtimeService.startProcessInstanceByKey(CANDIDATE_GROUPS_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"management"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"accounting"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", Arrays.asList("management"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
    }

    public void testCaseTaskAddCandidateGroupNoAuthorization() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"management"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNull((Object)authorization);
    }

    public void testStandaloneTaskGetVariableWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.getVariable(taskId, "aVariableName");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariableWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Object variable = this.taskService.getVariable(taskId, "aVariableName");
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariableWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Object variable = this.taskService.getVariable(taskId, "aVariableName");
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskGetVariableWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.getVariable(taskId, "aVariableName");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskGetVariableWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        Object variable = this.taskService.getVariable(taskId, "aVariableName");
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testProcessTaskGetVariableWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        Object variable = this.taskService.getVariable(taskId, "aVariableName");
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testProcessTaskGetVariableWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        Object variable = this.taskService.getVariable(taskId, "aVariableName");
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testProcessTaskGetVariableWithReadTaskPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        Object variable = this.taskService.getVariable(taskId, "aVariableName");
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testCaseTaskGetVariable() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        Object variable = this.taskService.getVariable(taskId, "aVariableName");
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testStandaloneTaskGetVariableLocalWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.getVariableLocal(taskId, "aVariableName");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariableLocalWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Object variable = this.taskService.getVariableLocal(taskId, "aVariableName");
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariableLocalWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Object variable = this.taskService.getVariableLocal(taskId, "aVariableName");
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskGetVariableLocalWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.getVariableLocal(taskId, "aVariableName");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskGetVariableLocalWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Object variable = this.taskService.getVariableLocal(taskId, "aVariableName");
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testProcessTaskGetVariableLocalWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Object variable = this.taskService.getVariableLocal(taskId, "aVariableName");
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testProcessTaskGetVariableLocalWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Object variable = this.taskService.getVariableLocal(taskId, "aVariableName");
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testProcessTaskGetVariableLocalWithReadTaskPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Object variable = this.taskService.getVariableLocal(taskId, "aVariableName");
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testCaseTaskGetVariableLocal() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Object variable = this.taskService.getVariable(taskId, "aVariableName");
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testStandaloneTaskGetVariableTypedWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.getVariableTyped(taskId, "aVariableName");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariableTypedWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        TypedValue typedValue = this.taskService.getVariableTyped(taskId, "aVariableName");
        TaskAuthorizationTest.assertNotNull((Object)typedValue);
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariableTypedWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        TypedValue typedValue = this.taskService.getVariableTyped(taskId, "aVariableName");
        TaskAuthorizationTest.assertNotNull((Object)typedValue);
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskGetVariableTypedWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.getVariableTyped(taskId, "aVariableName");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskGetVariableTypedWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        TypedValue typedValue = this.taskService.getVariableTyped(taskId, "aVariableName");
        TaskAuthorizationTest.assertNotNull((Object)typedValue);
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testProcessTaskGetVariableTypedWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        TypedValue typedValue = this.taskService.getVariableTyped(taskId, "aVariableName");
        TaskAuthorizationTest.assertNotNull((Object)typedValue);
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testProcessTaskGetVariableTypedWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        TypedValue typedValue = this.taskService.getVariableTyped(taskId, "aVariableName");
        TaskAuthorizationTest.assertNotNull((Object)typedValue);
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testProcessTaskGetVariableTypedWithReadTaskPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        TypedValue typedValue = this.taskService.getVariableTyped(taskId, "aVariableName");
        TaskAuthorizationTest.assertNotNull((Object)typedValue);
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testCaseTaskGetVariableTyped() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        TypedValue typedValue = this.taskService.getVariableTyped(taskId, "aVariableName");
        TaskAuthorizationTest.assertNotNull((Object)typedValue);
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testStandaloneTaskGetVariableLocalTypedWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.getVariableLocalTyped(taskId, "aVariableName");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariableLocalTypedWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        TypedValue typedValue = this.taskService.getVariableLocalTyped(taskId, "aVariableName");
        TaskAuthorizationTest.assertNotNull((Object)typedValue);
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariableLocalTypedWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        TypedValue typedValue = this.taskService.getVariableLocalTyped(taskId, "aVariableName");
        TaskAuthorizationTest.assertNotNull((Object)typedValue);
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskGetVariableLocalTypedWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.getVariableLocalTyped(taskId, "aVariableName");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskGetVariableLocalTypedWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        TypedValue typedValue = this.taskService.getVariableLocalTyped(taskId, "aVariableName");
        TaskAuthorizationTest.assertNotNull((Object)typedValue);
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testProcessTaskGetVariableLocalTypedWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        TypedValue typedValue = this.taskService.getVariableLocalTyped(taskId, "aVariableName");
        TaskAuthorizationTest.assertNotNull((Object)typedValue);
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testProcessTaskGetVariableLocalTypedWithReadInstancePermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        TypedValue typedValue = this.taskService.getVariableLocalTyped(taskId, "aVariableName");
        TaskAuthorizationTest.assertNotNull((Object)typedValue);
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testProcessTaskGetVariableLocalTypedWithReadInstancePermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        TypedValue typedValue = this.taskService.getVariableLocalTyped(taskId, "aVariableName");
        TaskAuthorizationTest.assertNotNull((Object)typedValue);
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testCaseTaskGetVariableLocalTyped() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        TypedValue typedValue = this.taskService.getVariableLocalTyped(taskId, "aVariableName");
        TaskAuthorizationTest.assertNotNull((Object)typedValue);
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testStandaloneTaskGetVariablesWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.getVariables(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariablesWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariables(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariablesWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariables(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskGetVariablesWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.getVariables(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskGetVariablesWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        Map variables = this.taskService.getVariables(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testProcessTaskGetVariablesWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        Map variables = this.taskService.getVariables(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testProcessTaskGetVariablesWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        Map variables = this.taskService.getVariables(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testProcessTaskGetVariablesWithReadTaskPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        Map variables = this.taskService.getVariables(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testCaseTaskGetVariables() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        Map variables = this.taskService.getVariables(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testStandaloneTaskGetVariablesLocalWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.getVariablesLocal(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariablesLocalWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariablesLocal(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariablesLocalWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariablesLocal(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskGetVariablesLocalWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.getVariablesLocal(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskGetVariablesLocalWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariablesLocal(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testProcessTaskGetVariablesLocalWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariablesLocal(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testProcessTaskGetVariablesLocalWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariablesLocal(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testProcessTaskGetVariablesLocalWithReadTaskPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariablesLocal(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testCaseTaskGetVariablesLocal() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariablesLocal(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testStandaloneTaskGetVariablesTypedWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.getVariablesTyped(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariablesTypedWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesTyped(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariablesTypedWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesTyped(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskGetVariablesTypedWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.getVariablesTyped(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskGetVariablesTypedWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.taskService.getVariablesTyped(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testProcessTaskGetVariablesTypedWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.taskService.getVariablesTyped(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testProcessTaskGetVariablesTypedWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        VariableMap variables = this.taskService.getVariablesTyped(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testProcessTaskGetVariablesTypedWithReadTaskPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        VariableMap variables = this.taskService.getVariablesTyped(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testCaseTaskGetVariablesTyped() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        VariableMap variables = this.taskService.getVariablesTyped(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testStandaloneTaskGetVariablesLocalTypedWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.getVariablesLocalTyped(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariablesLocalTypedWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariablesLocalTypedWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskGetVariablesLocalTypedWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.getVariablesLocalTyped(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskGetVariablesLocalTypedWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testProcessTaskGetVariablesTypedLocalWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testProcessTaskGetVariablesLocalTypedWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testProcessTaskGetVariablesLocalTypedWithReadTaskPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testCaseTaskGetVariablesLocalTyped() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testStandaloneTaskGetVariablesByNameWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.getVariables(taskId, Arrays.asList("aVariableName"));
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariablesByNameWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariables(taskId, Arrays.asList("aVariableName"));
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariablesByNameWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariables(taskId, Arrays.asList("aVariableName"));
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskGetVariablesByNameWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.getVariables(taskId, Arrays.asList("aVariableName"));
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskGetVariablesByNameWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        Map variables = this.taskService.getVariables(taskId, Arrays.asList("aVariableName"));
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testProcessTaskGetVariablesByNameWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        Map variables = this.taskService.getVariables(taskId, Arrays.asList("aVariableName"));
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testProcessTaskGetVariablesByNameWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        Map variables = this.taskService.getVariables(taskId, Arrays.asList("aVariableName"));
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testProcessTaskGetVariablesByNameWithReadTaskPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        Map variables = this.taskService.getVariables(taskId, Arrays.asList("aVariableName"));
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testCaseTaskGetVariablesByName() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        Map variables = this.taskService.getVariables(taskId, Arrays.asList("aVariableName"));
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testStandaloneTaskGetVariablesLocalByNameWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.getVariablesLocal(taskId, Arrays.asList("aVariableName"));
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariablesLocalByNameWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariablesLocal(taskId, Arrays.asList("aVariableName"));
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariablesLocalByNameWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariablesLocal(taskId, Arrays.asList("aVariableName"));
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskGetVariablesLocalByNameWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.getVariablesLocal(taskId, Arrays.asList("aVariableName"));
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskGetVariablesLocalByNameWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariablesLocal(taskId, Arrays.asList("aVariableName"));
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testProcessTaskGetVariablesLocalByNameWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariablesLocal(taskId, Arrays.asList("aVariableName"));
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testProcessTaskGetVariablesLocalByNameWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariablesLocal(taskId, Arrays.asList("aVariableName"));
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testProcessTaskGetVariablesLocalByNameWithReadTaskPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariablesLocal(taskId, Arrays.asList("aVariableName"));
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testCaseTaskGetVariablesLocalByName() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariablesLocal(taskId, Arrays.asList("aVariableName"));
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testStandaloneTaskGetVariablesTypedByNameWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.getVariablesTyped(taskId, Arrays.asList("aVariableName"), false);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariablesTypedByNameWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesTyped(taskId, Arrays.asList("aVariableName"), false);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariablesTypedByNameWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesTyped(taskId, Arrays.asList("aVariableName"), false);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskGetVariablesTypedByNameWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.getVariablesTyped(taskId, Arrays.asList("aVariableName"), false);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskGetVariablesTypedByNameWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.taskService.getVariablesTyped(taskId, Arrays.asList("aVariableName"), false);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testProcessTaskGetVariablesTypedByNameWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.taskService.getVariablesTyped(taskId, Arrays.asList("aVariableName"), false);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testProcessTaskGetVariablesTypedByNameWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        VariableMap variables = this.taskService.getVariablesTyped(taskId, Arrays.asList("aVariableName"), false);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testProcessTaskGetVariablesTypedByNameWithReadTaskPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        VariableMap variables = this.taskService.getVariablesTyped(taskId, Arrays.asList("aVariableName"), false);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testCaseTaskGetVariablesTypedByName() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        VariableMap variables = this.taskService.getVariablesTyped(taskId, Arrays.asList("aVariableName"), false);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testStandaloneTaskGetVariablesLocalTypedByNameWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.getVariablesLocalTyped(taskId, Arrays.asList("aVariableName"), false);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariablesLocalTypedByNameWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId, Arrays.asList("aVariableName"), false);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetVariablesLocalTypedByNameWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId, Arrays.asList("aVariableName"), false);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskGetVariablesLocalTypedByNameWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.getVariablesLocalTyped(taskId, Arrays.asList("aVariableName"), false);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskGetVariablesLocalTypedByNameWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId, Arrays.asList("aVariableName"), false);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testProcessTaskGetVariablesLocalTypedByNameWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId, Arrays.asList("aVariableName"), false);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testProcessTaskGetVariablesLocalTypedByNameWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId, Arrays.asList("aVariableName"), false);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testProcessTaskGetVariablesLocalTypedByNameWithReadTaskPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId, Arrays.asList("aVariableName"), false);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testCaseTaskGetVariablesLocalTypedByName() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId, Arrays.asList("aVariableName"), false);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testStandaloneTaskSetVariableWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.setVariable(taskId, "aVariableName", (Object)"aVariableValue");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetVariableWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setVariable(taskId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetVariableWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setVariable(taskId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskSetVariableWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.setVariable(taskId, "aVariableName", (Object)"aVariableValue");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskSetVariableWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setVariable(taskId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testProcessTaskSetVariableWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setVariable(taskId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testProcessTaskSetVariableWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setVariable(taskId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testProcessTaskSetVariableWithReadTaskPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setVariable(taskId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testCaseTaskSetVariable() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.setVariable(taskId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testStandaloneTaskSetVariableLocalWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetVariableLocalWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetVariableLocalWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskSetVariableLocalWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskSetVariableLocalWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testProcessTaskSetVariableLocalWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testProcessTaskSetVariableLocalWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testProcessTaskSetVariableLocalWithReadTaskPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testCaseTaskSetVariableLocal() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testStandaloneTaskSetVariablesWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.setVariables(taskId, (Map)this.getVariables());
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetVariablesWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetVariablesWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskSetVariablesWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.setVariables(taskId, (Map)this.getVariables());
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskSetVariablesWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testProcessTaskSetVariablesWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testProcessTaskSetVariablesWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testProcessTaskSetVariablesWithReadTaskPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testCaseTaskSetVariables() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testStandaloneTaskSetVariablesLocalWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetVariablesLocalWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetVariablesLocalWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskSetVariablesLocalWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskSetVariablesLocalWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testProcessTaskSetVariablesLocalWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testProcessTaskSetVariablesLocalWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testProcessTaskSetVariablesLocalWithReadTaskPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testCaseTaskSetVariablesLocal() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testStandaloneTaskRemoveVariableWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.removeVariable(taskId, "aVariableName");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskRemoveVariableWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.removeVariable(taskId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskRemoveVariableWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.removeVariable(taskId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskRemoveVariableWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.removeVariable(taskId, "aVariableName");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskRemoveVariableWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.removeVariable(taskId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testProcessTaskRemoveVariableWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.removeVariable(taskId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testProcessTaskRemoveVariableWithReadInstancePermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.removeVariable(taskId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testProcessTaskRemoveVariableWithReadInstancePermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.removeVariable(taskId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testCaseTaskRemoveVariable() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.taskService.removeVariable(taskId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testStandaloneTaskRemoveVariableLocalWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.removeVariableLocal(taskId, "aVariableName");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskRemoveVariableLocalWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "aVariableName", (Object)"aVariableValue");
        this.enableAuthorization();
        this.taskService.removeVariableLocal(taskId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskRemoveVariableLocalWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "aVariableName", (Object)"aVariableValue");
        this.enableAuthorization();
        this.taskService.removeVariableLocal(taskId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskRemoveVariableLocalWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.removeVariableLocal(taskId, "aVariableName");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskRemoveVariableLocalWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.disableAuthorization();
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.enableAuthorization();
        this.taskService.removeVariableLocal(taskId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testProcessTaskRemoveVariableLocalWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.disableAuthorization();
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.enableAuthorization();
        this.taskService.removeVariableLocal(taskId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testProcessTaskRemoveVariableLocalWithReadInstancePermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.disableAuthorization();
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.enableAuthorization();
        this.taskService.removeVariableLocal(taskId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testProcessTaskRemoveVariableLocalWithReadInstancePermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.disableAuthorization();
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.enableAuthorization();
        this.taskService.removeVariableLocal(taskId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testCaseTaskRemoveVariableLocal() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.enableAuthorization();
        this.taskService.removeVariableLocal(taskId, "aVariableName");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testStandaloneTaskRemoveVariablesWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.removeVariables(taskId, Arrays.asList("aVariableName"));
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskRemoveVariablesWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.removeVariables(taskId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskRemoveVariablesWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.removeVariables(taskId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskRemoveVariablesWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.removeVariables(taskId, Arrays.asList("aVariableName"));
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskRemoveVariablesWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.removeVariables(taskId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testProcessTaskRemoveVariablesWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.removeVariables(taskId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testProcessTaskRemoveVariablesWithReadInstancePermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.removeVariables(taskId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testProcessTaskRemoveVariablesWithReadInstancePermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.removeVariables(taskId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testCaseTaskRemoveVariables() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.taskService.removeVariables(taskId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testStandaloneTaskRemoveVariablesLocalWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.removeVariablesLocal(taskId, Arrays.asList("aVariableName"));
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskRemoveVariablesLocalWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "aVariableName", (Object)"aVariableValue");
        this.enableAuthorization();
        this.taskService.removeVariablesLocal(taskId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskRemoveVariablesLocalWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "aVariableName", (Object)"aVariableValue");
        this.enableAuthorization();
        this.taskService.removeVariablesLocal(taskId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskRemoveVariablesLocalWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.removeVariablesLocal(taskId, Arrays.asList("aVariableName"));
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskRemoveVariablesLocalWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.disableAuthorization();
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.enableAuthorization();
        this.taskService.removeVariablesLocal(taskId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testProcessTaskRemoveVariablesLocalWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.disableAuthorization();
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.enableAuthorization();
        this.taskService.removeVariablesLocal(taskId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testProcessTaskRemoveVariablesLocalWithReadInstancePermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.disableAuthorization();
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.enableAuthorization();
        this.taskService.removeVariablesLocal(taskId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testProcessTaskRemoveVariablesLocalWithReadInstancePermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.disableAuthorization();
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.enableAuthorization();
        this.taskService.removeVariablesLocal(taskId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testCaseTaskRemoveVariablesLocal() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.enableAuthorization();
        this.taskService.removeVariablesLocal(taskId, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testStandaloneTaskUpdateVariablesLocalWithoutAuthorization() {
        String message;
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), null);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        try {
            ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, null, Arrays.asList("aVariableName"));
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        try {
            ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskUpdateVariablesLocalWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskUpdateVariablesLocalWithReadPermissionOnAnyTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskUpdateVariablesLocalWithoutAuthorization() {
        String message;
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), null);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        try {
            ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, null, Arrays.asList("aVariableName"));
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        try {
            ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskUpdateVariablesLocalWithUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testProcessTaskUpdateVariablesLocalWithUpdatePermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testProcessTaskUpdateVariablesLocalWithUpdateTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testProcessTaskUpdateVariablesLocalWithUpdateTaskPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_TASK});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testCaseTaskUpdateVariablesLocal() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testProcessTaskUpdateVariablesWithoutAuthorization() {
        String message;
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            ((TaskServiceImpl)this.taskService).updateVariables(taskId, (Map)this.getVariables(), null);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        try {
            ((TaskServiceImpl)this.taskService).updateVariables(taskId, null, Arrays.asList("aVariableName"));
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        try {
            ((TaskServiceImpl)this.taskService).updateVariables(taskId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskUpdateVariablesWithUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testProcessTaskUpdateVariablesWithUpdatePermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testProcessTaskUpdateVariablesWithUpdateTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testProcessTaskUpdateVariablesWithUpdateTaskPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_TASK});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testCaseTaskUpdateVariables() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, (Map)this.getVariables(), null);
        this.disableAuthorization();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, null, Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.disableAuthorization();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testStandaloneTaskSaveWithGenericResourceIdOwner() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE});
        Task task = this.taskService.newTask();
        task.setOwner("*");
        try {
            this.taskService.saveTask(task);
            TaskAuthorizationTest.fail((String)"it should not be possible to save a task with the generic resource id *");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot create default authorization for owner *: id cannot be *. * is a reserved identifier", e.getMessage());
        }
    }

    public void testStandaloneTaskSaveWithGenericResourceIdOwnerTaskServiceApi() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.UPDATE});
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        try {
            this.taskService.setOwner(task.getId(), "*");
            TaskAuthorizationTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot create default authorization for owner *: id cannot be *. * is a reserved identifier", e.getMessage());
        }
        this.deleteTask(task.getId(), true);
    }

    public void testStandaloneTaskSaveWithGenericResourceIdAssignee() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE});
        Task task = this.taskService.newTask();
        task.setAssignee("*");
        try {
            this.taskService.saveTask(task);
            TaskAuthorizationTest.fail((String)"it should not be possible to save a task with the generic resource id *");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot create default authorization for assignee *: id cannot be *. * is a reserved identifier", e.getMessage());
        }
    }

    public void testStandaloneTaskSaveWithGenericResourceIdAssigneeTaskServiceApi() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.UPDATE});
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        try {
            this.taskService.setAssignee(task.getId(), "*");
            TaskAuthorizationTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot create default authorization for assignee *: id cannot be *. * is a reserved identifier", e.getMessage());
        }
        this.deleteTask(task.getId(), true);
    }

    public void testStandaloneTaskSaveIdentityLinkWithGenericUserId() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.UPDATE});
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        try {
            this.taskService.addUserIdentityLink(task.getId(), "*", "someLink");
            TaskAuthorizationTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot grant default authorization for identity link to user *: id cannot be *. * is a reserved identifier.", e.getMessage());
        }
        this.deleteTask(task.getId(), true);
    }

    public void testStandaloneTaskSaveIdentityLinkWithGenericGroupId() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.UPDATE});
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        try {
            this.taskService.addGroupIdentityLink(task.getId(), "*", "someLink");
            TaskAuthorizationTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot grant default authorization for identity link to group *: id cannot be *. * is a reserved identifier.", e.getMessage());
        }
        this.deleteTask(task.getId(), true);
    }

    public void testStandaloneTaskSaveIdentityLinkWithGenericTaskId() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.UPDATE});
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        try {
            this.taskService.addUserIdentityLink("*", "aUserId", "someLink");
            TaskAuthorizationTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot find task with id *", e.getMessage());
        }
        try {
            this.taskService.addGroupIdentityLink("*", "aGroupId", "someLink");
            TaskAuthorizationTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot find task with id *", e.getMessage());
        }
        this.deleteTask(task.getId(), true);
    }

    @Deployment
    public void testSetGenericResourceIdAssignee() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.startProcessInstanceByKey("genericResourceIdAssignmentProcess");
            TaskAuthorizationTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot create default authorization for assignee *: id cannot be *. * is a reserved identifier.", e.getMessage());
        }
    }

    protected void verifyQueryResults(TaskQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected void verifyQueryResults(VariableInstanceQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }
}

