/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.Map;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;

public class VariableInstanceAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected static final String CASE_KEY = "oneTaskCase";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
    }

    public void testProcessVariableQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testCaseVariableQueryWithoutAuthorization() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testProcessLocalTaskVariableQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, "aVariableName", "aVariableValue");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testCaseLocalTaskVariableQueryWithoutAuthorization() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, "aVariableName", "aVariableValue");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testStandaloneTaskVariableQueryWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.setTaskVariable(taskId, "aVariableName", "aVariableValue");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.deleteTask(taskId, true);
    }

    public void testProcessVariableQueryWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        VariableInstance variable = (VariableInstance)query.singleResult();
        VariableInstanceAuthorizationTest.assertNotNull((Object)variable);
        VariableInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)variable.getProcessInstanceId());
    }

    public void testProcessVariableQueryWithReadInstancesPermissionOnOneTaskProcess() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        VariableInstance variable = (VariableInstance)query.singleResult();
        VariableInstanceAuthorizationTest.assertNotNull((Object)variable);
        VariableInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)variable.getProcessInstanceId());
    }

    public void testProcessLocalTaskVariableQueryWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, "aVariableName", "aVariableValue");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testProcessLocalTaskVariableQueryWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, "aVariableName", "aVariableValue");
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        VariableInstance variable = (VariableInstance)query.singleResult();
        VariableInstanceAuthorizationTest.assertNotNull((Object)variable);
        VariableInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)variable.getProcessInstanceId());
    }

    public void testProcessLocalTaskVariableQueryWithReadPermissionOnOneProcessTask() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, "aVariableName", "aVariableValue");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        VariableInstance variable = (VariableInstance)query.singleResult();
        VariableInstanceAuthorizationTest.assertNotNull((Object)variable);
        VariableInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)variable.getProcessInstanceId());
    }

    public void testStandaloneTaskVariableQueryWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.setTaskVariable(taskId, "aVariableName", "aVariableValue");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.deleteTask(taskId, true);
    }

    public void testMixedVariables() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.setTaskVariable(taskId, "aVariableName", "aVariableValue");
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getProcessInstanceId();
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.verifyQueryResults(query, 2);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        this.verifyQueryResults(query, 3);
        this.deleteTask(taskId, true);
    }

    protected void verifyQueryResults(VariableInstanceQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }
}

