/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.externaltask;

import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;

public class ExternalTaskQueryAuthorizationTest
extends AuthorizationTest {
    protected String deploymentId;
    protected String instance1Id;
    protected String instance2Id;

    @Override
    protected void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml").getId();
        this.instance1Id = this.startProcessInstanceByKey("oneExternalTaskProcess").getId();
        this.instance2Id = this.startProcessInstanceByKey("twoExternalTaskProcess").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
    }

    public void testQueryWithoutAuthorization() {
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    public void testQueryWithReadOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ});
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        ExternalTaskQueryAuthorizationTest.assertEquals((String)this.instance1Id, (String)((ExternalTask)query.list().get(0)).getProcessInstanceId());
    }

    public void testQueryWithReadOnAnyProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    public void testQueryWithReadInstanceOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        ExternalTaskQueryAuthorizationTest.assertEquals((String)this.instance1Id, (String)((ExternalTask)query.list().get(0)).getProcessInstanceId());
    }

    public void testQueryWithReadInstanceOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }
}

