/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.externaltask;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ExternalTaskSupportTest {
    @Rule
    public ProcessEngineRule rule = new ProcessEngineRule();
    @Parameterized.Parameter
    public String processDefinitionResource;
    protected String deploymentId;

    @Parameterized.Parameters
    public static Collection<Object[]> processResources() {
        return Arrays.asList({"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskSupportTest.businessRuleTask.bpmn20.xml"}, {"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskSupportTest.messageEndEvent.bpmn20.xml"}, {"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskSupportTest.messageIntermediateEvent.bpmn20.xml"}, {"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskSupportTest.sendTask.bpmn20.xml"});
    }

    @Before
    public void setUp() {
        this.deploymentId = this.rule.getRepositoryService().createDeployment().addClasspathResource(this.processDefinitionResource).deploy().getId();
    }

    @After
    public void tearDown() {
        if (this.deploymentId != null) {
            this.rule.getRepositoryService().deleteDeployment(this.deploymentId, true);
        }
    }

    @Test
    public void testExternalTaskSupport() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.rule.getRepositoryService().createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(processDefinition.getId());
        List externalTasks = this.rule.getExternalTaskService().fetchAndLock(1, "aWorker").topic("externalTaskTopic", 5000L).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
        Assert.assertEquals((Object)processInstance.getId(), (Object)((LockedExternalTask)externalTasks.get(0)).getProcessInstanceId());
        this.rule.getExternalTaskService().complete(((LockedExternalTask)externalTasks.get(0)).getId(), "aWorker");
        Assert.assertEquals((long)0L, (long)this.rule.getRuntimeService().createProcessInstanceQuery().count());
    }
}

