/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.form;

import java.util.Map;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.camunda.bpm.engine.impl.core.variable.scope.CoreVariableStore;
import org.camunda.bpm.engine.impl.core.variable.scope.SimpleVariableStore;
import org.camunda.bpm.engine.impl.form.FormException;
import org.camunda.bpm.engine.impl.form.handler.FormFieldHandler;
import org.camunda.bpm.engine.impl.form.validator.FormFieldValidatorContext;
import org.camunda.bpm.engine.impl.form.validator.FormValidators;
import org.camunda.bpm.engine.impl.form.validator.MaxLengthValidator;
import org.camunda.bpm.engine.impl.form.validator.MaxValidator;
import org.camunda.bpm.engine.impl.form.validator.MinLengthValidator;
import org.camunda.bpm.engine.impl.form.validator.MinValidator;
import org.camunda.bpm.engine.impl.form.validator.ReadOnlyValidator;
import org.camunda.bpm.engine.impl.form.validator.RequiredValidator;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;

public class BuiltInValidatorsTest
extends PluggableProcessEngineTestCase {
    public void testDefaultFormFieldValidators() {
        FormValidators formValidators = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration().getFormValidators();
        Map validators = formValidators.getValidators();
        BuiltInValidatorsTest.assertEquals(RequiredValidator.class, validators.get("required"));
        BuiltInValidatorsTest.assertEquals(ReadOnlyValidator.class, validators.get("readonly"));
        BuiltInValidatorsTest.assertEquals(MinValidator.class, validators.get("min"));
        BuiltInValidatorsTest.assertEquals(MaxValidator.class, validators.get("max"));
        BuiltInValidatorsTest.assertEquals(MaxLengthValidator.class, validators.get("maxlength"));
        BuiltInValidatorsTest.assertEquals(MinLengthValidator.class, validators.get("minlength"));
    }

    public void testRequiredValidator() {
        RequiredValidator validator = new RequiredValidator();
        TestValidatorContext validatorContext = new TestValidatorContext(null);
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)"test", (FormFieldValidatorContext)validatorContext));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)1, (FormFieldValidatorContext)validatorContext));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)true, (FormFieldValidatorContext)validatorContext));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)"", (FormFieldValidatorContext)validatorContext));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate(null, (FormFieldValidatorContext)validatorContext));
        validatorContext = new TestValidatorContext(null, "fieldName");
        validatorContext.getVariableScope().setVariable("fieldName", (Object)"existingValue");
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate(null, (FormFieldValidatorContext)validatorContext));
    }

    public void testReadOnlyValidator() {
        ReadOnlyValidator validator = new ReadOnlyValidator();
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)"", null));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)"aaa", null));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)11, null));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)2.0, null));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate(null, null));
    }

    public void testMinValidator() {
        MinValidator validator = new MinValidator();
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate(null, null));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)4, (FormFieldValidatorContext)new TestValidatorContext("4")));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)4, (FormFieldValidatorContext)new TestValidatorContext("5")));
        try {
            validator.validate((Object)4, (FormFieldValidatorContext)new TestValidatorContext("4.4"));
            BuiltInValidatorsTest.fail((String)"exception expected");
        }
        catch (FormException e) {
            BuiltInValidatorsTest.assertTrue((boolean)e.getMessage().contains("Cannot validate Integer value 4: configuration 4.4 cannot be parsed as Integer."));
        }
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)4.0, (FormFieldValidatorContext)new TestValidatorContext("4.1")));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)4.1, (FormFieldValidatorContext)new TestValidatorContext("4.1")));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)Float.valueOf(4.0f), (FormFieldValidatorContext)new TestValidatorContext("4.1")));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)Float.valueOf(4.1f), (FormFieldValidatorContext)new TestValidatorContext("4.1")));
    }

    public void testMaxValidator() {
        MaxValidator validator = new MaxValidator();
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate(null, null));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)3, (FormFieldValidatorContext)new TestValidatorContext("4")));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)4, (FormFieldValidatorContext)new TestValidatorContext("3")));
        try {
            validator.validate((Object)4, (FormFieldValidatorContext)new TestValidatorContext("4.4"));
            BuiltInValidatorsTest.fail((String)"exception expected");
        }
        catch (FormException e) {
            BuiltInValidatorsTest.assertTrue((boolean)e.getMessage().contains("Cannot validate Integer value 4: configuration 4.4 cannot be parsed as Integer."));
        }
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)4.1, (FormFieldValidatorContext)new TestValidatorContext("4")));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)4.1, (FormFieldValidatorContext)new TestValidatorContext("4.2")));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)Float.valueOf(4.1f), (FormFieldValidatorContext)new TestValidatorContext("4")));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)Float.valueOf(4.1f), (FormFieldValidatorContext)new TestValidatorContext("4.2")));
    }

    public void testMaxLengthValidator() {
        MaxLengthValidator validator = new MaxLengthValidator();
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate(null, null));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)"test", (FormFieldValidatorContext)new TestValidatorContext("5")));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)"test", (FormFieldValidatorContext)new TestValidatorContext("4")));
        try {
            validator.validate((Object)"test", (FormFieldValidatorContext)new TestValidatorContext("4.4"));
            BuiltInValidatorsTest.fail((String)"exception expected");
        }
        catch (FormException e) {
            BuiltInValidatorsTest.assertTrue((boolean)e.getMessage().contains("Cannot validate \"maxlength\": configuration 4.4 cannot be interpreted as Integer"));
        }
    }

    public void testMinLengthValidator() {
        MinLengthValidator validator = new MinLengthValidator();
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate(null, null));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)"test", (FormFieldValidatorContext)new TestValidatorContext("4")));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)"test", (FormFieldValidatorContext)new TestValidatorContext("5")));
        try {
            validator.validate((Object)"test", (FormFieldValidatorContext)new TestValidatorContext("4.4"));
            BuiltInValidatorsTest.fail((String)"exception expected");
        }
        catch (FormException e) {
            BuiltInValidatorsTest.assertTrue((boolean)e.getMessage().contains("Cannot validate \"minlength\": configuration 4.4 cannot be interpreted as Integer"));
        }
    }

    protected static class TestVariableScope
    extends AbstractVariableScope {
        protected SimpleVariableStore variableStore = new SimpleVariableStore();

        protected TestVariableScope() {
        }

        protected CoreVariableStore getVariableStore() {
            return this.variableStore;
        }

        public AbstractVariableScope getParentVariableScope() {
            return null;
        }
    }

    protected static class TestValidatorContext
    implements FormFieldValidatorContext {
        TestVariableScope variableScope = new TestVariableScope();
        FormFieldHandler formFieldHandler = new FormFieldHandler();
        String configuration;

        public TestValidatorContext(String configuration) {
            this.configuration = configuration;
        }

        public TestValidatorContext(String configuration, String formFieldId) {
            this.configuration = configuration;
            this.formFieldHandler.setId(formFieldId);
        }

        public FormFieldHandler getFormFieldHandler() {
            return this.formFieldHandler;
        }

        public DelegateExecution getExecution() {
            return null;
        }

        public String getConfiguration() {
            return this.configuration;
        }

        public Map<String, Object> getSubmittedValues() {
            return null;
        }

        public VariableScope getVariableScope() {
            return this.variableScope;
        }
    }
}

