/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyProcessInstantiationTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final BpmnModelInstance PROCESS = Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask("userTask").endEvent().done();

    public void testStartProcessInstanceByKeyAndTenantId() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_ONE).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testStartProcessInstanceByKeyForAnyTenant() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.runtimeService.createProcessInstanceByKey("testProcess").execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testFailToStartProcessInstanceByKeyForOtherTenant() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        try {
            this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_TWO).execute();
            MultiTenancyProcessInstantiationTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no processes deployed"));
        }
    }

    public void testFailToStartProcessInstanceByKeyForMultipleTenants() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        try {
            this.runtimeService.createProcessInstanceByKey("testProcess").execute();
            MultiTenancyProcessInstantiationTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"multiple tenants"));
        }
    }

    public void testFailToStartProcessInstanceByIdAndTenantId() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        try {
            this.runtimeService.createProcessInstanceById(processDefinition.getId()).processDefinitionTenantId(TENANT_ONE).execute();
            MultiTenancyProcessInstantiationTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }

    public void testStartProcessInstanceAtActivityByKeyAndTenantId() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_ONE).startBeforeActivity("userTask")).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testStartProcessInstanceAtActivityByKeyForAnyTenant() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").startBeforeActivity("userTask")).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testFailToStartProcessInstanceAtActivityByKeyForOtherTenant() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_TWO).startBeforeActivity("userTask")).execute();
            MultiTenancyProcessInstantiationTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no processes deployed"));
        }
    }

    public void testFailToStartProcessInstanceAtActivityByKeyForMultipleTenants() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").startBeforeActivity("userTask")).execute();
            MultiTenancyProcessInstantiationTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"multiple tenants"));
        }
    }

    public void testFailToStartProcessInstanceAtActivityByIdAndTenantId() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinition.getId()).processDefinitionTenantId(TENANT_ONE).startBeforeActivity("userTask")).execute();
            MultiTenancyProcessInstantiationTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }
}

