/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.List;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.repository.ResourceDefinitionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyRepositoryServiceTest
extends PluggableProcessEngineTestCase {
    protected static final BpmnModelInstance emptyProcess = Bpmn.createExecutableProcess().done();
    protected static final String CMMN = "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment.cmmn";
    protected static final String DMN = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";

    public void testDeploymentWithoutTenantId() {
        this.createDeploymentBuilder().deploy();
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        Assert.assertThat((Object)deployment, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)deployment.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testDeploymentWithTenantId() {
        this.createDeploymentBuilder().tenantId("tenant1").deploy();
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        Assert.assertThat((Object)deployment, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)deployment.getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant1"));
    }

    public void testProcessDefinitionVersionWithTenantId() {
        this.createDeploymentBuilder().tenantId("tenant1").deploy();
        this.createDeploymentBuilder().tenantId("tenant1").deploy();
        this.createDeploymentBuilder().tenantId("tenant2").deploy();
        List processDefinitions = ((ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByTenantId().asc()).orderByProcessDefinitionVersion().asc()).list();
        Assert.assertThat((Object)processDefinitions.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(0)).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(1)).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(2)).getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testDeploymentWithDuplicateFilteringForSameTenant() {
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").tenantId("tenant1").deploy();
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").tenantId("tenant1").deploy();
        Assert.assertThat((Object)this.repositoryService.createDeploymentQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testDeploymentWithDuplicateFilteringForDifferentTenants() {
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").tenantId("tenant1").deploy();
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").tenantId("tenant2").deploy();
        Assert.assertThat((Object)this.repositoryService.createDeploymentQuery().count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testDeploymentWithDuplicateFilteringIgnoreDeploymentForNoTenant() {
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").deploy();
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").tenantId("tenant1").deploy();
        Assert.assertThat((Object)this.repositoryService.createDeploymentQuery().count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testDeploymentWithDuplicateFilteringIgnoreDeploymentForTenant() {
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").tenantId("tenant1").deploy();
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").deploy();
        Assert.assertThat((Object)this.repositoryService.createDeploymentQuery().count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testGetPreviousProcessDefinitionWithTenantId() {
        this.deploymentForTenant("tenant1", new BpmnModelInstance[]{emptyProcess});
        this.deploymentForTenant("tenant1", new BpmnModelInstance[]{emptyProcess});
        this.deploymentForTenant("tenant1", new BpmnModelInstance[]{emptyProcess});
        this.deploymentForTenant("tenant2", new BpmnModelInstance[]{emptyProcess});
        this.deploymentForTenant("tenant2", new BpmnModelInstance[]{emptyProcess});
        List latestProcessDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().latestVersion().orderByTenantId().asc()).list();
        ProcessDefinitionEntity previousDefinitionTenantOne = this.getPreviousDefinition((ProcessDefinitionEntity)latestProcessDefinitions.get(0));
        ProcessDefinitionEntity previousDefinitionTenantTwo = this.getPreviousDefinition((ProcessDefinitionEntity)latestProcessDefinitions.get(1));
        Assert.assertThat((Object)previousDefinitionTenantOne.getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)previousDefinitionTenantOne.getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant1"));
        Assert.assertThat((Object)previousDefinitionTenantTwo.getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)previousDefinitionTenantTwo.getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant2"));
    }

    public void testGetPreviousCaseDefinitionWithTenantId() {
        this.deploymentForTenant("tenant1", new String[]{CMMN});
        this.deploymentForTenant("tenant1", new String[]{CMMN});
        this.deploymentForTenant("tenant1", new String[]{CMMN});
        this.deploymentForTenant("tenant2", new String[]{CMMN});
        this.deploymentForTenant("tenant2", new String[]{CMMN});
        List latestCaseDefinitions = ((CaseDefinitionQuery)this.repositoryService.createCaseDefinitionQuery().latestVersion().orderByTenantId().asc()).list();
        CaseDefinitionEntity previousDefinitionTenantOne = this.getPreviousDefinition((CaseDefinitionEntity)latestCaseDefinitions.get(0));
        CaseDefinitionEntity previousDefinitionTenantTwo = this.getPreviousDefinition((CaseDefinitionEntity)latestCaseDefinitions.get(1));
        Assert.assertThat((Object)previousDefinitionTenantOne.getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)previousDefinitionTenantOne.getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant1"));
        Assert.assertThat((Object)previousDefinitionTenantTwo.getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)previousDefinitionTenantTwo.getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant2"));
    }

    public void testGetPreviousDecisionDefinitionWithTenantId() {
        this.deploymentForTenant("tenant1", new String[]{DMN});
        this.deploymentForTenant("tenant1", new String[]{DMN});
        this.deploymentForTenant("tenant1", new String[]{DMN});
        this.deploymentForTenant("tenant2", new String[]{DMN});
        this.deploymentForTenant("tenant2", new String[]{DMN});
        List latesDefinitions = ((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().latestVersion().orderByTenantId().asc()).list();
        DecisionDefinitionEntity previousDefinitionTenantOne = this.getPreviousDefinition((DecisionDefinitionEntity)latesDefinitions.get(0));
        DecisionDefinitionEntity previousDefinitionTenantTwo = this.getPreviousDefinition((DecisionDefinitionEntity)latesDefinitions.get(1));
        Assert.assertThat((Object)previousDefinitionTenantOne.getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)previousDefinitionTenantOne.getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant1"));
        Assert.assertThat((Object)previousDefinitionTenantTwo.getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)previousDefinitionTenantTwo.getTenantId(), (Matcher)CoreMatchers.is((Object)"tenant2"));
    }

    protected <T extends ResourceDefinitionEntity> T getPreviousDefinition(final T definitionEntity) {
        return (T)((ResourceDefinitionEntity)this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new Command<T>(){

            public T execute(CommandContext commandContext) {
                return definitionEntity.getPreviousDefinition();
            }
        }));
    }

    protected DeploymentBuilder createDeploymentBuilder() {
        return this.repositoryService.createDeployment().addModelInstance("testProcess.bpmn", emptyProcess);
    }

    protected void tearDown() throws Exception {
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }
}

