/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyTimerStartEventTest
extends PluggableProcessEngineTestCase {
    protected static final BpmnModelInstance PROCESS = ((StartEventBuilder)Bpmn.createExecutableProcess().startEvent().timerWithDuration("PT1M")).userTask().endEvent().done();
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    public void testStartProcessInstanceWithTenantId() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertThat((Object)job.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        this.managementService.executeJob(job.getId());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertThat((Object)processInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)processInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    public void testStartProcessInstanceTwoTenants() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        Job jobForTenantOne = (Job)this.managementService.createJobQuery().tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        Assert.assertThat((Object)jobForTenantOne, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.managementService.executeJob(jobForTenantOne.getId());
        Job jobForTenantTwo = (Job)this.managementService.createJobQuery().tenantIdIn(new String[]{TENANT_TWO}).singleResult();
        Assert.assertThat((Object)jobForTenantTwo, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.managementService.executeJob(jobForTenantTwo.getId());
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testDeleteJobsWhileUndeployment() {
        String deploymentForTenantOne = this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        String deploymentForTenantTwo = this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        JobQuery query = this.managementService.createJobQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
        this.repositoryService.deleteDeployment(deploymentForTenantOne, true);
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
        this.repositoryService.deleteDeployment(deploymentForTenantTwo, true);
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testDontCreateNewJobsWhileReDeployment() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        JobQuery query = this.managementService.createJobQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }
}

