/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyCaseDefinitionQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String CASE_DEFINITION_KEY = "Case_1";
    protected static final String CMMN = "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment.cmmn";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN});
        this.deploymentForTenant(TENANT_TWO, new String[]{CMMN});
    }

    public void testQueryWithoutTenantId() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByTenantId() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByTenantIds() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByKey() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByLatestWithoutTenantId() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN});
        CaseDefinitionQuery query = (CaseDefinitionQuery)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).latestVersion().orderByTenantId().asc();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        List caseDefinitions = query.list();
        Assert.assertThat((Object)((CaseDefinition)caseDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((CaseDefinition)caseDefinitions.get(0)).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((CaseDefinition)caseDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((CaseDefinition)caseDefinitions.get(1)).getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testQueryByLatestWithTenantId() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN});
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        CaseDefinition caseDefinition = (CaseDefinition)query.singleResult();
        Assert.assertThat((Object)caseDefinition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)caseDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)2));
        query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        caseDefinition = (CaseDefinition)query.singleResult();
        Assert.assertThat((Object)caseDefinition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)caseDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testQueryByLatestWithTenantIds() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN});
        CaseDefinitionQuery query = (CaseDefinitionQuery)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        List caseDefinitions = query.list();
        Assert.assertThat((Object)((CaseDefinition)caseDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((CaseDefinition)caseDefinitions.get(0)).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((CaseDefinition)caseDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((CaseDefinition)caseDefinitions.get(1)).getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testQueryByNonExistingTenantId() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{null});
            MultiTenancyCaseDefinitionQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List caseDefinitions = ((CaseDefinitionQuery)this.repositoryService.createCaseDefinitionQuery().orderByTenantId().asc()).list();
        Assert.assertThat((Object)caseDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((CaseDefinition)caseDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((CaseDefinition)caseDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List caseDefinitions = ((CaseDefinitionQuery)this.repositoryService.createCaseDefinitionQuery().orderByTenantId().desc()).list();
        Assert.assertThat((Object)caseDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((CaseDefinition)caseDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((CaseDefinition)caseDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }
}

