/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyDecisionDefinitionQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String DECISION_DEFINITION_KEY = "decision";
    protected static final String DMN = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() {
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN});
    }

    public void testQueryWithoutTenantId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByTenantId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByTenantIds() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByKey() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByLatestWithoutTenantId() {
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN});
        DecisionDefinitionQuery query = (DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion().orderByTenantId().asc();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        List decisionDefinitions = query.list();
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(0)).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(1)).getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testQueryByLatestWithTenantId() {
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN});
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        Assert.assertThat((Object)decisionDefinition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)decisionDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)2));
        query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        decisionDefinition = (DecisionDefinition)query.singleResult();
        Assert.assertThat((Object)decisionDefinition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)decisionDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testQueryByLatestWithTenantIds() {
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN});
        DecisionDefinitionQuery query = (DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        List decisionDefinitions = query.list();
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(0)).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(1)).getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testQueryByNonExistingTenantId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{null});
            MultiTenancyDecisionDefinitionQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List decisionDefinitions = ((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().orderByTenantId().asc()).list();
        Assert.assertThat((Object)decisionDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List decisionDefinitions = ((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().orderByTenantId().desc()).list();
        Assert.assertThat((Object)decisionDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }
}

