/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.EventSubscriptionQuery;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyEventSubscriptionQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() {
        BpmnModelInstance process = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().message("start")).userTask().endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{process});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{process});
    }

    public void testQueryWithoutTenantId() {
        EventSubscriptionQuery query = this.runtimeService.createEventSubscriptionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByTenantId() {
        EventSubscriptionQuery query = this.runtimeService.createEventSubscriptionQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.runtimeService.createEventSubscriptionQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByTenantIds() {
        EventSubscriptionQuery query = this.runtimeService.createEventSubscriptionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByNonExistingTenantId() {
        EventSubscriptionQuery query = this.runtimeService.createEventSubscriptionQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.runtimeService.createEventSubscriptionQuery().tenantIdIn(new String[]{null});
            MultiTenancyEventSubscriptionQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List eventSubscriptions = ((EventSubscriptionQuery)this.runtimeService.createEventSubscriptionQuery().orderByTenantId().asc()).list();
        Assert.assertThat((Object)eventSubscriptions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((EventSubscription)eventSubscriptions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((EventSubscription)eventSubscriptions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List eventSubscriptions = ((EventSubscriptionQuery)this.runtimeService.createEventSubscriptionQuery().orderByTenantId().desc()).list();
        Assert.assertThat((Object)eventSubscriptions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((EventSubscription)eventSubscriptions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((EventSubscription)eventSubscriptions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }
}

