/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.IncidentQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyIncidentQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String BPMN = "org/camunda/bpm/engine/test/api/multitenancy/failingTask.bpmn";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() {
        this.deploymentForTenant(TENANT_ONE, new String[]{BPMN});
        this.deploymentForTenant(TENANT_TWO, new String[]{BPMN});
        this.startProcessInstanceAndExecuteFailingJobForTenant(TENANT_ONE);
        this.startProcessInstanceAndExecuteFailingJobForTenant(TENANT_TWO);
    }

    public void testQueryWithoutTenantId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByTenantId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.runtimeService.createIncidentQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByTenantIds() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByNonExistingTenantId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.runtimeService.createIncidentQuery().tenantIdIn(new String[]{null});
            MultiTenancyIncidentQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List incidents = ((IncidentQuery)this.runtimeService.createIncidentQuery().orderByTenantId().asc()).list();
        Assert.assertThat((Object)incidents.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Incident)incidents.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((Incident)incidents.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List incidents = ((IncidentQuery)this.runtimeService.createIncidentQuery().orderByTenantId().desc()).list();
        Assert.assertThat((Object)incidents.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Incident)incidents.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((Incident)incidents.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    protected void startProcessInstanceAndExecuteFailingJobForTenant(String tenant) {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{tenant}).singleResult()).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
        Job job = (Job)this.managementService.createJobQuery().processDefinitionId(processDefinitionId).singleResult();
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }
}

