/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyProcessDefinitionQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String PROCESS_DEFINITION_KEY = "process";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() {
        this.deployProcessDefinitionForTenant(TENANT_ONE);
        this.deployProcessDefinitionForTenant(TENANT_TWO);
    }

    protected void deployProcessDefinitionForTenant(String tenantId) {
        BpmnModelInstance emptyProcess = Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).done();
        this.deploymentForTenant(tenantId, new BpmnModelInstance[]{emptyProcess});
    }

    public void testQueryWithoutTenantId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByTenantId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByTenantIds() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByKey() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByLatestWithoutTenantId() {
        this.deployProcessDefinitionForTenant(TENANT_ONE);
        ProcessDefinitionQuery query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion().orderByTenantId().asc();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        List processDefinitions = query.list();
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(0)).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(1)).getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testQueryByLatestWithTenantId() {
        this.deployProcessDefinitionForTenant(TENANT_ONE);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        ProcessDefinition processDefinition = (ProcessDefinition)query.singleResult();
        Assert.assertThat((Object)processDefinition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)processDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)2));
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        processDefinition = (ProcessDefinition)query.singleResult();
        Assert.assertThat((Object)processDefinition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)processDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testQueryByLatestWithTenantIds() {
        this.deployProcessDefinitionForTenant(TENANT_ONE);
        ProcessDefinitionQuery query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        List processDefinitions = query.list();
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(0)).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(1)).getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testQueryByNonExistingTenantId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{null});
            MultiTenancyProcessDefinitionQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByTenantId().asc()).list();
        Assert.assertThat((Object)processDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByTenantId().desc()).list();
        Assert.assertThat((Object)processDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }
}

