/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyProcessInstanceQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() {
        BpmnModelInstance oneTaskProcess = Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{oneTaskProcess});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{oneTaskProcess});
        this.startProcessInstanceForTenant(TENANT_ONE);
        this.startProcessInstanceForTenant(TENANT_TWO);
    }

    public void testQueryWithoutTenantId() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByTenantId() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByTenantIds() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByNonExistingTenantId() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{null});
            MultiTenancyProcessInstanceQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List processInstances = ((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByTenantId().asc()).list();
        Assert.assertThat((Object)processInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ProcessInstance)processInstances.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((ProcessInstance)processInstances.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List processInstances = ((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByTenantId().desc()).list();
        Assert.assertThat((Object)processInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ProcessInstance)processInstances.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((ProcessInstance)processInstances.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    protected void startProcessInstanceForTenant(String tenant) {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{tenant}).singleResult()).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
    }
}

