/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.junit.Test;

public class MultiTenancyTaskQueryTest
extends PluggableProcessEngineTestCase {
    private static final String TENANT1 = "tenant1";
    private static final String TENANT2 = "tenant2";
    private static final String TENANT3 = "tenant3";

    @Test
    public void testQueryByTenantId() {
        String task1 = this.createTaskForTenant(TENANT1);
        String task2 = this.createTaskForTenant(TENANT2);
        MultiTenancyTaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT1}).count());
        MultiTenancyTaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT2}).count());
        MultiTenancyTaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT3}).count());
        MultiTenancyTaskQueryTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT1, TENANT2}).count());
        MultiTenancyTaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT1, TENANT3}).count());
        this.deleteTask(task1);
        this.deleteTask(task2);
    }

    @Test
    public void testQueryByTenantIdNullFails() {
        try {
            MultiTenancyTaskQueryTest.assertEquals((Object)0, (Object)this.taskService.createTaskQuery().tenantIdIn(new String[]{null}));
            MultiTenancyTaskQueryTest.fail((String)"Exception expected");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testOrderByTenantId() {
        String task1 = this.createTaskForTenant(TENANT1);
        String task2 = this.createTaskForTenant(TENANT2);
        String task3 = this.createTaskForTenant(TENANT3);
        List list = null;
        list = ((TaskQuery)this.taskService.createTaskQuery().orderByTenantId().asc()).list();
        MultiTenancyTaskQueryTest.assertEquals((String)task1, (String)((Task)list.get(0)).getId());
        MultiTenancyTaskQueryTest.assertEquals((String)task2, (String)((Task)list.get(1)).getId());
        MultiTenancyTaskQueryTest.assertEquals((String)task3, (String)((Task)list.get(2)).getId());
        list = ((TaskQuery)this.taskService.createTaskQuery().orderByTenantId().desc()).list();
        MultiTenancyTaskQueryTest.assertEquals((String)task3, (String)((Task)list.get(0)).getId());
        MultiTenancyTaskQueryTest.assertEquals((String)task2, (String)((Task)list.get(1)).getId());
        MultiTenancyTaskQueryTest.assertEquals((String)task1, (String)((Task)list.get(2)).getId());
        this.deleteTask(task1);
        this.deleteTask(task2);
        this.deleteTask(task3);
    }

    protected void deleteTask(String taskId) {
        this.taskService.deleteTask(taskId, true);
    }

    protected String createTaskForTenant(String tenantId) {
        Task task = this.taskService.newTask();
        task.setTenantId(tenantId);
        this.taskService.saveTask(task);
        return task.getId();
    }
}

