/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.SuspendedEntityInteractionException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class ProcessDefinitionSuspensionTest
extends PluggableProcessEngineTestCase {
    public void tearDown() throws Exception {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("activate-processdefinition");
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-processdefinition");
                return null;
            }
        });
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/processOne.bpmn20.xml"})
    public void testProcessDefinitionActiveByDefault() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessDefinitionSuspensionTest.assertFalse((boolean)processDefinition.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/processOne.bpmn20.xml"})
    public void testSuspendActivateProcessDefinitionById() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessDefinitionSuspensionTest.assertFalse((boolean)processDefinition.isSuspended());
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId());
        processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessDefinitionSuspensionTest.assertTrue((boolean)processDefinition.isSuspended());
        this.repositoryService.activateProcessDefinitionById(processDefinition.getId());
        processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessDefinitionSuspensionTest.assertFalse((boolean)processDefinition.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/processOne.bpmn20.xml"})
    public void testSuspendActivateProcessDefinitionByKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessDefinitionSuspensionTest.assertFalse((boolean)processDefinition.isSuspended());
        this.repositoryService.suspendProcessDefinitionByKey(processDefinition.getKey());
        processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessDefinitionSuspensionTest.assertTrue((boolean)processDefinition.isSuspended());
        this.repositoryService.activateProcessDefinitionByKey(processDefinition.getKey());
        processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessDefinitionSuspensionTest.assertFalse((boolean)processDefinition.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/processOne.bpmn20.xml"})
    public void testActivateAlreadyActiveProcessDefinition() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessDefinitionSuspensionTest.assertFalse((boolean)processDefinition.isSuspended());
        try {
            this.repositoryService.activateProcessDefinitionById(processDefinition.getId());
            processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
            ProcessDefinitionSuspensionTest.assertFalse((boolean)processDefinition.isSuspended());
        }
        catch (Exception e) {
            ProcessDefinitionSuspensionTest.fail((String)"Should be successful");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/processOne.bpmn20.xml"})
    public void testSuspendAlreadySuspendedProcessDefinition() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessDefinitionSuspensionTest.assertFalse((boolean)processDefinition.isSuspended());
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId());
        try {
            this.repositoryService.suspendProcessDefinitionById(processDefinition.getId());
            processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
            ProcessDefinitionSuspensionTest.assertTrue((boolean)processDefinition.isSuspended());
        }
        catch (Exception e) {
            ProcessDefinitionSuspensionTest.fail((String)"Should be successful");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/processOne.bpmn20.xml", "org/camunda/bpm/engine/test/api/repository/processTwo.bpmn20.xml"})
    public void testQueryForActiveDefinitions() {
        List processDefinitionList = this.repositoryService.createProcessDefinitionQuery().list();
        ProcessDefinitionSuspensionTest.assertEquals((int)2, (int)processDefinitionList.size());
        ProcessDefinitionSuspensionTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitionList.get(0);
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/processOne.bpmn20.xml", "org/camunda/bpm/engine/test/api/repository/processTwo.bpmn20.xml"})
    public void testQueryForSuspendedDefinitions() {
        List processDefinitionList = this.repositoryService.createProcessDefinitionQuery().list();
        ProcessDefinitionSuspensionTest.assertEquals((int)2, (int)processDefinitionList.size());
        ProcessDefinitionSuspensionTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitionList.get(0);
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/processOne.bpmn20.xml"})
    public void testStartProcessInstanceForSuspendedProcessDefinition() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId());
        try {
            this.runtimeService.startProcessInstanceById(processDefinition.getId());
            ProcessDefinitionSuspensionTest.fail((String)"Exception is expected but not thrown");
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresentIgnoreCase("is suspended", e.getMessage());
        }
        try {
            this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
            ProcessDefinitionSuspensionTest.fail((String)"Exception is expected but not thrown");
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresentIgnoreCase("is suspended", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testContinueProcessAfterProcessDefinitionSuspend() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ProcessDefinitionSuspensionTest.assertNotNull((Object)task);
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId());
        this.taskService.complete(task.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testSuspendProcessInstancesDuringProcessDefinitionSuspend() {
        int nrOfProcessInstances = 9;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        for (int i = 0; i < nrOfProcessInstances; ++i) {
            this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        }
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessInstances, (long)this.runtimeService.createProcessInstanceQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessInstances, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), true, null);
        for (ProcessInstance processInstance : this.runtimeService.createProcessInstanceQuery().list()) {
            ProcessDefinitionSuspensionTest.assertTrue((boolean)processInstance.isSuspended());
        }
        for (Task task : this.taskService.createTaskQuery().list()) {
            try {
                ProcessDefinitionSuspensionTest.assertTrue((boolean)task.isSuspended());
                this.taskService.complete(task.getId());
                ProcessDefinitionSuspensionTest.fail((String)"A suspended task shouldn't be able to be continued");
            }
            catch (SuspendedEntityInteractionException e) {
                this.assertTextPresentIgnoreCase("is suspended", e.getMessage());
            }
        }
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessInstances, (long)this.runtimeService.createProcessInstanceQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessInstances, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        this.repositoryService.activateProcessDefinitionById(processDefinition.getId(), true, null);
        for (Task task : this.taskService.createTaskQuery().list()) {
            this.taskService.complete(task.getId());
        }
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testSubmitStartFormAfterProcessDefinitionSuspend() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId());
        try {
            this.formService.submitStartFormData(processDefinition.getId(), new HashMap());
            ProcessDefinitionSuspensionTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresentIgnoreCase("is suspended", e.getMessage());
        }
        try {
            this.formService.submitStartFormData(processDefinition.getId(), "someKey", new HashMap());
            ProcessDefinitionSuspensionTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresentIgnoreCase("is suspended", e.getMessage());
        }
    }

    @Deployment
    public void testJobIsExecutedOnProcessDefinitionSuspend() {
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testDelayedSuspendProcessDefinition() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), false, new Date(oneWeekFromStartTime));
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        try {
            this.runtimeService.startProcessInstanceById(processDefinition.getId());
            ProcessDefinitionSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresentIgnoreCase("suspended", e.getMessage());
        }
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        this.repositoryService.activateProcessDefinitionById(processDefinition.getId());
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testDelayedSuspendProcessDefinitionIncludingProcessInstances() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        int nrOfProcessInstances = 30;
        for (int i = 0; i < nrOfProcessInstances; ++i) {
            this.runtimeService.startProcessInstanceById(processDefinition.getId());
        }
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessInstances, (long)this.runtimeService.createProcessInstanceQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessInstances, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessInstances, (long)this.taskService.createTaskQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), true, new Date(oneWeekFromStartTime));
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)(++nrOfProcessInstances), (long)this.runtimeService.createProcessInstanceQuery().count());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        try {
            this.runtimeService.startProcessInstanceById(processDefinition.getId());
            ProcessDefinitionSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresentIgnoreCase("suspended", e.getMessage());
        }
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessInstances, (long)this.runtimeService.createProcessInstanceQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessInstances, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessInstances, (long)this.taskService.createTaskQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        this.repositoryService.activateProcessDefinitionById(processDefinition.getId(), true, null);
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessInstances, (long)this.runtimeService.createProcessInstanceQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessInstances, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessInstances, (long)this.taskService.createTaskQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testDelayedActivateProcessDefinition() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId());
        try {
            this.runtimeService.startProcessInstanceById(processDefinition.getId());
            ProcessDefinitionSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresentIgnoreCase("suspended", e.getMessage());
        }
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        long oneDayFromStart = startTime.getTime() + 86400000L;
        this.repositoryService.activateProcessDefinitionById(processDefinition.getId(), false, new Date(oneDayFromStart));
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
    }

    public void testSuspendMultipleProcessDefinitionsByKey() {
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml").deploy();
        }
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessDefinitions, (long)this.repositoryService.createProcessDefinitionQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessDefinitions, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        this.repositoryService.suspendProcessDefinitionByKey("oneTaskProcess");
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessDefinitions, (long)this.repositoryService.createProcessDefinitionQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessDefinitions, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        this.repositoryService.activateProcessDefinitionByKey("oneTaskProcess");
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessDefinitions, (long)this.repositoryService.createProcessDefinitionQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessDefinitions, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.repositoryService.suspendProcessDefinitionByKey("oneTaskProcess", true, null);
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessDefinitions, (long)this.repositoryService.createProcessDefinitionQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessDefinitions, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testDelayedSuspendMultipleProcessDefinitionsByKey() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long hourInMs = 3600000L;
        int nrOfProcessDefinitions = 5;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml").deploy();
        }
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessDefinitions, (long)this.repositoryService.createProcessDefinitionQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessDefinitions, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.repositoryService.suspendProcessDefinitionByKey("oneTaskProcess", true, new Date(startTime.getTime() + 0x6DDD00L));
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessDefinitions, (long)this.repositoryService.createProcessDefinitionQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessDefinitions, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessDefinitions, (long)this.repositoryService.createProcessDefinitionQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessDefinitions, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        this.repositoryService.activateProcessDefinitionByKey("oneTaskProcess", true, new Date(startTime.getTime() + 18000000L));
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessDefinitions, (long)this.repositoryService.createProcessDefinitionQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessDefinitions, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessDefinitions, (long)this.repositoryService.createProcessDefinitionQuery().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)nrOfProcessDefinitions, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testSuspendById_shouldSuspendJobDefinitionAndRetainJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job job = (Job)jobQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)job.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testSuspendByKey_shouldSuspendJobDefinitionAndRetainJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionByKey(processDefinition.getKey());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job job = (Job)jobQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)job.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testSuspendByIdAndIncludeInstancesFlag_shouldSuspendAlsoJobDefinitionAndRetainJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job job = (Job)jobQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)job.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testSuspendByKeyAndIncludeInstancesFlag_shouldSuspendAlsoJobDefinitionAndRetainJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionByKey(processDefinition.getKey(), false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job job = (Job)jobQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)job.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testSuspendByIdAndIncludeInstancesFlag_shouldSuspendJobDefinitionAndJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job job = (Job)jobQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)job.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testSuspendByKeyAndIncludeInstancesFlag_shouldSuspendJobDefinitionAndJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionByKey(processDefinition.getKey(), true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job job = (Job)jobQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)job.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testDelayedSuspendByIdAndIncludeInstancesFlag_shouldSuspendJobDefinitionAndRetainJob() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long hourInMs = 3600000L;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), false, new Date(startTime.getTime() + 0x6DDD00L));
        Job timerToSuspendProcessDefinition = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertNotNull((Object)timerToSuspendProcessDefinition);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)2L, (long)jobQuery.active().count());
        this.managementService.executeJob(timerToSuspendProcessDefinition.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job job = (Job)jobQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)job.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testDelayedSuspendByKeyAndIncludeInstancesFlag_shouldSuspendJobDefinitionAndRetainJob() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long hourInMs = 3600000L;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionByKey(processDefinition.getKey(), false, new Date(startTime.getTime() + 0x6DDD00L));
        Job timerToSuspendProcessDefinition = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertNotNull((Object)timerToSuspendProcessDefinition);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)2L, (long)jobQuery.active().count());
        this.managementService.executeJob(timerToSuspendProcessDefinition.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job job = (Job)jobQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)job.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testDelayedSuspendByIdAndIncludeInstancesFlag_shouldSuspendJobDefinitionAndJob() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long hourInMs = 3600000L;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), true, new Date(startTime.getTime() + 0x6DDD00L));
        Job timerToSuspendProcessDefinition = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertNotNull((Object)timerToSuspendProcessDefinition);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)2L, (long)jobQuery.active().count());
        this.managementService.executeJob(timerToSuspendProcessDefinition.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job job = (Job)jobQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)job.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testDelayedSuspendByKeyAndIncludeInstancesFlag_shouldSuspendJobDefinitionAndJob() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long hourInMs = 3600000L;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionByKey(processDefinition.getKey(), true, new Date(startTime.getTime() + 0x6DDD00L));
        Job timerToSuspendProcessDefinition = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertNotNull((Object)timerToSuspendProcessDefinition);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)2L, (long)jobQuery.active().count());
        this.managementService.executeJob(timerToSuspendProcessDefinition.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job job = (Job)jobQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)job.isSuspended());
    }

    public void testMultipleSuspendByKey_shouldSuspendJobDefinitionAndRetainJob() {
        String key = "oneFailingServiceTaskProcess";
        int nrOfProcessDefinitions = 5;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.repositoryService.suspendProcessDefinitionByKey(key);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testMultipleSuspendByKeyAndIncludeInstances_shouldSuspendJobDefinitionAndRetainJob() {
        String key = "oneFailingServiceTaskProcess";
        int nrOfProcessDefinitions = 5;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.repositoryService.suspendProcessDefinitionByKey(key, false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testMultipleSuspendByKeyAndIncludeInstances_shouldSuspendJobDefinitionAndJob() {
        String key = "oneFailingServiceTaskProcess";
        int nrOfProcessDefinitions = 5;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.repositoryService.suspendProcessDefinitionByKey(key, true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobQuery.suspended().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testDelayedMultipleSuspendByKeyAndIncludeInstances_shouldSuspendJobDefinitionAndRetainJob() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long hourInMs = 3600000L;
        String key = "oneFailingServiceTaskProcess";
        int nrOfProcessDefinitions = 5;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.repositoryService.suspendProcessDefinitionByKey(key, false, new Date(startTime.getTime() + 0x6DDD00L));
        Job timerToSuspendProcessDefinition = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertNotNull((Object)timerToSuspendProcessDefinition);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)6L, (long)jobQuery.active().count());
        this.managementService.executeJob(timerToSuspendProcessDefinition.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testDelayedMultipleSuspendByKeyAndIncludeInstances_shouldSuspendJobDefinitionAndJob() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long hourInMs = 3600000L;
        String key = "oneFailingServiceTaskProcess";
        int nrOfProcessDefinitions = 5;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.repositoryService.suspendProcessDefinitionByKey(key, true, new Date(startTime.getTime() + 0x6DDD00L));
        Job timerToSuspendProcessDefinition = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertNotNull((Object)timerToSuspendProcessDefinition);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)6L, (long)jobQuery.active().count());
        this.managementService.executeJob(timerToSuspendProcessDefinition.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobQuery.suspended().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testActivationById_shouldActivateJobDefinitionAndRetainJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), true, null);
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        this.repositoryService.activateProcessDefinitionById(processDefinition.getId());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job job = (Job)jobQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)job.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testActivationByKey_shouldActivateJobDefinitionAndRetainJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), true, null);
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        this.repositoryService.activateProcessDefinitionByKey(processDefinition.getKey());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activatedJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)activatedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)activatedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job job = (Job)jobQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)job.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testActivationByIdAndIncludeInstancesFlag_shouldActivateAlsoJobDefinitionAndRetainJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), true, null);
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        this.repositoryService.activateProcessDefinitionById(processDefinition.getId(), false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activatedJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)activatedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)activatedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job job = (Job)jobQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)job.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testActivationByKeyAndIncludeInstancesFlag_shouldActivateAlsoJobDefinitionAndRetainJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), true, null);
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        this.repositoryService.activateProcessDefinitionByKey(processDefinition.getKey(), false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activatedJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)activatedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)activatedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job job = (Job)jobQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)job.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testActivationByIdAndIncludeInstancesFlag_shouldActivateJobDefinitionAndJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), true, null);
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        this.repositoryService.activateProcessDefinitionById(processDefinition.getId(), true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activatedJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)activatedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)activatedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job job = (Job)jobQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)job.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testActivationByKeyAndIncludeInstancesFlag_shouldActivateJobDefinitionAndJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), true, null);
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        this.repositoryService.activateProcessDefinitionByKey(processDefinition.getKey(), true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job job = (Job)jobQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)job.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testDelayedActivationByIdAndIncludeInstancesFlag_shouldActivateJobDefinitionAndRetainJob() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long hourInMs = 3600000L;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), true, null);
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        this.repositoryService.activateProcessDefinitionById(processDefinition.getId(), false, new Date(startTime.getTime() + 0x6DDD00L));
        Job timerToActivateProcessDefinition = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertNotNull((Object)timerToActivateProcessDefinition);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        this.managementService.executeJob(timerToActivateProcessDefinition.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job job = (Job)jobQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)job.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testDelayedActivationByKeyAndIncludeInstancesFlag_shouldActivateJobDefinitionAndRetainJob() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long hourInMs = 3600000L;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), true, null);
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        this.repositoryService.activateProcessDefinitionByKey(processDefinition.getKey(), false, new Date(startTime.getTime() + 0x6DDD00L));
        Job timerToActivateProcessDefinition = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertNotNull((Object)timerToActivateProcessDefinition);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        this.managementService.executeJob(timerToActivateProcessDefinition.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activatedJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)activatedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)activatedJobDefinition.isSuspended());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job job = (Job)jobQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)job.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testDelayedActivationByIdAndIncludeInstancesFlag_shouldActivateJobDefinitionAndJob() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long hourInMs = 3600000L;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), true, null);
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        this.repositoryService.activateProcessDefinitionById(processDefinition.getId(), true, new Date(startTime.getTime() + 0x6DDD00L));
        Job timerToActivateProcessDefinition = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertNotNull((Object)timerToActivateProcessDefinition);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        this.managementService.executeJob(timerToActivateProcessDefinition.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activatedJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)activatedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)activatedJobDefinition.isSuspended());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job job = (Job)jobQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)job.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn"})
    public void testDelayedActivationByKeyAndIncludeInstancesFlag_shouldActivateJobDefinitionAndJob() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long hourInMs = 3600000L;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), params);
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), true, null);
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        this.repositoryService.activateProcessDefinitionByKey(processDefinition.getKey(), true, new Date(startTime.getTime() + 0x6DDD00L));
        Job timerToActivateProcessDefinition = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertNotNull((Object)timerToActivateProcessDefinition);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        this.managementService.executeJob(timerToActivateProcessDefinition.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activatedJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)activatedJobDefinition.getId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)activatedJobDefinition.isSuspended());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job job = (Job)jobQuery.active().singleResult();
        ProcessDefinitionSuspensionTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        ProcessDefinitionSuspensionTest.assertFalse((boolean)job.isSuspended());
    }

    public void testMultipleActivationByKey_shouldActivateJobDefinitionAndRetainJob() {
        String key = "oneFailingServiceTaskProcess";
        int nrOfProcessDefinitions = 5;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.repositoryService.suspendProcessDefinitionByKey(key, true, null);
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        this.repositoryService.activateProcessDefinitionByKey(key);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobQuery.suspended().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testMultipleActivationByKeyAndIncludeInstances_shouldActivateJobDefinitionAndRetainJob() {
        String key = "oneFailingServiceTaskProcess";
        int nrOfProcessDefinitions = 5;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.repositoryService.suspendProcessDefinitionByKey(key, true, null);
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        this.repositoryService.activateProcessDefinitionByKey(key, false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobQuery.suspended().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testMultipleActivationByKeyAndIncludeInstances_shouldActivateJobDefinitionAndJob() {
        String key = "oneFailingServiceTaskProcess";
        int nrOfProcessDefinitions = 5;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.repositoryService.suspendProcessDefinitionByKey(key, true, null);
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        this.repositoryService.activateProcessDefinitionByKey(key, true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testDelayedMultipleActivationByKeyAndIncludeInstances_shouldActivateJobDefinitionAndRetainJob() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long hourInMs = 3600000L;
        String key = "oneFailingServiceTaskProcess";
        int nrOfProcessDefinitions = 5;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.repositoryService.suspendProcessDefinitionByKey(key, true, null);
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        this.repositoryService.activateProcessDefinitionByKey(key, false, new Date(startTime.getTime() + 0x6DDD00L));
        Job timerToActivateProcessDefinition = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertNotNull((Object)timerToActivateProcessDefinition);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        this.managementService.executeJob(timerToActivateProcessDefinition.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testDelayedMultipleActivationByKeyAndIncludeInstances_shouldActivateJobDefinitionAndJob() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long hourInMs = 3600000L;
        String key = "oneFailingServiceTaskProcess";
        int nrOfProcessDefinitions = 5;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testWithOneAsyncServiceTask.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.repositoryService.suspendProcessDefinitionByKey(key, true, null);
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        this.repositoryService.activateProcessDefinitionByKey(key, true, new Date(startTime.getTime() + 0x6DDD00L));
        Job timerToActivateProcessDefinition = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertNotNull((Object)timerToActivateProcessDefinition);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        this.managementService.executeJob(timerToActivateProcessDefinition.getId());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobDefinitionQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)5L, (long)jobQuery.active().count());
        ProcessDefinitionSuspensionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testSuspendStartTimerOnProcessDefinitionSuspension.bpmn20.xml"})
    public void testSuspendStartTimerOnProcessDefinitionSuspensionByKey() {
        Job startTimer = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertFalse((boolean)startTimer.isSuspended());
        this.repositoryService.suspendProcessDefinitionByKey("process");
        startTimer = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertTrue((boolean)startTimer.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testSuspendStartTimerOnProcessDefinitionSuspension.bpmn20.xml"})
    public void testSuspendStartTimerOnProcessDefinitionSuspensionById() {
        ProcessDefinition pd = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Job startTimer = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertFalse((boolean)startTimer.isSuspended());
        this.repositoryService.suspendProcessDefinitionById(pd.getId());
        startTimer = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertTrue((boolean)startTimer.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testSuspendStartTimerOnProcessDefinitionSuspension.bpmn20.xml"})
    public void testActivateStartTimerOnProcessDefinitionSuspensionByKey() {
        this.repositoryService.suspendProcessDefinitionByKey("process");
        Job startTimer = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertTrue((boolean)startTimer.isSuspended());
        this.repositoryService.activateProcessDefinitionByKey("process");
        startTimer = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertFalse((boolean)startTimer.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/ProcessDefinitionSuspensionTest.testSuspendStartTimerOnProcessDefinitionSuspension.bpmn20.xml"})
    public void testActivateStartTimerOnProcessDefinitionSuspensionById() {
        ProcessDefinition pd = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.repositoryService.suspendProcessDefinitionById(pd.getId());
        Job startTimer = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertTrue((boolean)startTimer.isSuspended());
        this.repositoryService.activateProcessDefinitionById(pd.getId());
        startTimer = (Job)this.managementService.createJobQuery().timers().singleResult();
        ProcessDefinitionSuspensionTest.assertFalse((boolean)startTimer.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testStartBeforeActivityForSuspendProcessDefinition() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), true, null);
        try {
            ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("theTask")).execute();
            ProcessDefinitionSuspensionTest.fail((String)"Exception is expected but not thrown");
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresentIgnoreCase("is suspended", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testStartAfterActivityForSuspendProcessDefinition() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), true, null);
        try {
            ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startAfterActivity("theTask")).execute();
            ProcessDefinitionSuspensionTest.fail((String)"Exception is expected but not thrown");
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresentIgnoreCase("is suspended", e.getMessage());
        }
    }
}

