/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.List;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ProcessInstanceSnapshot;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public abstract class AbstractMigrationTest {
    public static final String AFTER_BOUNDARY_TASK = "afterBoundary";
    public static final String MESSAGE_NAME = "Message";
    public static final String SIGNAL_NAME = "Signal";
    public static final String TIMER_DATE = "2016-02-11T12:13:14Z";
    public static final String NEW_TIMER_DATE = "2018-02-11T12:13:14Z";
    public static final String ERROR_CODE = "Error";
    public static final String ESCALATION_CODE = "Escalation";
    protected ProcessEngineRule rule = new ProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;
    protected TaskService taskService;

    @Before
    public void initServices() {
        this.runtimeService = this.rule.getRuntimeService();
        this.taskService = this.rule.getTaskService();
    }

    protected void completeTasks(String ... taskKeys) {
        List tasks = this.taskService.createTaskQuery().taskDefinitionKeyIn(taskKeys).list();
        Assert.assertEquals((long)taskKeys.length, (long)tasks.size());
        for (Task task : tasks) {
            Assert.assertNotNull((Object)task);
            this.taskService.complete(task.getId());
        }
    }

    protected void correlateMessageAndCompleteTasks(String messageName, String ... taskKeys) {
        this.runtimeService.createMessageCorrelation(messageName).correlate();
        this.completeTasks(taskKeys);
    }

    protected void sendSignalAndCompleteTasks(String signalName, String ... taskKeys) {
        this.runtimeService.signalEventReceived(signalName);
        this.completeTasks(taskKeys);
    }

    protected void assertEventSubscriptionMigrated(String activityIdBefore, String activityIdAfter, String eventName) {
        EventSubscription eventSubscriptionBefore = this.testHelper.snapshotBeforeMigration.getEventSubscriptionForActivityIdAndEventName(activityIdBefore, eventName);
        Assert.assertNotNull((String)("Expected that an event subscription for activity '" + activityIdBefore + "' exists before migration"), (Object)eventSubscriptionBefore);
        EventSubscription eventSubscriptionAfter = this.testHelper.snapshotAfterMigration.getEventSubscriptionForActivityIdAndEventName(activityIdAfter, eventName);
        Assert.assertNotNull((String)("Expected that an event subscription for activity '" + activityIdAfter + "' exists after migration"), (Object)eventSubscriptionAfter);
        Assert.assertEquals((Object)eventSubscriptionBefore.getId(), (Object)eventSubscriptionAfter.getId());
        Assert.assertEquals((Object)eventSubscriptionBefore.getEventType(), (Object)eventSubscriptionAfter.getEventType());
    }

    protected void assertEventSubscriptionRemoved(String activityId, String eventName) {
        EventSubscription eventSubscriptionBefore = this.testHelper.snapshotBeforeMigration.getEventSubscriptionForActivityIdAndEventName(activityId, eventName);
        Assert.assertNotNull((String)("Expected an event subscription for activity '" + activityId + "' before the migration"), (Object)eventSubscriptionBefore);
        for (EventSubscription eventSubscription : this.testHelper.snapshotAfterMigration.getEventSubscriptions()) {
            if (!eventSubscriptionBefore.getId().equals(eventSubscription.getId())) continue;
            Assert.fail((String)("Expected event subscription '" + eventSubscriptionBefore.getId() + "' to be removed after migration"));
        }
    }

    protected void assertEventSubscriptionCreated(String activityId, String eventName) {
        EventSubscription eventSubscriptionAfter = this.testHelper.snapshotAfterMigration.getEventSubscriptionForActivityIdAndEventName(activityId, eventName);
        Assert.assertNotNull((String)("Expected an event subscription for activity '" + activityId + "' after the migration"), (Object)eventSubscriptionAfter);
        for (EventSubscription eventSubscription : this.testHelper.snapshotBeforeMigration.getEventSubscriptions()) {
            if (!eventSubscriptionAfter.getId().equals(eventSubscription.getId())) continue;
            Assert.fail((String)("Expected event subscription '" + eventSubscriptionAfter.getId() + "' to be created after migration"));
        }
    }

    protected void assertTimerJobMigrated(String activityIdBefore, String activityIdAfter) {
        JobDefinition jobDefinitionBefore = this.testHelper.snapshotBeforeMigration.getJobDefinitionForActivityId(activityIdBefore);
        Assert.assertNotNull((String)("Expected that a job definition for activity '" + activityIdBefore + "' exists before migration"), (Object)jobDefinitionBefore);
        Job jobBefore = this.testHelper.snapshotBeforeMigration.getJobForDefinitionId(jobDefinitionBefore.getId());
        Assert.assertNotNull((String)("Expected that a timer job for activity '" + activityIdBefore + "' exists before migration"), (Object)jobBefore);
        this.assertTimerJob(jobBefore);
        JobDefinition jobDefinitionAfter = this.testHelper.snapshotAfterMigration.getJobDefinitionForActivityId(activityIdAfter);
        Assert.assertNotNull((String)("Expected that a job definition for activity '" + activityIdAfter + "' exists after migration"), (Object)jobDefinitionAfter);
        Job jobAfter = this.testHelper.snapshotAfterMigration.getJobForDefinitionId(jobDefinitionAfter.getId());
        Assert.assertNotNull((String)("Expected that a timer job for activity '" + activityIdAfter + "' exists after migration"), (Object)jobAfter);
        this.assertTimerJob(jobAfter);
        Assert.assertEquals((Object)jobBefore.getId(), (Object)jobAfter.getId());
        Assert.assertEquals((Object)jobBefore.getDuedate(), (Object)jobAfter.getDuedate());
        Assert.assertEquals((Object)jobDefinitionAfter.getProcessDefinitionId(), (Object)jobAfter.getProcessDefinitionId());
        Assert.assertEquals((Object)jobDefinitionAfter.getProcessDefinitionKey(), (Object)jobAfter.getProcessDefinitionKey());
    }

    protected void assertTimerJobsRemoved(String ... activityIds) {
        for (String activityId : activityIds) {
            this.assertTimerJobRemoved(activityId);
        }
    }

    protected void assertTimerJobRemoved(String activityId) {
        JobDefinition jobDefinitionBefore = this.testHelper.snapshotBeforeMigration.getJobDefinitionForActivityId(activityId);
        Assert.assertNotNull((String)("Expected that a job definition for activity '" + activityId + "' exists before migration"), (Object)jobDefinitionBefore);
        Job jobBefore = this.testHelper.snapshotBeforeMigration.getJobForDefinitionId(jobDefinitionBefore.getId());
        Assert.assertNotNull((String)("Expected that a timer job for activity '" + activityId + "' exists before migration"), (Object)jobBefore);
        this.assertTimerJob(jobBefore);
        for (Job job : this.testHelper.snapshotAfterMigration.getJobs()) {
            if (!jobBefore.getId().equals(job.getId())) continue;
            Assert.fail((String)("Expected job '" + jobBefore.getId() + "' to be removed after migration"));
        }
    }

    protected void assertTimerJobsCreated(String ... activityIds) {
        for (String activityId : activityIds) {
            this.assertTimerJobCreated(activityId);
        }
    }

    protected void assertTimerJobCreated(String activityId) {
        JobDefinition jobDefinitionAfter = this.testHelper.snapshotAfterMigration.getJobDefinitionForActivityId(activityId);
        Assert.assertNotNull((String)("Expected that a job definition for activity '" + activityId + "' exists after migration"), (Object)jobDefinitionAfter);
        Job jobAfter = this.testHelper.snapshotAfterMigration.getJobForDefinitionId(jobDefinitionAfter.getId());
        Assert.assertNotNull((String)("Expected that a timer job for activity '" + activityId + "' exists after migration"), (Object)jobAfter);
        this.assertTimerJob(jobAfter);
        for (Job job : this.testHelper.snapshotBeforeMigration.getJobs()) {
            if (!jobAfter.getId().equals(job.getId())) continue;
            Assert.fail((String)("Expected job '" + jobAfter.getId() + "' to be created first after migration"));
        }
    }

    protected Job assertTimerJobExists(ProcessInstanceSnapshot snapshot) {
        List<Job> jobs = snapshot.getJobs();
        Assert.assertEquals((long)1L, (long)jobs.size());
        Job job = jobs.get(0);
        this.assertTimerJob(job);
        return job;
    }

    protected void assertTimerJob(Job job) {
        Assert.assertEquals((String)"Expected job to be a timer job", (Object)"timer", (Object)((JobEntity)job).getType());
    }

    protected void triggerTimerAndCompleteTasks(String ... taskKeys) {
        Job job = this.assertTimerJobExists(this.testHelper.snapshotAfterMigration);
        this.rule.getManagementService().executeJob(job.getId());
        this.completeTasks(taskKeys);
    }
}

