/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.api.runtime.migration.AbstractMigrationTest;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.ProcessModels;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.junit.Test;

public class MigrationAddBoundaryEventsTest
extends AbstractMigrationTest {
    @Test
    public void testAddMessageBoundaryEventToUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addMessageBoundaryEventWithUserTask("userTask", "boundary", "Message", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionCreated("boundary", "Message");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToUserTaskAndCorrelateMessage() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addMessageBoundaryEventWithUserTask("userTask", "boundary", "Message", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.correlateMessageAndCompleteTasks("Message", "afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SCOPE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).addMessageBoundaryEventWithUserTask("userTask", "boundary", "Message", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionCreated("boundary", "Message");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToScopeUserTaskAndCorrelateMessage() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SCOPE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).addMessageBoundaryEventWithUserTask("userTask", "boundary", "Message", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.correlateMessageAndCompleteTasks("Message", "afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToConcurrentUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).addMessageBoundaryEventWithUserTask("userTask1", "boundary", "Message", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().up().up().child("userTask2").concurrent().noScope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertEventSubscriptionCreated("boundary", "Message");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToConcurrentUserTaskAndCorrelateMessage() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).addMessageBoundaryEventWithUserTask("userTask1", "boundary", "Message", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.correlateMessageAndCompleteTasks("Message", "afterBoundary", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToConcurrentScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SCOPE_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).addMessageBoundaryEventWithUserTask("userTask1", "boundary", "Message", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask1")).up().up().child(null).concurrent().noScope().child("userTask2").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask2")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertEventSubscriptionCreated("boundary", "Message");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToConcurrentScopeUserTaskAndCorrelateMessage() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SCOPE_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).addMessageBoundaryEventWithUserTask("userTask1", "boundary", "Message", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.correlateMessageAndCompleteTasks("Message", "afterBoundary", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addMessageBoundaryEventWithUserTask("subProcess", "boundary", "Message", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionCreated("boundary", "Message");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToSubProcessAndCorrelateMessage() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addMessageBoundaryEventWithUserTask("subProcess", "boundary", "Message", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.correlateMessageAndCompleteTasks("Message", "afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToSubProcessWithScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).addMessageBoundaryEventWithUserTask("subProcess", "boundary", "Message", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionCreated("boundary", "Message");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToSubProcessWithScopeUserTaskAndCorrelateMessage() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).addMessageBoundaryEventWithUserTask("subProcess", "boundary", "Message", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.correlateMessageAndCompleteTasks("Message", "afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToParallelSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).addMessageBoundaryEventWithUserTask("subProcess1", "boundary", "Message", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess1")).up().up().child(null).concurrent().noScope().child("userTask2").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess2")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess1", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess1").getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).endScope().beginScope("subProcess2", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess2").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertEventSubscriptionCreated("boundary", "Message");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToParallelSubProcessAndCorrelateMessage() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).addMessageBoundaryEventWithUserTask("subProcess1", "boundary", "Message", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.correlateMessageAndCompleteTasks("Message", "afterBoundary", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addSignalBoundaryEventWithUserTask("userTask", "boundary", "Signal", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionCreated("boundary", "Signal");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToUserTaskAndSendSignal() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addSignalBoundaryEventWithUserTask("userTask", "boundary", "Signal", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.sendSignalAndCompleteTasks("Signal", "afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SCOPE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).addSignalBoundaryEventWithUserTask("userTask", "boundary", "Signal", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionCreated("boundary", "Signal");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToScopeUserTaskAndSendSignal() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SCOPE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).addSignalBoundaryEventWithUserTask("userTask", "boundary", "Signal", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.sendSignalAndCompleteTasks("Signal", "afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToConcurrentUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).addSignalBoundaryEventWithUserTask("userTask1", "boundary", "Signal", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().up().up().child("userTask2").concurrent().noScope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertEventSubscriptionCreated("boundary", "Signal");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToConcurrentUserTaskAndSendSignal() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).addSignalBoundaryEventWithUserTask("userTask1", "boundary", "Signal", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.sendSignalAndCompleteTasks("Signal", "afterBoundary", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToConcurrentScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SCOPE_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).addSignalBoundaryEventWithUserTask("userTask1", "boundary", "Signal", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask1")).up().up().child(null).concurrent().noScope().child("userTask2").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask2")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertEventSubscriptionCreated("boundary", "Signal");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToConcurrentScopeUserTaskAndSendSignal() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SCOPE_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).addSignalBoundaryEventWithUserTask("userTask1", "boundary", "Signal", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.sendSignalAndCompleteTasks("Signal", "afterBoundary", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSignalBoundaryEventWithUserTask("subProcess", "boundary", "Signal", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionCreated("boundary", "Signal");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToSubProcessAndCorrelateSignal() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSignalBoundaryEventWithUserTask("subProcess", "boundary", "Signal", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.sendSignalAndCompleteTasks("Signal", "afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToSubProcessWithScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).addSignalBoundaryEventWithUserTask("subProcess", "boundary", "Signal", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionCreated("boundary", "Signal");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToSubProcessWithScopeUserTaskAndCorrelateSignal() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).addSignalBoundaryEventWithUserTask("subProcess", "boundary", "Signal", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.sendSignalAndCompleteTasks("Signal", "afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToParallelSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).addSignalBoundaryEventWithUserTask("subProcess1", "boundary", "Signal", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess1")).up().up().child(null).concurrent().noScope().child("userTask2").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess2")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess1", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess1").getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).endScope().beginScope("subProcess2", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess2").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertEventSubscriptionCreated("boundary", "Signal");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToParallelSubProcessAndCorrelateSignal() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).addSignalBoundaryEventWithUserTask("subProcess1", "boundary", "Signal", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.sendSignalAndCompleteTasks("Signal", "afterBoundary", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addTimerDateBoundaryEventWithUserTask("userTask", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertTimerJobCreated("boundary");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToUserTaskAndSendTimerWithDate() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addTimerDateBoundaryEventWithUserTask("userTask", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.triggerTimerAndCompleteTasks("afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SCOPE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).addTimerDateBoundaryEventWithUserTask("userTask", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertTimerJobCreated("boundary");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToScopeUserTaskAndSendTimerWithDate() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SCOPE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).addTimerDateBoundaryEventWithUserTask("userTask", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.triggerTimerAndCompleteTasks("afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToConcurrentUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).addTimerDateBoundaryEventWithUserTask("userTask1", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().up().up().child("userTask2").concurrent().noScope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertTimerJobCreated("boundary");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToConcurrentUserTaskAndSendTimerWithDate() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).addTimerDateBoundaryEventWithUserTask("userTask1", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.triggerTimerAndCompleteTasks("afterBoundary", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToConcurrentScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SCOPE_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).addTimerDateBoundaryEventWithUserTask("userTask1", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask1")).up().up().child(null).concurrent().noScope().child("userTask2").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask2")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertTimerJobCreated("boundary");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToConcurrentScopeUserTaskAndSendTimerWithDate() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SCOPE_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).addTimerDateBoundaryEventWithUserTask("userTask1", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.triggerTimerAndCompleteTasks("afterBoundary", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addTimerDateBoundaryEventWithUserTask("subProcess", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertTimerJobCreated("boundary");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToSubProcessAndCorrelateTimerWithDate() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addTimerDateBoundaryEventWithUserTask("subProcess", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.triggerTimerAndCompleteTasks("afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToSubProcessWithScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).addTimerDateBoundaryEventWithUserTask("subProcess", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertTimerJobCreated("boundary");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToSubProcessWithScopeUserTaskAndCorrelateTimerWithDate() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).addTimerDateBoundaryEventWithUserTask("subProcess", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.triggerTimerAndCompleteTasks("afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToParallelSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).addTimerDateBoundaryEventWithUserTask("subProcess1", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess1")).up().up().child(null).concurrent().noScope().child("userTask2").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess2")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess1", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess1").getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).endScope().beginScope("subProcess2", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess2").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertTimerJobCreated("boundary");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToParallelSubProcessAndCorrelateTimerWithDate() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).addTimerDateBoundaryEventWithUserTask("subProcess1", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.triggerTimerAndCompleteTasks("afterBoundary", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMultipleBoundaryEvents() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addTimerDateBoundaryEvent("subProcess", "timerBoundary", "2016-02-11T12:13:14Z").addMessageBoundaryEvent("userTask", "messageBoundary", "Message").addSignalBoundaryEvent("userTask", "signalBoundary", "Signal"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionCreated("messageBoundary", "Message");
        this.assertEventSubscriptionCreated("signalBoundary", "Signal");
        this.assertTimerJobCreated("timerBoundary");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddErrorBoundaryEventToSubProcessAndThrowError() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(((EndEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addErrorBoundaryEventWithUserTask("subProcess", "Error", "afterBoundary").getBuilderForElementById("subProcessEnd", EndEventBuilder.class).error("Error")).done());
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.completeTasks("userTask");
        this.completeTasks("afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddEscalationBoundaryEventToSubProcessAndThrowEscalation() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(((EndEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addEscalationBoundaryEventWithUserTask("subProcess", "Escalation", "afterBoundary").getBuilderForElementById("subProcessEnd", EndEventBuilder.class).escalation("Escalation")).done());
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.completeTasks("userTask");
        this.completeTasks("afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }
}

