/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.api.runtime.FailingDelegate;
import org.camunda.bpm.engine.test.api.runtime.migration.AbstractMigrationTest;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.ProcessModels;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.junit.Assert;
import org.junit.Test;

public class MigrationBoundaryEventsTest
extends AbstractMigrationTest {
    @Test
    public void testMigrateMessageBoundaryEventOnUserTask() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addMessageBoundaryEventWithUserTask("userTask", "boundary", "Message", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionMigrated("boundary", "newBoundary", "Message");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventOnUserTaskAndCorrelateMessage() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addMessageBoundaryEventWithUserTask("userTask", "boundary", "Message", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.correlateMessageAndCompleteTasks("Message", "afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventAndTriggerByOldMessageName() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addMessageBoundaryEventWithUserTask("userTask", "boundary", "Message", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addMessageBoundaryEventWithUserTask("userTask", "boundary", "newMessage", "afterBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.assertEventSubscriptionMigrated("boundary", "boundary", "Message");
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().eventName("newMessage").singleResult();
        Assert.assertNull((Object)eventSubscription);
        this.correlateMessageAndCompleteTasks("Message", "afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventOnScopeUserTask() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).addMessageBoundaryEventWithUserTask("userTask", "boundary", "Message", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionMigrated("boundary", "newBoundary", "Message");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventOnScopeUserTaskAndCorrelateMessage() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).addMessageBoundaryEventWithUserTask("userTask", "boundary", "Message", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.correlateMessageAndCompleteTasks("Message", "afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventOnConcurrentUserTask() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).addMessageBoundaryEventWithUserTask("userTask1", "boundary", "Message", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().up().up().child("userTask2").concurrent().noScope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertEventSubscriptionMigrated("boundary", "newBoundary", "Message");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventOnConcurrentUserTaskAndCorrelateMessage() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).addMessageBoundaryEventWithUserTask("userTask1", "boundary", "Message", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.correlateMessageAndCompleteTasks("Message", "afterBoundary", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventOnConcurrentScopeUserTask() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).addMessageBoundaryEventWithUserTask("userTask1", "boundary", "Message", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask1")).up().up().child(null).concurrent().noScope().child("userTask2").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask2")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertEventSubscriptionMigrated("boundary", "newBoundary", "Message");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventOnConcurrentScopeUserTaskAndCorrelateMessage() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).addMessageBoundaryEventWithUserTask("userTask1", "boundary", "Message", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.correlateMessageAndCompleteTasks("Message", "afterBoundary", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventToSubProcess() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addMessageBoundaryEventWithUserTask("subProcess", "boundary", "Message", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionMigrated("boundary", "newBoundary", "Message");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventToSubProcessAndCorrelateMessage() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addMessageBoundaryEventWithUserTask("subProcess", "boundary", "Message", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.correlateMessageAndCompleteTasks("Message", "afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventToSubProcessWithScopeUserTask() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).addMessageBoundaryEventWithUserTask("subProcess", "boundary", "Message", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionMigrated("boundary", "newBoundary", "Message");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventToSubProcessWithScopeUserTaskAndCorrelateMessage() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).addMessageBoundaryEventWithUserTask("subProcess", "boundary", "Message", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.correlateMessageAndCompleteTasks("Message", "afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventToParallelSubProcess() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).addMessageBoundaryEventWithUserTask("subProcess1", "boundary", "Message", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("boundary", "newBoundary").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess1")).up().up().child(null).concurrent().noScope().child("userTask2").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess2")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess1", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess1").getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).endScope().beginScope("subProcess2", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess2").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertEventSubscriptionMigrated("boundary", "newBoundary", "Message");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventToParallelSubProcessAndCorrelateMessage() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).addMessageBoundaryEventWithUserTask("subProcess1", "boundary", "Message", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("boundary", "newBoundary").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.correlateMessageAndCompleteTasks("Message", "afterBoundary", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventOnUserTask() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addSignalBoundaryEventWithUserTask("userTask", "boundary", "Signal", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionMigrated("boundary", "newBoundary", "Signal");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventOnUserTaskAndCorrelateSignal() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addSignalBoundaryEventWithUserTask("userTask", "boundary", "Signal", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.sendSignalAndCompleteTasks("Signal", "afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventOnUserTaskAndSendOldSignalName() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addSignalBoundaryEventWithUserTask("userTask", "boundary", "Signal", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addSignalBoundaryEventWithUserTask("userTask", "boundary", "newSignal", "afterBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.assertEventSubscriptionMigrated("boundary", "boundary", "Signal");
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().eventName("newSignal").singleResult();
        Assert.assertNull((Object)eventSubscription);
        this.sendSignalAndCompleteTasks("Signal", "afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventOnScopeUserTask() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).addSignalBoundaryEventWithUserTask("userTask", "boundary", "Signal", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionMigrated("boundary", "newBoundary", "Signal");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventOnScopeUserTaskAndCorrelateSignal() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).addSignalBoundaryEventWithUserTask("userTask", "boundary", "Signal", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.sendSignalAndCompleteTasks("Signal", "afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventOnConcurrentUserTask() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).addSignalBoundaryEventWithUserTask("userTask1", "boundary", "Signal", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().up().up().child("userTask2").concurrent().noScope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertEventSubscriptionMigrated("boundary", "newBoundary", "Signal");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventOnConcurrentUserTaskAndCorrelateSignal() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).addSignalBoundaryEventWithUserTask("userTask1", "boundary", "Signal", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.sendSignalAndCompleteTasks("Signal", "afterBoundary", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventOnConcurrentScopeUserTask() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).addSignalBoundaryEventWithUserTask("userTask1", "boundary", "Signal", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask1")).up().up().child(null).concurrent().noScope().child("userTask2").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask2")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertEventSubscriptionMigrated("boundary", "newBoundary", "Signal");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventOnConcurrentScopeUserTaskAndCorrelateSignal() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).addSignalBoundaryEventWithUserTask("userTask1", "boundary", "Signal", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.sendSignalAndCompleteTasks("Signal", "afterBoundary", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventToSubProcess() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSignalBoundaryEventWithUserTask("subProcess", "boundary", "Signal", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionMigrated("boundary", "newBoundary", "Signal");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventToSubProcessAndCorrelateSignal() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSignalBoundaryEventWithUserTask("subProcess", "boundary", "Signal", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.sendSignalAndCompleteTasks("Signal", "afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventToSubProcessWithScopeUserTask() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).addSignalBoundaryEventWithUserTask("subProcess", "boundary", "Signal", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionMigrated("boundary", "newBoundary", "Signal");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventToSubProcessWithScopeUserTaskAndCorrelateSignal() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).addSignalBoundaryEventWithUserTask("subProcess", "boundary", "Signal", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.sendSignalAndCompleteTasks("Signal", "afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventToParallelSubProcess() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).addSignalBoundaryEventWithUserTask("subProcess1", "boundary", "Signal", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("boundary", "newBoundary").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess1")).up().up().child(null).concurrent().noScope().child("userTask2").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess2")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess1", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess1").getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).endScope().beginScope("subProcess2", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess2").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertEventSubscriptionMigrated("boundary", "newBoundary", "Signal");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventToParallelSubProcessAndCorrelateSignal() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).addSignalBoundaryEventWithUserTask("subProcess1", "boundary", "Signal", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("boundary", "newBoundary").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.sendSignalAndCompleteTasks("Signal", "afterBoundary", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventOnUserTask() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addTimerDateBoundaryEventWithUserTask("userTask", "boundary", "2016-02-11T12:13:14Z", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertTimerJobMigrated("boundary", "newBoundary");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventOnUserTaskAndTriggerTimer() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addTimerDateBoundaryEventWithUserTask("userTask", "boundary", "2016-02-11T12:13:14Z", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.triggerTimerAndCompleteTasks("afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventOnUserTaskAndTriggerTimerWithOldDueDate() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addTimerDateBoundaryEventWithUserTask("userTask", "boundary", "2016-02-11T12:13:14Z", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addTimerDateBoundaryEventWithUserTask("userTask", "boundary", "2018-02-11T12:13:14Z", "afterBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.assertTimerJobMigrated("boundary", "boundary");
        this.triggerTimerAndCompleteTasks("afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventOnScopeUserTask() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).addTimerDateBoundaryEventWithUserTask("userTask", "boundary", "2016-02-11T12:13:14Z", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertTimerJobMigrated("boundary", "newBoundary");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventOnScopeUserTaskAndTriggerTimer() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).addTimerDateBoundaryEventWithUserTask("userTask", "boundary", "2016-02-11T12:13:14Z", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.triggerTimerAndCompleteTasks("afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventOnConcurrentUserTask() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).addTimerDateBoundaryEventWithUserTask("userTask1", "boundary", "2016-02-11T12:13:14Z", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().up().up().child("userTask2").concurrent().noScope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertTimerJobMigrated("boundary", "newBoundary");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventOnConcurrentUserTaskAndTriggerTimer() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).addTimerDateBoundaryEventWithUserTask("userTask1", "boundary", "2016-02-11T12:13:14Z", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.triggerTimerAndCompleteTasks("afterBoundary", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventOnConcurrentScopeUserTask() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).addTimerDateBoundaryEventWithUserTask("userTask1", "boundary", "2016-02-11T12:13:14Z", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask1")).up().up().child(null).concurrent().noScope().child("userTask2").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask2")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertTimerJobMigrated("boundary", "newBoundary");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventOnConcurrentScopeUserTaskAndTriggerTimer() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).addTimerDateBoundaryEventWithUserTask("userTask1", "boundary", "2016-02-11T12:13:14Z", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.triggerTimerAndCompleteTasks("afterBoundary", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventToSubProcess() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addTimerDateBoundaryEventWithUserTask("subProcess", "boundary", "2016-02-11T12:13:14Z", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertTimerJobMigrated("boundary", "newBoundary");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventToSubProcessAndTriggerTimer() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addTimerDateBoundaryEventWithUserTask("subProcess", "boundary", "2016-02-11T12:13:14Z", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.triggerTimerAndCompleteTasks("afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventToSubProcessWithScopeUserTask() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).addTimerDateBoundaryEventWithUserTask("subProcess", "boundary", "2016-02-11T12:13:14Z", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertTimerJobMigrated("boundary", "newBoundary");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventToSubProcessWithScopeUserTaskAndTriggerTimer() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).addTimerDateBoundaryEventWithUserTask("subProcess", "boundary", "2016-02-11T12:13:14Z", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.triggerTimerAndCompleteTasks("afterBoundary");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventToParallelSubProcess() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).addTimerDateBoundaryEventWithUserTask("subProcess1", "boundary", "2016-02-11T12:13:14Z", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("boundary", "newBoundary").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess1")).up().up().child(null).concurrent().noScope().child("userTask2").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess2")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess1", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess1").getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).endScope().beginScope("subProcess2", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess2").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertTimerJobMigrated("boundary", "newBoundary");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventToParallelSubProcessAndTriggerTimer() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).addTimerDateBoundaryEventWithUserTask("subProcess1", "boundary", "2016-02-11T12:13:14Z", "afterBoundary");
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("boundary", "newBoundary").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.triggerTimerAndCompleteTasks("afterBoundary", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMultipleBoundaryEvents() {
        ModifiableBpmnModelInstance testProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addTimerDateBoundaryEvent("subProcess", "timerBoundary1", "2016-02-11T12:13:14Z").addMessageBoundaryEvent("subProcess", "messageBoundary1", "Message").addSignalBoundaryEvent("subProcess", "signalBoundary1", "Signal").addTimerDateBoundaryEvent("userTask", "timerBoundary2", "2016-02-11T12:13:14Z").addMessageBoundaryEvent("userTask", "messageBoundary2", "Message").addSignalBoundaryEvent("userTask", "signalBoundary2", "Signal");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("timerBoundary1", "timerBoundary1").mapActivities("signalBoundary1", "signalBoundary1").mapActivities("userTask", "userTask").mapActivities("messageBoundary2", "messageBoundary2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionRemoved("messageBoundary1", "Message");
        this.assertEventSubscriptionRemoved("signalBoundary2", "Signal");
        this.assertEventSubscriptionMigrated("signalBoundary1", "signalBoundary1", "Signal");
        this.assertEventSubscriptionMigrated("messageBoundary2", "messageBoundary2", "Message");
        this.assertEventSubscriptionCreated("messageBoundary1", "Message");
        this.assertEventSubscriptionCreated("signalBoundary2", "Signal");
        this.assertTimerJobsRemoved("timerBoundary2");
        this.assertTimerJobMigrated("timerBoundary1", "timerBoundary1");
        this.assertTimerJobsCreated("timerBoundary2");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateBoundaryEventAndEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSignalBoundaryEvent("userTask", "boundary", "Signal").addSubProcessToParent("subProcess").triggerByEvent()).embeddedSubProcess().startEvent("eventStart").message("Message")).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("boundary", "boundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionRemoved("eventStart", "Message");
        this.assertEventSubscriptionMigrated("boundary", "boundary", "Signal");
        this.assertEventSubscriptionCreated("eventStart", "Message");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateIncidentForJob() {
        BpmnModelInstance sourceProcess = ((ServiceTaskBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).builderForUserTask("userTask").boundaryEvent("boundary").timerWithDate("2016-02-11T12:13:14Z")).serviceTask("failingTask").camundaClass(FailingDelegate.class.getName())).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("userTask", "newUserTask").changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        Job jobBeforeMigration = (Job)this.rule.getManagementService().createJobQuery().singleResult();
        Assert.assertNotNull((Object)jobBeforeMigration);
        this.executeJob(jobBeforeMigration);
        Incident incidentBeforeMigration = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertEquals((Object)"userTask", (Object)incidentBeforeMigration.getActivityId());
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "newUserTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Job jobAfterMigration = (Job)this.rule.getManagementService().createJobQuery().jobId(jobBeforeMigration.getId()).singleResult();
        Assert.assertNotNull((Object)jobAfterMigration);
        Incident incidentAfterMigration = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incidentAfterMigration);
        Assert.assertEquals((Object)incidentBeforeMigration.getId(), (Object)incidentAfterMigration.getId());
        Assert.assertEquals((Object)jobAfterMigration.getId(), (Object)incidentAfterMigration.getConfiguration());
        Assert.assertEquals((Object)"newUserTask", (Object)incidentAfterMigration.getActivityId());
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)incidentAfterMigration.getProcessDefinitionId());
    }

    protected void executeJob(Job job) {
        ManagementService managementService = this.rule.getManagementService();
        while (job != null && job.getRetries() > 0) {
            try {
                managementService.executeJob(job.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            job = (Job)managementService.createJobQuery().jobId(job.getId()).singleResult();
        }
    }
}

