/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.api.runtime.migration.AbstractMigrationTest;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.ProcessModels;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.junit.Test;

public class MigrationEventSubProcessTest
extends AbstractMigrationTest {
    public static final String IN_EVENT_SUB_PROCESS_TASK = "inEventSubProcessTask";

    @Test
    public void testMapUserTaskSiblingOfMessageEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessToParent("subProcess").triggerByEvent()).embeddedSubProcess().startEvent("eventStart").message("Message")).userTask(IN_EVENT_SUB_PROCESS_TASK).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionRemoved("eventStart", "Message");
        this.assertEventSubscriptionCreated("eventStart", "Message");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMapUserTaskSiblingOfMessageEventSubProcessAndTriggerMessage() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessToParent("subProcess").triggerByEvent()).embeddedSubProcess().startEvent("eventStart").message("Message")).userTask(IN_EVENT_SUB_PROCESS_TASK).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.correlateMessageAndCompleteTasks("Message", IN_EVENT_SUB_PROCESS_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMapUserTaskSiblingOfSignalEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessToParent("subProcess").triggerByEvent()).embeddedSubProcess().startEvent("eventStart").signal("Signal")).userTask(IN_EVENT_SUB_PROCESS_TASK).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionRemoved("eventStart", "Signal");
        this.assertEventSubscriptionCreated("eventStart", "Signal");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMapUserTaskSiblingOfSignalEventSubProcessAndSendSignal() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessToParent("subProcess").triggerByEvent()).embeddedSubProcess().startEvent("eventStart").signal("Signal")).userTask(IN_EVENT_SUB_PROCESS_TASK).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.sendSignalAndCompleteTasks("Signal", IN_EVENT_SUB_PROCESS_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMapUserTaskSiblingOfTimerEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessToParent("subProcess").triggerByEvent()).embeddedSubProcess().startEvent("eventStart").timerWithDate("2016-02-11T12:13:14Z")).userTask(IN_EVENT_SUB_PROCESS_TASK).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertTimerJobRemoved("eventStart");
        this.assertTimerJobCreated("eventStart");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMapUserTaskSiblingOfTimerEventSubProcessAndTriggerTimer() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessToParent("subProcess").triggerByEvent()).embeddedSubProcess().startEvent("eventStart").timerWithDate("2016-02-11T12:13:14Z")).userTask(IN_EVENT_SUB_PROCESS_TASK).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(testProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.triggerTimerAndCompleteTasks(IN_EVENT_SUB_PROCESS_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }
}

