/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import org.camunda.bpm.engine.migration.MigrationInstructionInstanceValidationException;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ProcessModels;
import org.camunda.bpm.engine.test.util.MigrationInstructionInstanceValidationReportAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationFlipScopesTest {
    protected ProcessEngineRule rule = new ProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testCannotFlipAncestorScopes() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ProcessModels.DOUBLE_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.DOUBLE_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("outerSubProcess", "innerSubProcess").mapActivities("innerSubProcess", "outerSubProcess").mapActivities("userTask", "userTask").build();
        try {
            this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
            Assert.fail((String)"should not validate");
        }
        catch (MigrationInstructionInstanceValidationException e) {
            MigrationInstructionInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasProcessInstanceId(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).hasFailure("innerSubProcess", "Closest migrating ancestor activity instance is migrated to activity 'innerSubProcess' which is not an ancestor of target activity 'outerSubProcess'");
        }
    }
}

