/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.AbstractMigrationTest;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.ProcessModels;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.Assert;
import org.junit.Test;

public class MigrationRemoveBoundaryEventsTest
extends AbstractMigrationTest {
    @Test
    public void testRemoveMessageBoundaryEventFromUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addMessageBoundaryEventWithUserTask("userTask", "boundary", "Message", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree("userTask").scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionRemoved("boundary", "Message");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveMessageBoundaryEventFromScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).addMessageBoundaryEventWithUserTask("userTask", "boundary", "Message", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.SCOPE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionRemoved("boundary", "Message");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveMessageBoundaryEventFromConcurrentUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).addMessageBoundaryEventWithUserTask("userTask1", "boundary", "Message", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask1").concurrent().noScope().up().child("userTask2").concurrent().noScope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertEventSubscriptionRemoved("boundary", "Message");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveMessageBoundaryEventFromConcurrentScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).addMessageBoundaryEventWithUserTask("userTask1", "boundary", "Message", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SCOPE_TASKS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask1")).up().up().child(null).concurrent().noScope().child("userTask2").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask2")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertEventSubscriptionRemoved("boundary", "Message");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveMessageBoundaryEventFromSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addMessageBoundaryEventWithUserTask("subProcess", "boundary", "Message", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionRemoved("boundary", "Message");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveMessageBoundaryEventFromSubProcessWithScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).addMessageBoundaryEventWithUserTask("subProcess", "boundary", "Message", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionRemoved("boundary", "Message");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveMessageBoundaryEventFromParallelSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).addMessageBoundaryEventWithUserTask("subProcess1", "boundary", "Message", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess1")).up().up().child(null).concurrent().noScope().child("userTask2").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess2")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess1", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess1").getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).endScope().beginScope("subProcess2", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess2").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertEventSubscriptionRemoved("boundary", "Message");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveMessageBoundaryEventFromUserTaskInSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addMessageBoundaryEventWithUserTask("userTask", "boundary", "Message", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionRemoved("boundary", "Message");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveSignalBoundaryEventFromUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addSignalBoundaryEventWithUserTask("userTask", "boundary", "Signal", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree("userTask").scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionRemoved("boundary", "Signal");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveSignalBoundaryEventFromScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).addSignalBoundaryEventWithUserTask("userTask", "boundary", "Signal", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.SCOPE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionRemoved("boundary", "Signal");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveSignalBoundaryEventFromConcurrentUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).addSignalBoundaryEventWithUserTask("userTask1", "boundary", "Signal", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask1").concurrent().noScope().up().child("userTask2").concurrent().noScope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertEventSubscriptionRemoved("boundary", "Signal");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveSignalBoundaryEventFromConcurrentScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).addSignalBoundaryEventWithUserTask("userTask1", "boundary", "Signal", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SCOPE_TASKS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask1")).up().up().child(null).concurrent().noScope().child("userTask2").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask2")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertEventSubscriptionRemoved("boundary", "Signal");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveSignalBoundaryEventFromSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSignalBoundaryEventWithUserTask("subProcess", "boundary", "Signal", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionRemoved("boundary", "Signal");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveSignalBoundaryEventFromSubProcessWithScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).addSignalBoundaryEventWithUserTask("subProcess", "boundary", "Signal", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionRemoved("boundary", "Signal");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveSignalBoundaryEventFromParallelSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).addSignalBoundaryEventWithUserTask("subProcess1", "boundary", "Signal", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess1")).up().up().child(null).concurrent().noScope().child("userTask2").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess2")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess1", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess1").getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).endScope().beginScope("subProcess2", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess2").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertEventSubscriptionRemoved("boundary", "Signal");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveSignalBoundaryEventFromUserTaskInSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSignalBoundaryEventWithUserTask("userTask", "boundary", "Signal", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionRemoved("boundary", "Signal");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveTimerBoundaryEventFromUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addTimerDateBoundaryEventWithUserTask("userTask", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree("userTask").scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertTimerJobRemoved("boundary");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveTimerBoundaryEventFromScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).addTimerDateBoundaryEventWithUserTask("userTask", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.SCOPE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertTimerJobRemoved("boundary");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveTimerBoundaryEventFromConcurrentUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).addTimerDateBoundaryEventWithUserTask("userTask1", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask1").concurrent().noScope().up().child("userTask2").concurrent().noScope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertTimerJobRemoved("boundary");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveTimerBoundaryEventFromConcurrentScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).addTimerDateBoundaryEventWithUserTask("userTask1", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SCOPE_TASKS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask1")).up().up().child(null).concurrent().noScope().child("userTask2").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask2")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertTimerJobRemoved("boundary");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveTimerBoundaryEventFromSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addTimerDateBoundaryEventWithUserTask("subProcess", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertTimerJobRemoved("boundary");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveTimerBoundaryEventFromSubProcessWithScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).addTimerDateBoundaryEventWithUserTask("subProcess", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertTimerJobRemoved("boundary");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveTimerBoundaryEventFromParallelSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).addTimerDateBoundaryEventWithUserTask("subProcess1", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.PARALLEL_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask1").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess1")).up().up().child(null).concurrent().noScope().child("userTask2").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess2")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess1", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess1").getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).endScope().beginScope("subProcess2", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess2").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        this.assertTimerJobRemoved("boundary");
        this.completeTasks("userTask1", "userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveTimerBoundaryEventFromUserTaskInSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addTimerDateBoundaryEventWithUserTask("userTask", "boundary", "2016-02-11T12:13:14Z", "afterBoundary"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertTimerJobRemoved("boundary");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveMultipleBoundaryEvents() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addTimerDateBoundaryEvent("subProcess", "timerBoundary", "2016-02-11T12:13:14Z").addMessageBoundaryEvent("userTask", "messageBoundary", "Message").addSignalBoundaryEvent("userTask", "signalBoundary", "Signal"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.assertEventSubscriptionRemoved("messageBoundary", "Message");
        this.assertEventSubscriptionRemoved("signalBoundary", "Signal");
        this.assertTimerJobRemoved("timerBoundary");
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveErrorBoundaryEventFromSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addErrorBoundaryEvent("subProcess", "Error"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveEscalationBoundaryEventFromSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addEscalationBoundaryEvent("subProcess", "Escalation"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(ProcessModels.SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.completeTasks("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateIncidentForJob() {
        BpmnModelInstance sourceProcess = ((ServiceTaskBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).builderForUserTask("userTask").boundaryEvent("boundary").timerWithDate("2016-02-11T12:13:14Z")).serviceTask("failingTask").camundaClass("org.camunda.bpm.engine.test.api.runtime.FailingDelegate")).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("userTask", "newUserTask").changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deploy(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deploy(targetProcess);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        Job jobBeforeMigration = (Job)this.rule.getManagementService().createJobQuery().singleResult();
        Assert.assertNotNull((Object)jobBeforeMigration);
        this.executeJob(jobBeforeMigration);
        Incident incidentBeforeMigration = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertEquals((Object)"userTask", (Object)incidentBeforeMigration.getActivityId());
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "newUserTask").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Job jobAfterMigration = (Job)this.rule.getManagementService().createJobQuery().jobId(jobBeforeMigration.getId()).singleResult();
        Assert.assertNull((Object)jobAfterMigration);
        Assert.assertEquals((long)0L, (long)this.rule.getRuntimeService().createIncidentQuery().count());
    }

    protected void executeJob(Job job) {
        ManagementService managementService = this.rule.getManagementService();
        while (job != null && job.getRetries() > 0) {
            try {
                managementService.executeJob(job.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            job = (Job)managementService.createJobQuery().jobId(job.getId()).singleResult();
        }
    }
}

