/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.Collections;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ProcessInstanceSnapshot;
import org.camunda.bpm.engine.test.api.runtime.migration.ProcessInstanceSnapshotBuilder;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class MigrationTestRule
extends TestWatcher {
    public static final String DEFAULT_BPMN_RESOURCE_NAME = "process.bpmn20.xml";
    protected ProcessEngineRule processEngineRule;
    protected ProcessEngine processEngine;
    public ProcessInstanceSnapshot snapshotBeforeMigration;
    public ProcessInstanceSnapshot snapshotAfterMigration;

    public MigrationTestRule(ProcessEngineRule processEngineRule) {
        this.processEngineRule = processEngineRule;
    }

    protected void starting(Description description) {
        this.processEngine = this.processEngineRule.getProcessEngine();
    }

    protected void finished(Description description) {
        this.processEngine = null;
    }

    public void assertProcessEnded(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance != null) {
            Assert.fail((String)("Process instance with id " + processInstanceId + " is not finished"));
        }
    }

    public ProcessDefinition findProcessDefinition(String key, int version) {
        return (ProcessDefinition)this.processEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(key).processDefinitionVersion(Integer.valueOf(version)).singleResult();
    }

    public ProcessDefinition deploy(String name, BpmnModelInstance bpmnModel) {
        Deployment deployment = this.processEngine.getRepositoryService().createDeployment().addModelInstance(name, bpmnModel).deploy();
        this.processEngineRule.manageDeployment(deployment);
        return (ProcessDefinition)this.processEngineRule.getRepositoryService().createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
    }

    public ProcessDefinition deploy(BpmnModelInstance bpmnModel) {
        return this.deploy(DEFAULT_BPMN_RESOURCE_NAME, bpmnModel);
    }

    public String getSingleExecutionIdForActivity(ActivityInstance activityInstance, String activityId) {
        ActivityInstance singleInstance = this.getSingleActivityInstance(activityInstance, activityId);
        String[] executionIds = singleInstance.getExecutionIds();
        if (executionIds.length == 1) {
            return executionIds[0];
        }
        throw new RuntimeException("There is more than one execution assigned to activity instance " + singleInstance.getId());
    }

    public String getSingleExecutionIdForActivityBeforeMigration(String activityId) {
        return this.getSingleExecutionIdForActivity(this.snapshotBeforeMigration.getActivityTree(), activityId);
    }

    public ActivityInstance getSingleActivityInstance(ActivityInstance tree, String activityId) {
        ActivityInstance[] activityInstances = tree.getActivityInstances(activityId);
        if (activityInstances.length == 1) {
            return activityInstances[0];
        }
        throw new RuntimeException("There is not exactly one activity instance for activity " + activityId);
    }

    public ActivityInstance getSingleActivityInstanceBeforeMigration(String activityId) {
        return this.getSingleActivityInstance(this.snapshotBeforeMigration.getActivityTree(), activityId);
    }

    public ProcessInstanceSnapshot takeFullProcessInstanceSnapshot(ProcessInstance processInstance) {
        return this.takeProcessInstanceSnapshot(processInstance).full();
    }

    public ProcessInstanceSnapshotBuilder takeProcessInstanceSnapshot(ProcessInstance processInstance) {
        return new ProcessInstanceSnapshotBuilder(processInstance, this.processEngine);
    }

    public ProcessInstance createProcessInstanceAndMigrate(MigrationPlan migrationPlan) {
        ProcessInstance processInstance = this.processEngine.getRuntimeService().startProcessInstanceById(migrationPlan.getSourceProcessDefinitionId());
        this.migrateProcessInstance(migrationPlan, processInstance);
        return processInstance;
    }

    public void migrateProcessInstance(MigrationPlan migrationPlan, ProcessInstance processInstance) {
        this.snapshotBeforeMigration = this.takeFullProcessInstanceSnapshot(processInstance);
        this.processEngine.getRuntimeService().executeMigrationPlan(migrationPlan, Collections.singletonList(this.snapshotBeforeMigration.getProcessInstanceId()));
        this.snapshotAfterMigration = this.takeFullProcessInstanceSnapshot(processInstance);
    }

    public ExecutionAssert assertExecutionTreeAfterMigration() {
        return ExecutionAssert.assertThat(this.snapshotAfterMigration.getExecutionTree());
    }

    public ActivityInstanceAssert.ActivityInstanceAssertThatClause assertActivityTreeAfterMigration() {
        return ActivityInstanceAssert.assertThat(this.snapshotAfterMigration.getActivityTree());
    }
}

