/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.Collection;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.AbstractActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.AbstractBaseElementBuilder;
import org.camunda.bpm.model.bpmn.builder.AbstractFlowNodeBuilder;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.camunda.bpm.model.bpmn.instance.Definitions;
import org.camunda.bpm.model.bpmn.instance.SubProcess;
import org.camunda.bpm.model.xml.Model;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;

public class ModifiableBpmnModelInstance
implements BpmnModelInstance {
    protected BpmnModelInstance modelInstance;

    public ModifiableBpmnModelInstance(BpmnModelInstance modelInstance) {
        this.modelInstance = modelInstance;
    }

    public static ModifiableBpmnModelInstance modify(BpmnModelInstance modelInstance) {
        return new ModifiableBpmnModelInstance(modelInstance.clone());
    }

    public Definitions getDefinitions() {
        return this.modelInstance.getDefinitions();
    }

    public void setDefinitions(Definitions definitions) {
        this.modelInstance.setDefinitions(definitions);
    }

    public BpmnModelInstance clone() {
        return this.modelInstance.clone();
    }

    public DomDocument getDocument() {
        return this.modelInstance.getDocument();
    }

    public ModelElementInstance getDocumentElement() {
        return this.modelInstance.getDocumentElement();
    }

    public void setDocumentElement(ModelElementInstance documentElement) {
        this.modelInstance.setDocumentElement(documentElement);
    }

    public <T extends ModelElementInstance> T newInstance(Class<T> type) {
        return (T)this.modelInstance.newInstance(type);
    }

    public <T extends ModelElementInstance> T newInstance(ModelElementType type) {
        return (T)this.modelInstance.newInstance(type);
    }

    public Model getModel() {
        return this.modelInstance.getModel();
    }

    public <T extends ModelElementInstance> T getModelElementById(String id) {
        return (T)this.modelInstance.getModelElementById(id);
    }

    public Collection<ModelElementInstance> getModelElementsByType(ModelElementType referencingType) {
        return this.modelInstance.getModelElementsByType(referencingType);
    }

    public <T extends ModelElementInstance> Collection<T> getModelElementsByType(Class<T> referencingClass) {
        return this.modelInstance.getModelElementsByType(referencingClass);
    }

    public <T extends AbstractBaseElementBuilder> T getBuilderForElementById(String id, Class<T> builderClass) {
        BaseElement modelElementById = (BaseElement)this.modelInstance.getModelElementById(id);
        return (T)modelElementById.builder();
    }

    public UserTaskBuilder builderForUserTask(String id) {
        return this.getBuilderForElementById(id, UserTaskBuilder.class);
    }

    public ModifiableBpmnModelInstance changeElementId(String oldId, String newId) {
        BaseElement element = (BaseElement)this.getModelElementById(oldId);
        element.setId(newId);
        return this;
    }

    public ModifiableBpmnModelInstance swapElementIds(String firstElementId, String secondElementId) {
        BaseElement firstElement = (BaseElement)this.getModelElementById(firstElementId);
        BaseElement secondElement = (BaseElement)this.getModelElementById(secondElementId);
        secondElement.setId("___TEMP___ID___");
        firstElement.setId(secondElementId);
        secondElement.setId(firstElementId);
        return this;
    }

    public ModifiableBpmnModelInstance addMessageBoundaryEvent(String activityId, String messageName) {
        return this.addMessageBoundaryEvent(activityId, null, messageName);
    }

    public ModifiableBpmnModelInstance addMessageBoundaryEvent(String activityId, String boundaryId, String messageName) {
        ((BoundaryEventBuilder)this.getBuilderForElementById(activityId, AbstractActivityBuilder.class).boundaryEvent(boundaryId).message(messageName)).endEvent();
        return this;
    }

    public ModifiableBpmnModelInstance addMessageBoundaryEventWithUserTask(String activityId, String messageName, String userTaskId) {
        return this.addMessageBoundaryEventWithUserTask(activityId, null, messageName, userTaskId);
    }

    public ModifiableBpmnModelInstance addMessageBoundaryEventWithUserTask(String activityId, String boundaryId, String messageName, String userTaskId) {
        ((BoundaryEventBuilder)this.getBuilderForElementById(activityId, AbstractActivityBuilder.class).boundaryEvent(boundaryId).message(messageName)).userTask(userTaskId).endEvent();
        return this;
    }

    public ModifiableBpmnModelInstance addSignalBoundaryEvent(String activityId, String signalName) {
        return this.addSignalBoundaryEvent(activityId, null, signalName);
    }

    public ModifiableBpmnModelInstance addSignalBoundaryEvent(String activityId, String boundaryId, String signalName) {
        ((BoundaryEventBuilder)this.getBuilderForElementById(activityId, AbstractActivityBuilder.class).boundaryEvent(boundaryId).signal(signalName)).endEvent();
        return this;
    }

    public ModifiableBpmnModelInstance addSignalBoundaryEventWithUserTask(String activityId, String signalName, String userTaskId) {
        return this.addSignalBoundaryEventWithUserTask(activityId, null, signalName, userTaskId);
    }

    public ModifiableBpmnModelInstance addSignalBoundaryEventWithUserTask(String activityId, String boundaryId, String signalName, String userTaskId) {
        ((BoundaryEventBuilder)this.getBuilderForElementById(activityId, AbstractActivityBuilder.class).boundaryEvent(boundaryId).signal(signalName)).userTask(userTaskId).endEvent();
        return this;
    }

    public ModifiableBpmnModelInstance addTimerDateBoundaryEvent(String activityId, String timerDate) {
        return this.addTimerDateBoundaryEvent(activityId, null, timerDate);
    }

    public ModifiableBpmnModelInstance addTimerDateBoundaryEvent(String activityId, String boundaryId, String timerDate) {
        ((BoundaryEventBuilder)this.getBuilderForElementById(activityId, AbstractActivityBuilder.class).boundaryEvent(boundaryId).timerWithDate(timerDate)).endEvent();
        return this;
    }

    public ModifiableBpmnModelInstance addTimerDateBoundaryEventWithUserTask(String activityId, String timerDate, String userTaskId) {
        return this.addTimerDateBoundaryEventWithUserTask(activityId, null, timerDate, userTaskId);
    }

    public ModifiableBpmnModelInstance addTimerDateBoundaryEventWithUserTask(String activityId, String boundaryId, String timerDate, String userTaskId) {
        ((BoundaryEventBuilder)this.getBuilderForElementById(activityId, AbstractActivityBuilder.class).boundaryEvent(boundaryId).timerWithDate(timerDate)).userTask(userTaskId).endEvent();
        return this;
    }

    public ModifiableBpmnModelInstance addTimerCycleBoundaryEvent(String activityId, String timerCycle) {
        return this.addTimerCycleBoundaryEvent(activityId, null, timerCycle);
    }

    public ModifiableBpmnModelInstance addTimerCycleBoundaryEvent(String activityId, String boundaryId, String timerCycle) {
        ((BoundaryEventBuilder)this.getBuilderForElementById(activityId, AbstractActivityBuilder.class).boundaryEvent(boundaryId).timerWithCycle(timerCycle)).endEvent();
        return this;
    }

    public ModifiableBpmnModelInstance addTimerCycleBoundaryEventWithUserTask(String activityId, String timerCycle, String userTaskId) {
        return this.addTimerCycleBoundaryEventWithUserTask(activityId, null, timerCycle, userTaskId);
    }

    public ModifiableBpmnModelInstance addTimerCycleBoundaryEventWithUserTask(String activityId, String boundaryId, String timerCycle, String userTaskId) {
        ((BoundaryEventBuilder)this.getBuilderForElementById(activityId, AbstractActivityBuilder.class).boundaryEvent(boundaryId).timerWithCycle(timerCycle)).userTask(userTaskId).endEvent();
        return this;
    }

    public ModifiableBpmnModelInstance addTimerDurationBoundaryEvent(String activityId, String timerDuration) {
        return this.addTimerDurationBoundaryEventWithUserTask(activityId, null, timerDuration);
    }

    public ModifiableBpmnModelInstance addTimerDurationBoundaryEvent(String activityId, String boundaryId, String timerDuration) {
        ((BoundaryEventBuilder)this.getBuilderForElementById(activityId, AbstractActivityBuilder.class).boundaryEvent(boundaryId).timerWithDuration(timerDuration)).endEvent();
        return this;
    }

    public ModifiableBpmnModelInstance addTimerDurationBoundaryEventWithUserTask(String activityId, String timerDuration, String userTaskId) {
        return this.addTimerDurationBoundaryEventWithUserTask(activityId, null, timerDuration, userTaskId);
    }

    public ModifiableBpmnModelInstance addTimerDurationBoundaryEventWithUserTask(String activityId, String boundaryId, String timerDuration, String userTaskId) {
        ((BoundaryEventBuilder)this.getBuilderForElementById(activityId, AbstractActivityBuilder.class).boundaryEvent(boundaryId).timerWithDuration(timerDuration)).userTask(userTaskId).endEvent();
        return this;
    }

    public ModifiableBpmnModelInstance addErrorBoundaryEvent(String activityId, String errorCode) {
        return this.addErrorBoundaryEvent(activityId, null, errorCode);
    }

    public ModifiableBpmnModelInstance addErrorBoundaryEvent(String activityId, String boundaryId, String errorCode) {
        ((BoundaryEventBuilder)this.getBuilderForElementById(activityId, AbstractActivityBuilder.class).boundaryEvent(boundaryId).error(errorCode)).endEvent();
        return this;
    }

    public ModifiableBpmnModelInstance addErrorBoundaryEventWithUserTask(String activityId, String errorCode, String userTaskId) {
        return this.addErrorBoundaryEventWithUserTask(activityId, null, errorCode, userTaskId);
    }

    public ModifiableBpmnModelInstance addErrorBoundaryEventWithUserTask(String activityId, String boundaryId, String errorCode, String userTaskId) {
        ((BoundaryEventBuilder)this.getBuilderForElementById(activityId, AbstractActivityBuilder.class).boundaryEvent(boundaryId).error(errorCode)).userTask(userTaskId).endEvent();
        return this;
    }

    public ModifiableBpmnModelInstance addEscalationBoundaryEvent(String activityId, String escalationCode) {
        return this.addEscalationBoundaryEvent(activityId, null, escalationCode);
    }

    public ModifiableBpmnModelInstance addEscalationBoundaryEvent(String activityId, String boundaryId, String escalationCode) {
        ((BoundaryEventBuilder)this.getBuilderForElementById(activityId, AbstractActivityBuilder.class).boundaryEvent(boundaryId).escalation(escalationCode)).endEvent();
        return this;
    }

    public ModifiableBpmnModelInstance addEscalationBoundaryEventWithUserTask(String activityId, String escalationCode, String userTaskId) {
        return this.addEscalationBoundaryEventWithUserTask(activityId, null, escalationCode, userTaskId);
    }

    public ModifiableBpmnModelInstance addEscalationBoundaryEventWithUserTask(String activityId, String boundaryId, String escalationCode, String userTaskId) {
        ((BoundaryEventBuilder)this.getBuilderForElementById(activityId, AbstractActivityBuilder.class).boundaryEvent(boundaryId).escalation(escalationCode)).userTask(userTaskId).endEvent();
        return this;
    }

    public ModifiableBpmnModelInstance addCamundaInputParameter(String activityId, String name, String value) {
        this.getBuilderForElementById(activityId, AbstractActivityBuilder.class).camundaInputParameter(name, value);
        return this;
    }

    public ModifiableBpmnModelInstance addCamundaOutputParameter(String activityId, String name, String value) {
        this.getBuilderForElementById(activityId, AbstractActivityBuilder.class).camundaOutputParameter(name, value);
        return this;
    }

    public ModifiableBpmnModelInstance addCamundaExecutionListenerClass(String activityId, String eventName, String className) {
        this.getBuilderForElementById(activityId, AbstractFlowNodeBuilder.class).camundaExecutionListenerClass(eventName, className);
        return this;
    }

    public SubProcessBuilder addSubProcessToParent(String parentId) {
        SubProcess eventSubProcess = (SubProcess)this.modelInstance.newInstance(SubProcess.class);
        BpmnModelElementInstance parent = (BpmnModelElementInstance)this.getModelElementById(parentId);
        parent.addChildElement((ModelElementInstance)eventSubProcess);
        return eventSubProcess.builder();
    }
}

