/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.util.ExecutionTree;

public class ProcessInstanceSnapshot {
    protected String processInstanceId;
    protected String processDefinitionId;
    protected ActivityInstance activityTree;
    protected ExecutionTree executionTree;
    protected List<EventSubscription> eventSubscriptions;
    protected List<Job> jobs;
    protected List<JobDefinition> jobDefinitions;
    protected List<Task> tasks;

    public ProcessInstanceSnapshot(String processInstanceId, String processDefinitionId) {
        this.processInstanceId = processInstanceId;
        this.processDefinitionId = processDefinitionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public ActivityInstance getActivityTree() {
        this.ensurePropertySaved("activity tree", this.activityTree);
        return this.activityTree;
    }

    public void setActivityTree(ActivityInstance activityTree) {
        this.activityTree = activityTree;
    }

    public ExecutionTree getExecutionTree() {
        this.ensurePropertySaved("execution tree", this.executionTree);
        return this.executionTree;
    }

    public void setExecutionTree(ExecutionTree executionTree) {
        this.executionTree = executionTree;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public List<Task> getTasks() {
        this.ensurePropertySaved("tasks", this.tasks);
        return this.tasks;
    }

    public Task getTaskForKey(String key) {
        for (Task task : this.getTasks()) {
            if (!key.equals(task.getTaskDefinitionKey())) continue;
            return task;
        }
        return null;
    }

    public List<EventSubscription> getEventSubscriptions() {
        this.ensurePropertySaved("event subscriptions", this.eventSubscriptions);
        return this.eventSubscriptions;
    }

    public EventSubscription getEventSubscriptionForActivityIdAndEventName(String activityId, String eventName) {
        for (EventSubscription eventSubscription : this.getEventSubscriptions()) {
            if (!activityId.equals(eventSubscription.getActivityId()) || !eventName.equals(eventSubscription.getEventName())) continue;
            return eventSubscription;
        }
        return null;
    }

    public void setEventSubscriptions(List<EventSubscription> eventSubscriptions) {
        this.eventSubscriptions = eventSubscriptions;
    }

    public List<Job> getJobs() {
        this.ensurePropertySaved("jobs", this.jobs);
        return this.jobs;
    }

    public Job getJobForDefinitionId(String jobDefinitionId) {
        for (Job job : this.getJobs()) {
            if (!jobDefinitionId.equals(job.getJobDefinitionId())) continue;
            return job;
        }
        return null;
    }

    public void setJobs(List<Job> jobs) {
        this.jobs = jobs;
    }

    public List<JobDefinition> getJobDefinitions() {
        this.ensurePropertySaved("job definitions", this.jobDefinitions);
        return this.jobDefinitions;
    }

    public JobDefinition getJobDefinitionForActivityId(String activityId) {
        for (JobDefinition jobDefinition : this.getJobDefinitions()) {
            if (!activityId.equals(jobDefinition.getActivityId())) continue;
            return jobDefinition;
        }
        return null;
    }

    public void setJobDefinitions(List<JobDefinition> jobDefinitions) {
        this.jobDefinitions = jobDefinitions;
    }

    protected void ensurePropertySaved(String name, Object property) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, (String)("The snapshot has not saved the " + name + " of the process instance"), (String)name, (Object)property);
    }
}

