/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.callactivity;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.cmmn.CaseDefinitionNotFoundException;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.IntegerValue;
import org.camunda.bpm.engine.variable.value.StringValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class CaseCallActivityTest
extends CmmnProcessEngineTestCase {
    protected final String PROCESS_DEFINITION_KEY = "process";
    protected final String ONE_TASK_CASE = "oneTaskCase";
    protected final String CALL_ACTIVITY_ID = "callActivity";
    protected final String USER_TASK_ID = "userTask";
    protected final String HUMAN_TASK_ID = "PI_HumanTask_1";

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testCallCaseAsConstant.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCallCaseAsConstant() {
        String superProcessInstanceId = this.startProcessInstanceByKey("process").getId();
        String callActivityId = this.queryExecutionByActivityId("callActivity").getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)subCaseInstance);
        CaseCallActivityTest.assertEquals((String)callActivityId, (String)subCaseInstance.getSuperExecutionId());
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        this.close(subCaseInstance.getId());
        this.assertProcessEnded(superProcessInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testCallCaseAsExpressionStartsWithDollar.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCallCaseAsExpressionStartsWithDollar() {
        String superProcessInstanceId = this.startProcessInstanceByKey("process", (Map<String, Object>)Variables.createVariables().putValue("oneTaskCase", (Object)"oneTaskCase")).getId();
        String callActivityId = this.queryExecutionByActivityId("callActivity").getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)subCaseInstance);
        CaseCallActivityTest.assertEquals((String)callActivityId, (String)subCaseInstance.getSuperExecutionId());
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        this.close(subCaseInstance.getId());
        this.assertProcessEnded(superProcessInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testCallCaseAsExpressionStartsWithHash.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCallCaseAsExpressionStartsWithHash() {
        String superProcessInstanceId = this.startProcessInstanceByKey("process", (Map<String, Object>)Variables.createVariables().putValue("oneTaskCase", (Object)"oneTaskCase")).getId();
        String callActivityId = this.queryExecutionByActivityId("callActivity").getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)subCaseInstance);
        CaseCallActivityTest.assertEquals((String)callActivityId, (String)subCaseInstance.getSuperExecutionId());
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        this.close(subCaseInstance.getId());
        this.assertProcessEnded(superProcessInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testCallLatestCase.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCallLatestCase() {
        String cmmnResourceName = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(cmmnResourceName).deploy().getId();
        CaseCallActivityTest.assertEquals((long)2L, (long)this.repositoryService.createCaseDefinitionQuery().count());
        String latestCaseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").latestVersion().singleResult()).getId();
        String superProcessInstanceId = this.startProcessInstanceByKey("process").getId();
        String callActivityId = this.queryExecutionByActivityId("callActivity").getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)subCaseInstance);
        CaseCallActivityTest.assertEquals((String)callActivityId, (String)subCaseInstance.getSuperExecutionId());
        CaseCallActivityTest.assertEquals((String)latestCaseDefinitionId, (String)subCaseInstance.getCaseDefinitionId());
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        this.close(subCaseInstance.getId());
        this.assertProcessEnded(superProcessInstanceId);
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testCallCaseByDeployment.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCallCaseByDeployment() {
        String firstDeploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        String cmmnResourceName = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(cmmnResourceName).deploy().getId();
        CaseCallActivityTest.assertEquals((long)2L, (long)this.repositoryService.createCaseDefinitionQuery().count());
        String caseDefinitionIdInSameDeployment = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").deploymentId(firstDeploymentId).singleResult()).getId();
        String superProcessInstanceId = this.startProcessInstanceByKey("process").getId();
        String callActivityId = this.queryExecutionByActivityId("callActivity").getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)subCaseInstance);
        CaseCallActivityTest.assertEquals((String)callActivityId, (String)subCaseInstance.getSuperExecutionId());
        CaseCallActivityTest.assertEquals((String)caseDefinitionIdInSameDeployment, (String)subCaseInstance.getCaseDefinitionId());
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        this.close(subCaseInstance.getId());
        this.assertProcessEnded(superProcessInstanceId);
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testCallCaseByVersion.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCallCaseByVersion() {
        String cmmnResourceName = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(cmmnResourceName).deploy().getId();
        String thirdDeploymentId = this.repositoryService.createDeployment().addClasspathResource(cmmnResourceName).deploy().getId();
        CaseCallActivityTest.assertEquals((long)3L, (long)this.repositoryService.createCaseDefinitionQuery().count());
        String caseDefinitionIdInSecondDeployment = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").deploymentId(secondDeploymentId).singleResult()).getId();
        String superProcessInstanceId = this.startProcessInstanceByKey("process").getId();
        String callActivityId = this.queryExecutionByActivityId("callActivity").getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)subCaseInstance);
        CaseCallActivityTest.assertEquals((String)callActivityId, (String)subCaseInstance.getSuperExecutionId());
        CaseCallActivityTest.assertEquals((String)caseDefinitionIdInSecondDeployment, (String)subCaseInstance.getCaseDefinitionId());
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        this.close(subCaseInstance.getId());
        this.assertProcessEnded(superProcessInstanceId);
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
        this.repositoryService.deleteDeployment(thirdDeploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testCallCaseByVersionAsExpression.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCallCaseByVersionAsExpression() {
        String cmmnResourceName = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(cmmnResourceName).deploy().getId();
        String thirdDeploymentId = this.repositoryService.createDeployment().addClasspathResource(cmmnResourceName).deploy().getId();
        CaseCallActivityTest.assertEquals((long)3L, (long)this.repositoryService.createCaseDefinitionQuery().count());
        String caseDefinitionIdInSecondDeployment = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").deploymentId(secondDeploymentId).singleResult()).getId();
        VariableMap variables = Variables.createVariables().putValue("myVersion", (Object)2);
        String superProcessInstanceId = this.startProcessInstanceByKey("process", (Map<String, Object>)variables).getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)subCaseInstance);
        CaseCallActivityTest.assertEquals((String)caseDefinitionIdInSecondDeployment, (String)subCaseInstance.getCaseDefinitionId());
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        this.close(subCaseInstance.getId());
        this.assertProcessEnded(superProcessInstanceId);
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
        this.repositoryService.deleteDeployment(thirdDeploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testCallCaseAsConstant.bpmn20.xml"})
    public void testCaseNotFound() {
        try {
            this.startProcessInstanceByKey("process");
            CaseCallActivityTest.fail((String)"It should not be possible to start a not existing case instance.");
        }
        catch (CaseDefinitionNotFoundException caseDefinitionNotFoundException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testInputBusinessKey.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testInputBusinessKey() {
        String businessKey = "myBusinessKey";
        String superProcessInstanceId = this.startProcessInstanceByKey("process", null, businessKey).getId();
        String callActivityId = this.queryExecutionByActivityId("callActivity").getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)subCaseInstance);
        CaseCallActivityTest.assertEquals((String)callActivityId, (String)subCaseInstance.getSuperExecutionId());
        CaseCallActivityTest.assertEquals((String)businessKey, (String)subCaseInstance.getBusinessKey());
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        this.close(subCaseInstance.getId());
        this.assertProcessEnded(superProcessInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testInputDifferentBusinessKey.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testInputDifferentBusinessKey() {
        String myBusinessKey = "myBusinessKey";
        String myOwnBusinessKey = "myOwnBusinessKey";
        VariableMap variables = Variables.createVariables().putValue(myOwnBusinessKey, (Object)myOwnBusinessKey);
        String superProcessInstanceId = this.startProcessInstanceByKey("process", (Map<String, Object>)variables, myBusinessKey).getId();
        String callActivityId = this.queryExecutionByActivityId("callActivity").getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)subCaseInstance);
        CaseCallActivityTest.assertEquals((String)callActivityId, (String)subCaseInstance.getSuperExecutionId());
        CaseCallActivityTest.assertEquals((String)myOwnBusinessKey, (String)subCaseInstance.getBusinessKey());
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        this.close(subCaseInstance.getId());
        this.assertProcessEnded(superProcessInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testInputSource.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testInputSource() {
        VariableMap parameters = Variables.createVariables().putValue("aVariable", (Object)"abc").putValue("anotherVariable", (Object)999).putValue("aThirdVariable", (Object)"def");
        String superProcessInstanceId = this.startProcessInstanceByKey("process", (Map<String, Object>)parameters).getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)subCaseInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{subCaseInstance.getId()}).list();
        CaseCallActivityTest.assertFalse((boolean)variables.isEmpty());
        CaseCallActivityTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"aVariable", (String)name);
                CaseCallActivityTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"anotherVariable", (String)name);
                CaseCallActivityTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseCallActivityTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        this.close(subCaseInstance.getId());
        this.assertProcessEnded(superProcessInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testInputSourceDifferentTarget.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testInputSourceDifferentTarget() {
        VariableMap parameters = Variables.createVariables().putValue("aVariable", (Object)"abc").putValue("anotherVariable", (Object)999).putValue("aThirdVariable", (Object)"def");
        String superProcessInstanceId = this.startProcessInstanceByKey("process", (Map<String, Object>)parameters).getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)subCaseInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{subCaseInstance.getId()}).list();
        CaseCallActivityTest.assertFalse((boolean)variables.isEmpty());
        CaseCallActivityTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("myVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"myVariable", (String)name);
                CaseCallActivityTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("myAnotherVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"myAnotherVariable", (String)name);
                CaseCallActivityTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseCallActivityTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        this.close(subCaseInstance.getId());
        this.assertProcessEnded(superProcessInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testInputSource.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testInputSourceNullValue() {
        String superProcessInstanceId = this.startProcessInstanceByKey("process").getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)subCaseInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{subCaseInstance.getId()}).list();
        CaseCallActivityTest.assertFalse((boolean)variables.isEmpty());
        CaseCallActivityTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"aVariable", (String)name);
            } else if ("anotherVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"anotherVariable", (String)name);
            } else {
                CaseCallActivityTest.fail((String)("Found an unexpected variable: '" + name + "'"));
            }
            CaseCallActivityTest.assertNull((Object)variable.getValue());
        }
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        this.close(subCaseInstance.getId());
        this.assertProcessEnded(superProcessInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testInputSourceExpression.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testInputSourceExpression() {
        VariableMap parameters = Variables.createVariables().putValue("aVariable", (Object)"abc").putValue("anotherVariable", (Object)999);
        String superProcessInstanceId = this.startProcessInstanceByKey("process", (Map<String, Object>)parameters).getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)subCaseInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{subCaseInstance.getId()}).list();
        CaseCallActivityTest.assertFalse((boolean)variables.isEmpty());
        CaseCallActivityTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"aVariable", (String)name);
                CaseCallActivityTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"anotherVariable", (String)name);
                CaseCallActivityTest.assertEquals((Object)1000L, (Object)variable.getValue());
                continue;
            }
            CaseCallActivityTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        this.close(subCaseInstance.getId());
        this.assertProcessEnded(superProcessInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testInputAll.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testInputAll() {
        VariableMap parameters = Variables.createVariables().putValue("aVariable", (Object)"abc").putValue("anotherVariable", (Object)999);
        String superProcessInstanceId = this.startProcessInstanceByKey("process", (Map<String, Object>)parameters).getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)subCaseInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{subCaseInstance.getId()}).list();
        CaseCallActivityTest.assertFalse((boolean)variables.isEmpty());
        CaseCallActivityTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"aVariable", (String)name);
                CaseCallActivityTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"anotherVariable", (String)name);
                CaseCallActivityTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseCallActivityTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        this.close(subCaseInstance.getId());
        this.assertProcessEnded(superProcessInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testCompleteCase.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCompleteCase() {
        String superProcessInstanceId = this.startProcessInstanceByKey("process").getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        Task userTask = this.queryTaskByActivityId("userTask");
        CaseCallActivityTest.assertNotNull((Object)userTask);
        Execution callActivity = this.queryExecutionByActivityId("callActivity");
        CaseCallActivityTest.assertNull((Object)callActivity);
        this.close(subCaseInstanceId);
        this.assertCaseEnded(subCaseInstanceId);
        this.taskService.complete(userTask.getId());
        this.assertCaseEnded(superProcessInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testOutputSource.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testOutputSource() {
        String superProcessInstanceId = this.startProcessInstanceByKey("process").getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.caseService.withCaseExecution(subCaseInstanceId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).setVariable("aThirdVariable", (Object)"def").execute();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        List variables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{superProcessInstanceId}).list();
        CaseCallActivityTest.assertFalse((boolean)variables.isEmpty());
        CaseCallActivityTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"aVariable", (String)name);
                CaseCallActivityTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"anotherVariable", (String)name);
                CaseCallActivityTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseCallActivityTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.close(subCaseInstanceId);
        this.assertCaseEnded(subCaseInstanceId);
        String taskId = this.queryTaskByActivityId("userTask").getId();
        this.taskService.complete(taskId);
        this.assertProcessEnded(superProcessInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testOutputSourceDifferentTarget.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testOutputSourceDifferentTarget() {
        String superProcessInstanceId = this.startProcessInstanceByKey("process").getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.caseService.withCaseExecution(subCaseInstanceId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).execute();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        List variables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{superProcessInstanceId}).list();
        CaseCallActivityTest.assertFalse((boolean)variables.isEmpty());
        CaseCallActivityTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("myVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"myVariable", (String)name);
                CaseCallActivityTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("myAnotherVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"myAnotherVariable", (String)name);
                CaseCallActivityTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseCallActivityTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.close(subCaseInstanceId);
        this.assertCaseEnded(subCaseInstanceId);
        String taskId = this.queryTaskByActivityId("userTask").getId();
        this.taskService.complete(taskId);
        this.assertProcessEnded(superProcessInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testOutputSource.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testOutputSourceNullValue() {
        String superProcessInstanceId = this.startProcessInstanceByKey("process").getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        List variables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{superProcessInstanceId}).list();
        CaseCallActivityTest.assertFalse((boolean)variables.isEmpty());
        CaseCallActivityTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"aVariable", (String)name);
            } else if ("anotherVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"anotherVariable", (String)name);
            } else {
                CaseCallActivityTest.fail((String)("Found an unexpected variable: '" + name + "'"));
            }
            CaseCallActivityTest.assertNull((Object)variable.getValue());
        }
        this.close(subCaseInstanceId);
        this.assertCaseEnded(subCaseInstanceId);
        String taskId = this.queryTaskByActivityId("userTask").getId();
        this.taskService.complete(taskId);
        this.assertProcessEnded(superProcessInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testOutputSourceExpression.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testOutputSourceExpression() {
        String superProcessInstanceId = this.startProcessInstanceByKey("process").getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.caseService.withCaseExecution(subCaseInstanceId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).execute();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        List variables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{superProcessInstanceId}).list();
        CaseCallActivityTest.assertFalse((boolean)variables.isEmpty());
        CaseCallActivityTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"aVariable", (String)name);
                CaseCallActivityTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"anotherVariable", (String)name);
                CaseCallActivityTest.assertEquals((Object)1000L, (Object)variable.getValue());
                continue;
            }
            CaseCallActivityTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.close(subCaseInstanceId);
        this.assertCaseEnded(subCaseInstanceId);
        String taskId = this.queryTaskByActivityId("userTask").getId();
        this.taskService.complete(taskId);
        this.assertProcessEnded(superProcessInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testOutputAll.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testOutputAll() {
        String superProcessInstanceId = this.startProcessInstanceByKey("process").getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.caseService.withCaseExecution(subCaseInstanceId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).execute();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        List variables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{superProcessInstanceId}).list();
        CaseCallActivityTest.assertFalse((boolean)variables.isEmpty());
        CaseCallActivityTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"aVariable", (String)name);
                CaseCallActivityTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"anotherVariable", (String)name);
                CaseCallActivityTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseCallActivityTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.close(subCaseInstanceId);
        this.assertCaseEnded(subCaseInstanceId);
        String taskId = this.queryTaskByActivityId("userTask").getId();
        this.taskService.complete(taskId);
        this.assertProcessEnded(superProcessInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testOutputAll.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testOutputVariablesShouldNotExistAnymore() {
        String superProcessInstanceId = this.startProcessInstanceByKey("process").getId();
        String callActivityId = this.queryExecutionByActivityId("callActivity").getId();
        VariableMap parameters = Variables.createVariables().putValue("aVariable", (Object)"xyz").putValue("anotherVariable", (Object)123);
        this.runtimeService.setVariablesLocal(callActivityId, (Map)parameters);
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.caseService.withCaseExecution(subCaseInstanceId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).execute();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        List variables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{superProcessInstanceId}).list();
        CaseCallActivityTest.assertTrue((boolean)variables.isEmpty());
        this.close(subCaseInstanceId);
        this.assertCaseEnded(subCaseInstanceId);
        String taskId = this.queryTaskByActivityId("userTask").getId();
        this.taskService.complete(taskId);
        this.assertProcessEnded(superProcessInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testVariablesRoundtrip.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testVariablesRoundtrip() {
        VariableMap parameters = Variables.createVariables().putValue("aVariable", (Object)"xyz").putValue("anotherVariable", (Object)999);
        String superProcessInstanceId = this.startProcessInstanceByKey("process", (Map<String, Object>)parameters).getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.caseService.withCaseExecution(subCaseInstanceId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)1000).execute();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        List variables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{superProcessInstanceId}).list();
        CaseCallActivityTest.assertFalse((boolean)variables.isEmpty());
        CaseCallActivityTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"aVariable", (String)name);
                CaseCallActivityTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                CaseCallActivityTest.assertEquals((String)"anotherVariable", (String)name);
                CaseCallActivityTest.assertEquals((Object)1000, (Object)variable.getValue());
                continue;
            }
            CaseCallActivityTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.close(subCaseInstanceId);
        this.assertCaseEnded(subCaseInstanceId);
        String taskId = this.queryTaskByActivityId("userTask").getId();
        this.taskService.complete(taskId);
        this.assertProcessEnded(superProcessInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testOutputAll.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCallCaseOutputAllVariablesTypedToProcess() {
        this.startProcessInstanceByKey("process");
        CaseInstance caseInstance = this.queryOneTaskCaseInstance();
        String variableName = "foo";
        String variableName2 = "null";
        StringValue variableValue = Variables.stringValue((String)"bar");
        IntegerValue variableValue2 = Variables.integerValue(null);
        this.caseService.withCaseExecution(caseInstance.getId()).setVariable(variableName, (Object)variableValue).setVariable(variableName2, (Object)variableValue2).execute();
        this.complete(caseInstance.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TypedValue value = this.runtimeService.getVariableTyped(task.getProcessInstanceId(), variableName);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)variableValue));
        value = this.runtimeService.getVariableTyped(task.getProcessInstanceId(), variableName2);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)variableValue2));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testCallCaseAsConstant.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testDeleteProcessInstance() {
        String superProcessInstanceId = this.startProcessInstanceByKey("process").getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.runtimeService.deleteProcessInstance(superProcessInstanceId, null);
        CaseCallActivityTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        CaseInstance subCaseInstance = this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)subCaseInstance);
        CaseCallActivityTest.assertTrue((boolean)subCaseInstance.isActive());
        this.terminate(subCaseInstanceId);
        this.close(subCaseInstanceId);
        this.assertCaseEnded(subCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testCallCaseAsConstant.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testSuspendProcessInstance() {
        String superProcessInstanceId = this.startProcessInstanceByKey("process").getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.runtimeService.suspendProcessInstanceById(superProcessInstanceId);
        Execution superProcessInstance = this.queryExecutionById(superProcessInstanceId);
        CaseCallActivityTest.assertNotNull((Object)superProcessInstance);
        CaseCallActivityTest.assertTrue((boolean)superProcessInstance.isSuspended());
        CaseInstance subCaseInstance = this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)subCaseInstance);
        CaseCallActivityTest.assertTrue((boolean)subCaseInstance.isActive());
        this.manualStart(humanTaskId);
        try {
            this.complete(humanTaskId);
            CaseCallActivityTest.fail((String)"The super process instance is suspended.");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.runtimeService.activateProcessInstanceById(superProcessInstanceId);
        this.complete(humanTaskId);
        this.close(subCaseInstance.getId());
        this.assertCaseEnded(subCaseInstanceId);
        this.assertProcessEnded(superProcessInstanceId);
        this.repositoryService.deleteDeployment(this.deploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testCallCaseAsConstant.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testTerminateSubCaseInstance() {
        String superProcessInstanceId = this.startProcessInstanceByKey("process").getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.terminate(subCaseInstanceId);
        CmmnExecution subCaseInstance = (CmmnExecution)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)subCaseInstance);
        CaseCallActivityTest.assertTrue((boolean)subCaseInstance.isTerminated());
        Execution callActivity = this.queryExecutionByActivityId("callActivity");
        CaseCallActivityTest.assertNotNull((Object)callActivity);
        this.close(subCaseInstanceId);
        this.assertCaseEnded(subCaseInstanceId);
        this.runtimeService.deleteProcessInstance(superProcessInstanceId, null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testCallCaseAsConstant.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testSuspendSubCaseInstance() {
        String superProcessInstanceId = this.startProcessInstanceByKey("process").getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.suspend(subCaseInstanceId);
        CmmnExecution subCaseInstance = (CmmnExecution)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)subCaseInstance);
        CaseCallActivityTest.assertTrue((boolean)subCaseInstance.isSuspended());
        Execution callActivity = this.queryExecutionByActivityId("callActivity");
        CaseCallActivityTest.assertNotNull((Object)callActivity);
        this.close(subCaseInstanceId);
        this.assertCaseEnded(subCaseInstanceId);
        this.runtimeService.deleteProcessInstance(superProcessInstanceId, null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivityTest.testCompletionOfCaseWithTwoTasks.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testCompletionOfTwoHumanTasks() {
        String superProcessInstanceId = this.startProcessInstanceByKey("process").getId();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        CaseCallActivityTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
        humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_2").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseCallActivityTest.assertNotNull((Object)task);
        CaseCallActivityTest.assertEquals((String)superProcessInstanceId, (String)task.getProcessInstanceId());
        CaseCallActivityTest.assertEquals((String)"userTask", (String)task.getTaskDefinitionKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivity.testSubProcessLocalInputAllVariables.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testSubProcessLocalInputAllVariables() {
        ProcessInstance processInstance = this.startProcessInstanceByKey("subProcessLocalInputAllVariables");
        Task beforeCallActivityTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.setVariable(processInstance.getId(), "callingProcessVar1", (Object)"val1");
        this.taskService.complete(beforeCallActivityTask.getId());
        CaseExecutionEntity calledInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)calledInstance);
        Map calledInstanceVariables = this.caseService.getVariables(calledInstance.getId());
        CaseCallActivityTest.assertEquals((int)1, (int)calledInstanceVariables.size());
        CaseCallActivityTest.assertEquals((Object)"val2", calledInstanceVariables.get("inputParameter"));
        this.caseService.setVariable(calledInstance.getId(), "calledCaseVar1", (Object)42L);
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        Map callingInstanceVariables = this.runtimeService.getVariables(processInstance.getId());
        CaseCallActivityTest.assertEquals((int)3, (int)callingInstanceVariables.size());
        CaseCallActivityTest.assertEquals((Object)"val1", callingInstanceVariables.get("callingProcessVar1"));
        CaseCallActivityTest.assertEquals((Object)42L, callingInstanceVariables.get("calledCaseVar1"));
        CaseCallActivityTest.assertEquals((Object)43L, callingInstanceVariables.get("outputParameter"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivity.testSubProcessLocalInputSingleVariable.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testSubProcessLocalInputSingleVariable() {
        ProcessInstance processInstance = this.startProcessInstanceByKey("subProcessLocalInputSingleVariable");
        Task beforeCallActivityTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.setVariable(processInstance.getId(), "callingProcessVar1", (Object)"val1");
        this.taskService.complete(beforeCallActivityTask.getId());
        CaseExecutionEntity calledInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)calledInstance);
        Map calledInstanceVariables = this.caseService.getVariables(calledInstance.getId());
        CaseCallActivityTest.assertEquals((int)1, (int)calledInstanceVariables.size());
        CaseCallActivityTest.assertEquals((Object)"val2", calledInstanceVariables.get("mappedInputParameter"));
        this.caseService.setVariable(calledInstance.getId(), "calledCaseVar1", (Object)42L);
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        Map callingInstanceVariables = this.runtimeService.getVariables(processInstance.getId());
        CaseCallActivityTest.assertEquals((int)4, (int)callingInstanceVariables.size());
        CaseCallActivityTest.assertEquals((Object)"val1", callingInstanceVariables.get("callingProcessVar1"));
        CaseCallActivityTest.assertEquals((Object)"val2", callingInstanceVariables.get("mappedInputParameter"));
        CaseCallActivityTest.assertEquals((Object)42L, callingInstanceVariables.get("calledCaseVar1"));
        CaseCallActivityTest.assertEquals((Object)43L, callingInstanceVariables.get("outputParameter"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivity.testSubProcessLocalInputSingleVariableExpression.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testSubProcessLocalInputSingleVariableExpression() {
        ProcessInstance processInstance = this.startProcessInstanceByKey("subProcessLocalInputSingleVariableExpression");
        Task beforeCallActivityTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCallActivityTask.getId());
        CaseExecutionEntity calledInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)calledInstance);
        Map calledInstanceVariables = this.caseService.getVariables(calledInstance.getId());
        CaseCallActivityTest.assertEquals((int)1, (int)calledInstanceVariables.size());
        CaseCallActivityTest.assertEquals((Object)43L, calledInstanceVariables.get("mappedInputParameter"));
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        Task beforeSecondCallActivityTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.setVariable(processInstance.getId(), "globalVariable", (Object)"42");
        try {
            this.taskService.complete(beforeSecondCallActivityTask.getId());
            CaseCallActivityTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot resolve identifier 'globalVariable'", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivity.testSubProcessLocalOutputAllVariables.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testSubProcessLocalOutputAllVariables() {
        ProcessInstance processInstance = this.startProcessInstanceByKey("subProcessLocalOutputAllVariables");
        Task beforeCallActivityTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.setVariable(processInstance.getId(), "callingProcessVar1", (Object)"val1");
        this.taskService.complete(beforeCallActivityTask.getId());
        CaseExecutionEntity calledInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)calledInstance);
        Map calledInstanceVariables = this.caseService.getVariables(calledInstance.getId());
        CaseCallActivityTest.assertEquals((int)2, (int)calledInstanceVariables.size());
        CaseCallActivityTest.assertEquals((Object)"val1", calledInstanceVariables.get("callingProcessVar1"));
        CaseCallActivityTest.assertEquals((Object)"val2", calledInstanceVariables.get("inputParameter"));
        this.caseService.setVariable(calledInstance.getId(), "calledCaseVar1", (Object)42L);
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        Map callingInstanceVariables = this.runtimeService.getVariables(processInstance.getId());
        CaseCallActivityTest.assertEquals((int)2, (int)callingInstanceVariables.size());
        CaseCallActivityTest.assertEquals((Object)"val1", callingInstanceVariables.get("callingProcessVar1"));
        CaseCallActivityTest.assertEquals((Object)43L, callingInstanceVariables.get("outputParameter"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CaseCallActivity.testSubProcessLocalOutputSingleVariable.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testSubProcessLocalOutputSingleVariable() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessLocalOutputSingleVariable");
        Task beforeCallActivityTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.setVariable(processInstance.getId(), "callingProcessVar1", (Object)"val1");
        this.taskService.complete(beforeCallActivityTask.getId());
        CaseExecutionEntity calledInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseCallActivityTest.assertNotNull((Object)calledInstance);
        Map calledInstanceVariables = this.caseService.getVariables(calledInstance.getId());
        CaseCallActivityTest.assertEquals((int)2, (int)calledInstanceVariables.size());
        CaseCallActivityTest.assertEquals((Object)"val1", calledInstanceVariables.get("callingProcessVar1"));
        CaseCallActivityTest.assertEquals((Object)"val2", calledInstanceVariables.get("inputParameter"));
        this.caseService.setVariable(calledInstance.getId(), "calledCaseVar1", (Object)42L);
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTaskId);
        this.complete(humanTaskId);
        Map callingInstanceVariables = this.runtimeService.getVariables(processInstance.getId());
        CaseCallActivityTest.assertEquals((int)2, (int)callingInstanceVariables.size());
        CaseCallActivityTest.assertEquals((Object)"val1", callingInstanceVariables.get("callingProcessVar1"));
        CaseCallActivityTest.assertEquals((Object)43L, callingInstanceVariables.get("outputParameter"));
    }

    protected ProcessInstance startProcessInstanceByKey(String processDefinitionKey) {
        return this.startProcessInstanceByKey(processDefinitionKey, null);
    }

    protected ProcessInstance startProcessInstanceByKey(String processDefinitionKey, Map<String, Object> variables) {
        return this.startProcessInstanceByKey(processDefinitionKey, variables, null);
    }

    protected ProcessInstance startProcessInstanceByKey(String processDefinitionKey, Map<String, Object> variables, String businessKey) {
        return this.runtimeService.startProcessInstanceByKey(processDefinitionKey, businessKey, variables);
    }

    protected CaseExecution queryCaseExecutionById(String id) {
        return (CaseExecution)this.caseService.createCaseExecutionQuery().caseExecutionId(id).singleResult();
    }

    protected CaseExecution queryCaseExecutionByActivityId(String activityId) {
        return (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(activityId).singleResult();
    }

    protected CaseInstance queryOneTaskCaseInstance() {
        return (CaseInstance)this.caseService.createCaseInstanceQuery().caseDefinitionKey("oneTaskCase").singleResult();
    }

    protected Execution queryExecutionById(String id) {
        return (Execution)this.runtimeService.createExecutionQuery().executionId(id).singleResult();
    }

    protected Execution queryExecutionByActivityId(String activityId) {
        return (Execution)this.runtimeService.createExecutionQuery().activityId(activityId).singleResult();
    }

    protected Task queryTaskByActivityId(String activityId) {
        return (Task)this.taskService.createTaskQuery().taskDefinitionKey(activityId).singleResult();
    }
}

