/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.executionlistener;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.executionlistener.CurrentActivityExecutionListener;
import org.camunda.bpm.engine.test.bpmn.executionlistener.ExampleExecutionListenerPojo;
import org.camunda.bpm.engine.test.bpmn.executionlistener.RecorderExecutionListener;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;

public class ExecutionListenerTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenersProcess.bpmn20.xml"})
    public void testExecutionListenersOnAllPossibleElements() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("executionListenersProcess", "businessKey123");
        String varSetInExecutionListener = (String)this.runtimeService.getVariable(processInstance.getId(), "variableSetInExecutionListener");
        ExecutionListenerTest.assertNotNull((Object)varSetInExecutionListener);
        ExecutionListenerTest.assertEquals((String)"firstValue", (String)varSetInExecutionListener);
        String businessKey = (String)this.runtimeService.getVariable(processInstance.getId(), "businessKeyInExecution");
        ExecutionListenerTest.assertNotNull((Object)businessKey);
        ExecutionListenerTest.assertEquals((String)"businessKey123", (String)businessKey);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        ExecutionListenerTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        varSetInExecutionListener = (String)this.runtimeService.getVariable(processInstance.getId(), "variableSetInExecutionListener");
        ExecutionListenerTest.assertNotNull((Object)varSetInExecutionListener);
        ExecutionListenerTest.assertEquals((String)"secondValue", (String)varSetInExecutionListener);
        ExampleExecutionListenerPojo myPojo = new ExampleExecutionListenerPojo();
        this.runtimeService.setVariable(processInstance.getId(), "myPojo", (Object)myPojo);
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        ExecutionListenerTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        ExampleExecutionListenerPojo pojoVariable = (ExampleExecutionListenerPojo)this.runtimeService.getVariable(processInstance.getId(), "myPojo");
        ExecutionListenerTest.assertNotNull((Object)pojoVariable.getReceivedEventName());
        ExecutionListenerTest.assertEquals((String)"end", (String)pojoVariable.getReceivedEventName());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        ExecutionListenerTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenersStartEndEvent.bpmn20.xml"})
    public void testExecutionListenersOnStartEndEvents() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("executionListenersProcess");
        this.assertProcessEnded(processInstance.getId());
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        ExecutionListenerTest.assertEquals((int)4, (int)recordedEvents.size());
        ExecutionListenerTest.assertEquals((String)"theStart", (String)recordedEvents.get(0).getActivityId());
        ExecutionListenerTest.assertEquals((String)"Start Event", (String)recordedEvents.get(0).getActivityName());
        ExecutionListenerTest.assertEquals((String)"Start Event Listener", (String)recordedEvents.get(0).getParameter());
        ExecutionListenerTest.assertEquals((String)"end", (String)recordedEvents.get(0).getEventName());
        Assert.assertThat((Object)recordedEvents.get(0).isCanceled(), (Matcher)CoreMatchers.is((Object)false));
        ExecutionListenerTest.assertEquals((String)"noneEvent", (String)recordedEvents.get(1).getActivityId());
        ExecutionListenerTest.assertEquals((String)"None Event", (String)recordedEvents.get(1).getActivityName());
        ExecutionListenerTest.assertEquals((String)"Intermediate Catch Event Listener", (String)recordedEvents.get(1).getParameter());
        ExecutionListenerTest.assertEquals((String)"end", (String)recordedEvents.get(1).getEventName());
        Assert.assertThat((Object)recordedEvents.get(1).isCanceled(), (Matcher)CoreMatchers.is((Object)false));
        ExecutionListenerTest.assertEquals((String)"signalEvent", (String)recordedEvents.get(2).getActivityId());
        ExecutionListenerTest.assertEquals((String)"Signal Event", (String)recordedEvents.get(2).getActivityName());
        ExecutionListenerTest.assertEquals((String)"Intermediate Throw Event Listener", (String)recordedEvents.get(2).getParameter());
        ExecutionListenerTest.assertEquals((String)"start", (String)recordedEvents.get(2).getEventName());
        Assert.assertThat((Object)recordedEvents.get(2).isCanceled(), (Matcher)CoreMatchers.is((Object)false));
        ExecutionListenerTest.assertEquals((String)"theEnd", (String)recordedEvents.get(3).getActivityId());
        ExecutionListenerTest.assertEquals((String)"End Event", (String)recordedEvents.get(3).getActivityName());
        ExecutionListenerTest.assertEquals((String)"End Event Listener", (String)recordedEvents.get(3).getParameter());
        ExecutionListenerTest.assertEquals((String)"start", (String)recordedEvents.get(3).getEventName());
        Assert.assertThat((Object)recordedEvents.get(3).isCanceled(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenersFieldInjectionProcess.bpmn20.xml"})
    public void testExecutionListenerFieldInjection() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("myVar", "listening!");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("executionListenersProcess", variables);
        Object varSetByListener = this.runtimeService.getVariable(processInstance.getId(), "var");
        ExecutionListenerTest.assertNotNull((Object)varSetByListener);
        ExecutionListenerTest.assertTrue((boolean)(varSetByListener instanceof String));
        ExecutionListenerTest.assertEquals((Object)"Yes, I am listening!", (Object)varSetByListener);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenersCurrentActivity.bpmn20.xml"})
    public void testExecutionListenerCurrentActivity() {
        CurrentActivityExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("executionListenersProcess");
        this.assertProcessEnded(processInstance.getId());
        List<CurrentActivityExecutionListener.CurrentActivity> currentActivities = CurrentActivityExecutionListener.getCurrentActivities();
        ExecutionListenerTest.assertEquals((int)3, (int)currentActivities.size());
        ExecutionListenerTest.assertEquals((String)"theStart", (String)currentActivities.get(0).getActivityId());
        ExecutionListenerTest.assertEquals((String)"Start Event", (String)currentActivities.get(0).getActivityName());
        ExecutionListenerTest.assertEquals((String)"noneEvent", (String)currentActivities.get(1).getActivityId());
        ExecutionListenerTest.assertEquals((String)"None Event", (String)currentActivities.get(1).getActivityName());
        ExecutionListenerTest.assertEquals((String)"theEnd", (String)currentActivities.get(2).getActivityId());
        ExecutionListenerTest.assertEquals((String)"End Event", (String)currentActivities.get(2).getActivityName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenerTest.testOnBoundaryEvents.bpmn20.xml"})
    public void testOnBoundaryEvents() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Job firstTimer = (Job)this.managementService.createJobQuery().timers().singleResult();
        this.managementService.executeJob(firstTimer.getId());
        Job secondTimer = (Job)this.managementService.createJobQuery().timers().singleResult();
        this.managementService.executeJob(secondTimer.getId());
        this.assertProcessEnded(processInstance.getId());
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        ExecutionListenerTest.assertEquals((int)2, (int)recordedEvents.size());
        ExecutionListenerTest.assertEquals((String)"timer1", (String)recordedEvents.get(0).getActivityId());
        ExecutionListenerTest.assertEquals((String)"start boundary listener", (String)recordedEvents.get(0).getParameter());
        ExecutionListenerTest.assertEquals((String)"start", (String)recordedEvents.get(0).getEventName());
        Assert.assertThat((Object)recordedEvents.get(0).isCanceled(), (Matcher)CoreMatchers.is((Object)false));
        ExecutionListenerTest.assertEquals((String)"timer2", (String)recordedEvents.get(1).getActivityId());
        ExecutionListenerTest.assertEquals((String)"end boundary listener", (String)recordedEvents.get(1).getParameter());
        ExecutionListenerTest.assertEquals((String)"end", (String)recordedEvents.get(1).getEventName());
        Assert.assertThat((Object)recordedEvents.get(1).isCanceled(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Deployment
    public void testScriptListener() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ExecutionListenerTest.assertTrue((boolean)processInstance.isEnded());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            String[] variableNames;
            HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
            long count = query.count();
            ExecutionListenerTest.assertEquals((long)5L, (long)count);
            HistoricVariableInstance variableInstance = null;
            for (String variableName : variableNames = new String[]{"start-start", "start-end", "start-take", "end-start", "end-end"}) {
                variableInstance = (HistoricVariableInstance)query.variableName(variableName).singleResult();
                ExecutionListenerTest.assertNotNull((String)("Unable ot find variable with name '" + variableName + "'"), (Object)variableInstance);
                ExecutionListenerTest.assertTrue((String)("Variable '" + variableName + "' should be set to true"), (boolean)((Boolean)variableInstance.getValue()));
            }
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenerTest.testScriptResourceListener.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/executionlistener/executionListener.groovy"})
    public void testScriptResourceListener() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ExecutionListenerTest.assertTrue((boolean)processInstance.isEnded());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            String[] variableNames;
            HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
            long count = query.count();
            ExecutionListenerTest.assertEquals((long)5L, (long)count);
            HistoricVariableInstance variableInstance = null;
            for (String variableName : variableNames = new String[]{"start-start", "start-end", "start-take", "end-start", "end-end"}) {
                variableInstance = (HistoricVariableInstance)query.variableName(variableName).singleResult();
                ExecutionListenerTest.assertNotNull((String)("Unable ot find variable with name '" + variableName + "'"), (Object)variableInstance);
                ExecutionListenerTest.assertTrue((String)("Variable '" + variableName + "' should be set to true"), (boolean)((Boolean)variableInstance.getValue()));
            }
        }
    }

    @Deployment
    public void testExecutionListenerOnTerminateEndEvent() {
        RecorderExecutionListener.clear();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        ExecutionListenerTest.assertEquals((int)2, (int)recordedEvents.size());
        ExecutionListenerTest.assertEquals((String)"start", (String)recordedEvents.get(0).getEventName());
        ExecutionListenerTest.assertEquals((String)"end", (String)recordedEvents.get(1).getEventName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenerTest.testOnCancellingBoundaryEvent.bpmn"})
    public void testOnCancellingBoundaryEvents() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Job timer = (Job)this.managementService.createJobQuery().timers().singleResult();
        this.managementService.executeJob(timer.getId());
        this.assertProcessEnded(processInstance.getId());
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        Assert.assertThat(recordedEvents, (Matcher)IsCollectionWithSize.hasSize((int)1));
        ExecutionListenerTest.assertEquals((String)"UserTask_1", (String)recordedEvents.get(0).getActivityId());
        ExecutionListenerTest.assertEquals((String)"end", (String)recordedEvents.get(0).getEventName());
        Assert.assertThat((Object)recordedEvents.get(0).isCanceled(), (Matcher)CoreMatchers.is((Object)true));
    }
}

