/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.gateway;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.gateway.InclusiveGatewayTestOrder;

public class InclusiveGatewayTest
extends PluggableProcessEngineTestCase {
    private static final String TASK1_NAME = "Task 1";
    private static final String TASK2_NAME = "Task 2";
    private static final String TASK3_NAME = "Task 3";
    private static final String BEAN_TASK1_NAME = "Basic service";
    private static final String BEAN_TASK2_NAME = "Standard service";
    private static final String BEAN_TASK3_NAME = "Gold Member service";

    @Deployment
    public void testDivergingInclusiveGateway() {
        for (int i = 1; i <= 3; ++i) {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("inclusiveGwDiverging", CollectionUtil.singletonMap((String)"input", (Object)i));
            List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
            ArrayList<String> expectedNames = new ArrayList<String>();
            if (i == 1) {
                expectedNames.add(TASK1_NAME);
            }
            if (i <= 2) {
                expectedNames.add(TASK2_NAME);
            }
            expectedNames.add(TASK3_NAME);
            for (Task task : tasks) {
                System.out.println("task " + task.getName());
            }
            InclusiveGatewayTest.assertEquals((int)(4 - i), (int)tasks.size());
            for (Task task : tasks) {
                expectedNames.remove(task.getName());
            }
            InclusiveGatewayTest.assertEquals((int)0, (int)expectedNames.size());
            this.runtimeService.deleteProcessInstance(pi.getId(), "testing deletion");
        }
    }

    @Deployment
    public void testMergingInclusiveGateway() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("inclusiveGwMerging", CollectionUtil.singletonMap((String)"input", (Object)2));
        InclusiveGatewayTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        this.runtimeService.deleteProcessInstance(pi.getId(), "testing deletion");
    }

    @Deployment
    public void testMergingInclusiveGatewayAsync() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("inclusiveGwMerging", CollectionUtil.singletonMap((String)"input", (Object)2));
        List list = this.managementService.createJobQuery().list();
        for (Job job : list) {
            this.managementService.executeJob(job.getId());
        }
        InclusiveGatewayTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        this.runtimeService.deleteProcessInstance(pi.getId(), "testing deletion");
    }

    @Deployment
    public void testPartialMergingInclusiveGateway() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("partialInclusiveGwMerging", CollectionUtil.singletonMap((String)"input", (Object)2));
        Task partialTask = (Task)this.taskService.createTaskQuery().singleResult();
        InclusiveGatewayTest.assertEquals((String)"partialTask", (String)partialTask.getTaskDefinitionKey());
        this.taskService.complete(partialTask.getId());
        Task fullTask = (Task)this.taskService.createTaskQuery().singleResult();
        InclusiveGatewayTest.assertEquals((String)"theTask", (String)fullTask.getTaskDefinitionKey());
        this.runtimeService.deleteProcessInstance(pi.getId(), "testing deletion");
    }

    @Deployment
    public void testNoSequenceFlowSelected() {
        try {
            this.runtimeService.startProcessInstanceByKey("inclusiveGwNoSeqFlowSelected", CollectionUtil.singletonMap((String)"input", (Object)4));
            InclusiveGatewayTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("ENGINE-02004 No outgoing sequence flow for the element with id 'inclusiveGw' could be selected for continuing the process.", e.getMessage());
        }
    }

    @Deployment
    public void testParentActivationOnNonJoiningEnd() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parentActivationOnNonJoiningEnd");
        List executionsBefore = this.runtimeService.createExecutionQuery().list();
        InclusiveGatewayTest.assertEquals((int)3, (int)executionsBefore.size());
        List firstTasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        InclusiveGatewayTest.assertEquals((int)2, (int)firstTasks.size());
        for (Task t : firstTasks) {
            this.taskService.complete(t.getId());
        }
        List secondTasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        InclusiveGatewayTest.assertEquals((int)2, (int)secondTasks.size());
        Task task = (Task)secondTasks.get(0);
        this.taskService.complete(task.getId());
        List executionsAfter = this.runtimeService.createExecutionQuery().list();
        InclusiveGatewayTest.assertEquals((int)1, (int)executionsAfter.size());
        Execution execution = (Execution)executionsAfter.get(0);
        List activeActivityIds = this.runtimeService.getActiveActivityIds(execution.getId());
        InclusiveGatewayTest.assertEquals((int)1, (int)activeActivityIds.size());
        Task lastTask = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.complete(lastTask.getId());
        InclusiveGatewayTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
    }

    @Deployment
    public void testWhitespaceInExpression() {
        this.runtimeService.startProcessInstanceByKey("inclusiveWhiteSpaceInExpression", CollectionUtil.singletonMap((String)"input", (Object)1));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/gateway/InclusiveGatewayTest.testDivergingInclusiveGateway.bpmn20.xml"})
    public void testUnknownVariableInExpression() {
        try {
            this.runtimeService.startProcessInstanceByKey("inclusiveGwDiverging", CollectionUtil.singletonMap((String)"iinput", (Object)1));
            InclusiveGatewayTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Unknown property used in expression", e.getMessage());
        }
    }

    @Deployment
    public void testDecideBasedOnBeanProperty() {
        this.runtimeService.startProcessInstanceByKey("inclusiveDecisionBasedOnBeanProperty", CollectionUtil.singletonMap((String)"order", (Object)new InclusiveGatewayTestOrder(150)));
        List tasks = this.taskService.createTaskQuery().list();
        InclusiveGatewayTest.assertEquals((int)2, (int)tasks.size());
        HashMap<String, String> expectedNames = new HashMap<String, String>();
        expectedNames.put(BEAN_TASK2_NAME, BEAN_TASK2_NAME);
        expectedNames.put(BEAN_TASK3_NAME, BEAN_TASK3_NAME);
        for (Task task : tasks) {
            expectedNames.remove(task.getName());
        }
        InclusiveGatewayTest.assertEquals((int)0, (int)expectedNames.size());
    }

    @Deployment
    public void testDecideBasedOnListOrArrayOfBeans() {
        ArrayList<InclusiveGatewayTestOrder> orders = new ArrayList<InclusiveGatewayTestOrder>();
        orders.add(new InclusiveGatewayTestOrder(50));
        orders.add(new InclusiveGatewayTestOrder(300));
        orders.add(new InclusiveGatewayTestOrder(175));
        ProcessInstance pi = null;
        try {
            pi = this.runtimeService.startProcessInstanceByKey("inclusiveDecisionBasedOnListOrArrayOfBeans", CollectionUtil.singletonMap((String)"orders", orders));
            InclusiveGatewayTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        orders.set(1, new InclusiveGatewayTestOrder(175));
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveDecisionBasedOnListOrArrayOfBeans", CollectionUtil.singletonMap((String)"orders", orders));
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        InclusiveGatewayTest.assertNotNull((Object)task);
        InclusiveGatewayTest.assertEquals((String)BEAN_TASK3_NAME, (String)task.getName());
        orders.set(1, new InclusiveGatewayTestOrder(125));
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveDecisionBasedOnListOrArrayOfBeans", CollectionUtil.singletonMap((String)"orders", orders));
        List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        InclusiveGatewayTest.assertNotNull((Object)tasks);
        InclusiveGatewayTest.assertEquals((int)2, (int)tasks.size());
        ArrayList<String> expectedNames = new ArrayList<String>();
        expectedNames.add(BEAN_TASK2_NAME);
        expectedNames.add(BEAN_TASK3_NAME);
        for (Task t : tasks) {
            expectedNames.remove(t.getName());
        }
        InclusiveGatewayTest.assertEquals((int)0, (int)expectedNames.size());
        InclusiveGatewayTestOrder[] orderArray = orders.toArray(new InclusiveGatewayTestOrder[orders.size()]);
        orderArray[1].setPrice(10);
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveDecisionBasedOnListOrArrayOfBeans", CollectionUtil.singletonMap((String)"orders", (Object)orderArray));
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        InclusiveGatewayTest.assertNotNull((Object)tasks);
        InclusiveGatewayTest.assertEquals((int)3, (int)tasks.size());
        expectedNames.clear();
        expectedNames.add(BEAN_TASK1_NAME);
        expectedNames.add(BEAN_TASK2_NAME);
        expectedNames.add(BEAN_TASK3_NAME);
        for (Task t : tasks) {
            expectedNames.remove(t.getName());
        }
        InclusiveGatewayTest.assertEquals((int)0, (int)expectedNames.size());
    }

    @Deployment
    public void testDecideBasedOnBeanMethod() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("inclusiveDecisionBasedOnBeanMethod", CollectionUtil.singletonMap((String)"order", (Object)new InclusiveGatewayTestOrder(200)));
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        InclusiveGatewayTest.assertNotNull((Object)task);
        InclusiveGatewayTest.assertEquals((String)BEAN_TASK3_NAME, (String)task.getName());
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveDecisionBasedOnBeanMethod", CollectionUtil.singletonMap((String)"order", (Object)new InclusiveGatewayTestOrder(125)));
        List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        InclusiveGatewayTest.assertEquals((int)2, (int)tasks.size());
        ArrayList<String> expectedNames = new ArrayList<String>();
        expectedNames.add(BEAN_TASK2_NAME);
        expectedNames.add(BEAN_TASK3_NAME);
        for (Task t : tasks) {
            expectedNames.remove(t.getName());
        }
        InclusiveGatewayTest.assertEquals((int)0, (int)expectedNames.size());
        try {
            this.runtimeService.startProcessInstanceByKey("inclusiveDecisionBasedOnBeanMethod", CollectionUtil.singletonMap((String)"order", (Object)new InclusiveGatewayTestOrder(300)));
            InclusiveGatewayTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment
    public void testInvalidMethodExpression() {
        try {
            this.runtimeService.startProcessInstanceByKey("inclusiveInvalidMethodExpression", CollectionUtil.singletonMap((String)"order", (Object)new InclusiveGatewayTestOrder(50)));
            InclusiveGatewayTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Unknown method used in expression", e.getMessage());
        }
    }

    @Deployment
    public void testDefaultSequenceFlow() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("inclusiveGwDefaultSequenceFlow", CollectionUtil.singletonMap((String)"input", (Object)1));
        List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        InclusiveGatewayTest.assertEquals((int)2, (int)tasks.size());
        HashMap<String, String> expectedNames = new HashMap<String, String>();
        expectedNames.put("Input is one", "Input is one");
        expectedNames.put("Input is three or one", "Input is three or one");
        for (Task t : tasks) {
            expectedNames.remove(t.getName());
        }
        InclusiveGatewayTest.assertEquals((int)0, (int)expectedNames.size());
        this.runtimeService.deleteProcessInstance(pi.getId(), null);
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveGwDefaultSequenceFlow", CollectionUtil.singletonMap((String)"input", (Object)3));
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        InclusiveGatewayTest.assertEquals((String)"Input is three or one", (String)task.getName());
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveGwDefaultSequenceFlow", CollectionUtil.singletonMap((String)"input", (Object)5));
        task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        InclusiveGatewayTest.assertEquals((String)"Default input", (String)task.getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/gateway/InclusiveGatewayTest.testDefaultSequenceFlow.bpmn20.xml"})
    public void testDefaultSequenceFlowExecutionIsActive() {
        this.runtimeService.startProcessInstanceByKey("inclusiveGwDefaultSequenceFlow", CollectionUtil.singletonMap((String)"input", (Object)5));
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().singleResult();
        InclusiveGatewayTest.assertEquals((String)"theTask2", (String)execution.getActivityId());
        InclusiveGatewayTest.assertTrue((boolean)execution.isActive());
    }

    @Deployment
    public void testSplitMergeSplit() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("inclusiveGwSplitAndMerge", CollectionUtil.singletonMap((String)"input", (Object)1));
        List tasks = this.taskService.createTaskQuery().list();
        InclusiveGatewayTest.assertEquals((int)2, (int)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        InclusiveGatewayTest.assertNotNull((Object)task);
        InclusiveGatewayTest.assertEquals((String)processInstance.getId(), (String)task.getExecutionId());
    }

    @Deployment
    public void testNoIdOnSequenceFlow() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("inclusiveNoIdOnSequenceFlow", CollectionUtil.singletonMap((String)"input", (Object)3));
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        InclusiveGatewayTest.assertEquals((String)"Input is more than one", (String)task.getName());
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveNoIdOnSequenceFlow", CollectionUtil.singletonMap((String)"input", (Object)1));
        List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        InclusiveGatewayTest.assertEquals((int)2, (int)tasks.size());
        HashMap<String, String> expectedNames = new HashMap<String, String>();
        expectedNames.put("Input is one", "Input is one");
        expectedNames.put("Input is more than one", "Input is more than one");
        for (Task t : tasks) {
            expectedNames.remove(t.getName());
        }
        InclusiveGatewayTest.assertEquals((int)0, (int)expectedNames.size());
    }

    @Deployment
    public void testLoop() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("inclusiveTestLoop", CollectionUtil.singletonMap((String)"counter", (Object)1));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        InclusiveGatewayTest.assertEquals((String)"task C", (String)task.getName());
        this.taskService.complete(task.getId());
        InclusiveGatewayTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
        for (Execution execution : this.runtimeService.createExecutionQuery().list()) {
            System.out.println(((ExecutionEntity)execution).getActivityId());
        }
        InclusiveGatewayTest.assertEquals((String)("Found executions: " + this.runtimeService.createExecutionQuery().list()), (long)0L, (long)this.runtimeService.createExecutionQuery().count());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testJoinAfterSubprocesses() {
        HashMap<String, Integer> variableMap = new HashMap<String, Integer>();
        variableMap.put("a", 1);
        variableMap.put("b", 1);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("InclusiveGateway", variableMap);
        InclusiveGatewayTest.assertNotNull((Object)processInstance.getId());
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        InclusiveGatewayTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        InclusiveGatewayTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        Task task = (Task)this.taskService.createTaskQuery().taskAssignee("c").singleResult();
        InclusiveGatewayTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        InclusiveGatewayTest.assertNull((Object)processInstance);
        variableMap = new HashMap();
        variableMap.put("a", 1);
        variableMap.put("b", 2);
        processInstance = this.runtimeService.startProcessInstanceByKey("InclusiveGateway", variableMap);
        InclusiveGatewayTest.assertNotNull((Object)processInstance.getId());
        tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        InclusiveGatewayTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        task = (Task)tasks.get(0);
        InclusiveGatewayTest.assertEquals((String)"a", (String)task.getAssignee());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskAssignee("c").singleResult();
        InclusiveGatewayTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        InclusiveGatewayTest.assertNull((Object)processInstance);
        variableMap = new HashMap();
        variableMap.put("a", 2);
        variableMap.put("b", 2);
        try {
            processInstance = this.runtimeService.startProcessInstanceByKey("InclusiveGateway", variableMap);
            InclusiveGatewayTest.fail();
        }
        catch (ProcessEngineException e) {
            InclusiveGatewayTest.assertTrue((boolean)e.getMessage().contains("No outgoing sequence flow"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/gateway/InclusiveGatewayTest.testJoinAfterCall.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/gateway/InclusiveGatewayTest.testJoinAfterCallSubProcess.bpmn20.xml"})
    public void testJoinAfterCall() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("InclusiveGatewayAfterCall");
        InclusiveGatewayTest.assertNotNull((Object)processInstance.getId());
        InclusiveGatewayTest.assertEquals((long)3L, (long)this.taskService.createTaskQuery().count());
        Task taskA = (Task)this.taskService.createTaskQuery().taskName("Task A").singleResult();
        InclusiveGatewayTest.assertNotNull((Object)taskA);
        this.taskService.complete(taskA.getId());
        InclusiveGatewayTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Task taskB = (Task)this.taskService.createTaskQuery().taskName("Task B").singleResult();
        InclusiveGatewayTest.assertNotNull((Object)taskB);
        this.taskService.complete(taskB.getId());
        InclusiveGatewayTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task taskC = (Task)this.taskService.createTaskQuery().taskName("Task C").singleResult();
        InclusiveGatewayTest.assertNotNull((Object)taskC);
        this.taskService.complete(taskC.getId());
        InclusiveGatewayTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task taskD = (Task)this.taskService.createTaskQuery().taskName("Task D").singleResult();
        InclusiveGatewayTest.assertNotNull((Object)taskD);
        InclusiveGatewayTest.assertEquals((String)"Task D", (String)taskD.getName());
        this.taskService.complete(taskD.getId());
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        InclusiveGatewayTest.assertNull((Object)processInstance);
    }

    @Deployment
    public void testDecisionFunctionality() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 1);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("inclusiveGateway", variables);
        List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        InclusiveGatewayTest.assertEquals((int)3, (int)tasks.size());
        HashMap<String, String> expectedMessages = new HashMap<String, String>();
        expectedMessages.put(TASK1_NAME, TASK1_NAME);
        expectedMessages.put(TASK2_NAME, TASK2_NAME);
        expectedMessages.put(TASK3_NAME, TASK3_NAME);
        for (Task task : tasks) {
            expectedMessages.remove(task.getName());
        }
        InclusiveGatewayTest.assertEquals((int)0, (int)expectedMessages.size());
        variables.put("input", 2);
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveGateway", variables);
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        InclusiveGatewayTest.assertEquals((int)2, (int)tasks.size());
        expectedMessages = new HashMap();
        expectedMessages.put(TASK2_NAME, TASK2_NAME);
        expectedMessages.put(TASK3_NAME, TASK3_NAME);
        for (Task task : tasks) {
            expectedMessages.remove(task.getName());
        }
        InclusiveGatewayTest.assertEquals((int)0, (int)expectedMessages.size());
        variables.put("input", 3);
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveGateway", variables);
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        InclusiveGatewayTest.assertEquals((int)1, (int)tasks.size());
        expectedMessages = new HashMap();
        expectedMessages.put(TASK3_NAME, TASK3_NAME);
        for (Task task : tasks) {
            expectedMessages.remove(task.getName());
        }
        InclusiveGatewayTest.assertEquals((int)0, (int)expectedMessages.size());
        variables.put("input", 4);
        try {
            this.runtimeService.startProcessInstanceByKey("inclusiveGateway", variables);
            InclusiveGatewayTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment
    public void testJoinAfterSequentialMultiInstanceSubProcess() {
        this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery query = this.taskService.createTaskQuery();
        Task task = (Task)query.taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        InclusiveGatewayTest.assertNull((Object)query.taskDefinitionKey("taskAfterJoin").singleResult());
    }

    @Deployment
    public void testJoinAfterParallelMultiInstanceSubProcess() {
        this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery query = this.taskService.createTaskQuery();
        Task task = (Task)query.taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        InclusiveGatewayTest.assertNull((Object)query.taskDefinitionKey("taskAfterJoin").singleResult());
    }

    @Deployment
    public void testJoinAfterNestedScopes() {
        this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery query = this.taskService.createTaskQuery();
        Task task = (Task)query.taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        InclusiveGatewayTest.assertNull((Object)query.taskDefinitionKey("taskAfterJoin").singleResult());
    }
}

