/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.required;

import java.util.Collections;
import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.test.Deployment;

public class RequiredRuleTest
extends CmmnProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/required/RequiredRuleTest.testVariableBasedRule.cmmn"})
    public void testRequiredRuleEvaluatesToTrue() {
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("required", true));
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        RequiredRuleTest.assertNotNull((Object)taskExecution);
        RequiredRuleTest.assertTrue((boolean)taskExecution.isRequired());
        try {
            this.caseService.completeCaseExecution(caseInstance.getId());
            RequiredRuleTest.fail((String)"completing the containing stage should not be allowed");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/required/RequiredRuleTest.testVariableBasedRule.cmmn"})
    public void testRequiredRuleEvaluatesToFalse() {
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("required", false));
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        RequiredRuleTest.assertNotNull((Object)taskExecution);
        RequiredRuleTest.assertFalse((boolean)taskExecution.isRequired());
        this.caseService.completeCaseExecution(caseInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/required/RequiredRuleTest.testDefaultVariableBasedRule.cmmn"})
    public void testDefaultRequiredRuleEvaluatesToTrue() {
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("required", true));
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        RequiredRuleTest.assertNotNull((Object)taskExecution);
        RequiredRuleTest.assertTrue((boolean)taskExecution.isRequired());
        try {
            this.caseService.completeCaseExecution(caseInstance.getId());
            RequiredRuleTest.fail((String)"completing the containing stage should not be allowed");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/required/RequiredRuleTest.testDefaultVariableBasedRule.cmmn"})
    public void testDefaultRequiredRuleEvaluatesToFalse() {
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("required", false));
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        RequiredRuleTest.assertNotNull((Object)taskExecution);
        RequiredRuleTest.assertFalse((boolean)taskExecution.isRequired());
        this.caseService.completeCaseExecution(caseInstance.getId());
    }
}

