/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.ActivityInstanceCancellationCmd;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.camunda.bpm.engine.test.concurrency.ControlledCommand;
import org.slf4j.Logger;

public class CompetingActivityInstanceCancellationTest
extends PluggableProcessEngineTestCase {
    private static Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    Thread testThread = Thread.currentThread();
    static ControllableThread activeThread;
    static String jobId;

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingForkTest.testCompetingFork.bpmn20.xml"})
    public void testCompetingCancellation() throws Exception {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstance[] children = activityInstance.getChildActivityInstances();
        String task1ActivityInstanceId = null;
        String task2ActivityInstanceId = null;
        String task3ActivityInstanceId = null;
        for (ActivityInstance currentInstance : children) {
            String id = currentInstance.getId();
            String activityId = currentInstance.getActivityId();
            if ("task1".equals(activityId)) {
                task1ActivityInstanceId = id;
                continue;
            }
            if ("task2".equals(activityId)) {
                task2ActivityInstanceId = id;
                continue;
            }
            if ("task3".equals(activityId)) {
                task3ActivityInstanceId = id;
                continue;
            }
            CompetingActivityInstanceCancellationTest.fail();
        }
        LOG.debug("test thread starts thread one");
        CancelActivityInstance threadOne = new CancelActivityInstance(processInstanceId, task1ActivityInstanceId);
        threadOne.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread thread two");
        CancelActivityInstance threadTwo = new CancelActivityInstance(processInstanceId, task2ActivityInstanceId);
        threadTwo.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread continues to start thread three");
        CancelActivityInstance threadThree = new CancelActivityInstance(processInstanceId, task3ActivityInstanceId);
        threadThree.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        CompetingActivityInstanceCancellationTest.assertNull((Object)((Object)threadOne.exception));
        LOG.debug("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        CompetingActivityInstanceCancellationTest.assertNotNull((Object)((Object)threadTwo.exception));
        this.assertTextPresent("was updated by another transaction concurrently", threadTwo.exception.getMessage());
        LOG.debug("test thread notifies thread 3");
        threadThree.proceedAndWaitTillDone();
        CompetingActivityInstanceCancellationTest.assertNotNull((Object)((Object)threadThree.exception));
        this.assertTextPresent("was updated by another transaction concurrently", threadThree.exception.getMessage());
    }

    public class CancelActivityInstance
    extends ControllableThread {
        String processInstanceId;
        String activityInstanceId;
        OptimisticLockingException exception;

        public CancelActivityInstance(String processInstanceId, String activityInstanceId) {
            this.processInstanceId = processInstanceId;
            this.activityInstanceId = activityInstanceId;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                CompetingActivityInstanceCancellationTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, new ActivityInstanceCancellationCmd(this.processInstanceId, this.activityInstanceId)));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            LOG.debug(this.getName() + " ends");
        }
    }
}

