/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.MessageCorrelationBuilderImpl;
import org.camunda.bpm.engine.impl.cmd.CompleteTaskCmd;
import org.camunda.bpm.engine.impl.cmd.MessageEventReceivedCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;

public class CompetingMessageCorrelationTest
extends ConcurrencyTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.catchMessageProcess.bpmn20.xml"})
    public void testConcurrentCorrelationFailsWithOptimisticLockingException() {
        InvocationLogListener.reset();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", false));
        thread1.reportInterrupts();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", false));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread2.makeContinue();
        thread1.waitForSync();
        thread2.waitForSync();
        CompetingMessageCorrelationTest.assertEquals((int)2, (int)InvocationLogListener.getInvocations());
        thread1.waitUntilDone();
        CompetingMessageCorrelationTest.assertNull((Object)thread1.getException());
        Task afterMessageTask = (Task)this.taskService.createTaskQuery().singleResult();
        CompetingMessageCorrelationTest.assertEquals((String)afterMessageTask.getTaskDefinitionKey(), (String)"afterMessageUserTask");
        thread2.waitUntilDone();
        CompetingMessageCorrelationTest.assertTrue((thread2.getException() != null ? 1 : 0) != 0);
        CompetingMessageCorrelationTest.assertTrue((boolean)(thread2.getException() instanceof OptimisticLockingException));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.catchMessageProcess.bpmn20.xml"})
    public void testConcurrentExclusiveCorrelation() throws InterruptedException {
        InvocationLogListener.reset();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", true));
        thread1.reportInterrupts();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", true));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        CompetingMessageCorrelationTest.assertEquals((int)1, (int)InvocationLogListener.getInvocations());
        thread2.makeContinue();
        Thread.sleep(2000L);
        thread1.makeContinue();
        CompetingMessageCorrelationTest.assertNull((Object)thread1.getException());
        thread2.waitForSync();
        CompetingMessageCorrelationTest.assertTrue((thread2.getException() != null ? 1 : 0) != 0);
        CompetingMessageCorrelationTest.assertTrue((boolean)(thread2.getException() instanceof ProcessEngineException));
        this.assertTextPresent("does not have a subscription to a message event with name 'Message'", thread2.getException().getMessage());
        thread1.join();
        CompetingMessageCorrelationTest.assertNull((Object)thread1.getException());
        Task afterMessageTask = (Task)this.taskService.createTaskQuery().singleResult();
        CompetingMessageCorrelationTest.assertEquals((String)afterMessageTask.getTaskDefinitionKey(), (String)"afterMessageUserTask");
        CompetingMessageCorrelationTest.assertEquals((int)1, (int)InvocationLogListener.getInvocations());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.catchMessageProcess.bpmn20.xml"})
    public void testConcurrentExclusiveCorrelationToDifferentExecutions() throws InterruptedException {
        InvocationLogListener.reset();
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("testProcess");
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", instance1.getId(), true));
        thread1.reportInterrupts();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", instance2.getId(), true));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        CompetingMessageCorrelationTest.assertEquals((int)1, (int)InvocationLogListener.getInvocations());
        thread2.makeContinue();
        thread1.waitUntilDone();
        CompetingMessageCorrelationTest.assertNull((Object)thread1.getException());
        thread2.waitForSync();
        CompetingMessageCorrelationTest.assertEquals((int)2, (int)InvocationLogListener.getInvocations());
        thread2.waitUntilDone();
        CompetingMessageCorrelationTest.assertNull((Object)thread2.getException());
        CompetingMessageCorrelationTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().taskDefinitionKey("afterMessageUserTask").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.catchMessageProcess.bpmn20.xml"})
    public void FAILING_testConcurrentExclusiveCorrelationToDifferentExecutionsCase2() throws InterruptedException {
        InvocationLogListener.reset();
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("testProcess");
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", instance1.getId(), true));
        thread1.reportInterrupts();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", instance2.getId(), true));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        CompetingMessageCorrelationTest.assertEquals((int)1, (int)InvocationLogListener.getInvocations());
        thread2.makeContinue();
        thread2.waitForSync();
        CompetingMessageCorrelationTest.assertEquals((int)2, (int)InvocationLogListener.getInvocations());
        thread2.waitUntilDone();
        CompetingMessageCorrelationTest.assertNull((Object)thread2.getException());
        thread1.waitUntilDone();
        CompetingMessageCorrelationTest.assertNull((Object)thread1.getException());
        CompetingMessageCorrelationTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().taskDefinitionKey("afterMessageUserTask").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.catchMessageProcess.bpmn20.xml"})
    public void testConcurrentMixedCorrelation() throws InterruptedException {
        InvocationLogListener.reset();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", true));
        thread1.reportInterrupts();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", false));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        thread2.waitForSync();
        CompetingMessageCorrelationTest.assertEquals((int)2, (int)InvocationLogListener.getInvocations());
        thread1.waitUntilDone();
        CompetingMessageCorrelationTest.assertNull((Object)thread1.getException());
        Task afterMessageTask = (Task)this.taskService.createTaskQuery().singleResult();
        CompetingMessageCorrelationTest.assertEquals((String)afterMessageTask.getTaskDefinitionKey(), (String)"afterMessageUserTask");
        thread2.makeContinue();
        thread2.waitForSync();
        CompetingMessageCorrelationTest.assertTrue((thread2.getException() != null ? 1 : 0) != 0);
        CompetingMessageCorrelationTest.assertTrue((boolean)(thread2.getException() instanceof OptimisticLockingException));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.catchMessageProcess.bpmn20.xml"})
    public void FAILING_testConcurrentMixedCorrelationCase2() throws InterruptedException {
        InvocationLogListener.reset();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", false));
        thread1.reportInterrupts();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", true));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        thread2.waitForSync();
        CompetingMessageCorrelationTest.assertEquals((int)2, (int)InvocationLogListener.getInvocations());
        thread1.makeContinue();
        Thread.sleep(5000L);
        CompetingMessageCorrelationTest.assertNull((Object)thread1.getException());
        CompetingMessageCorrelationTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
        thread2.waitUntilDone();
        CompetingMessageCorrelationTest.assertNull((Object)thread2.getException());
        Task afterMessageTask = (Task)this.taskService.createTaskQuery().singleResult();
        CompetingMessageCorrelationTest.assertNotNull((Object)afterMessageTask);
        CompetingMessageCorrelationTest.assertEquals((String)afterMessageTask.getTaskDefinitionKey(), (String)"afterMessageUserTask");
        thread1.join();
        CompetingMessageCorrelationTest.assertTrue((thread1.getException() != null ? 1 : 0) != 0);
        CompetingMessageCorrelationTest.assertTrue((boolean)(thread1.getException() instanceof OptimisticLockingException));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.eventSubprocess.bpmn"})
    public void testEventSubprocess() {
        InvocationLogListener.reset();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("incoming", false));
        thread1.reportInterrupts();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("incoming", false));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread2.makeContinue();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.waitUntilDone();
        CompetingMessageCorrelationTest.assertNull((Object)thread1.getException());
        thread2.waitUntilDone();
        CompetingMessageCorrelationTest.assertTrue((thread2.getException() != null ? 1 : 0) != 0);
        CompetingMessageCorrelationTest.assertTrue((boolean)(thread2.getException() instanceof OptimisticLockingException));
    }

    @Deployment
    public void testConcurrentMessageCorrelationAndTreeCompaction() {
        this.runtimeService.startProcessInstanceByKey("process");
        ConcurrencyTestCase.ThreadControl correlateThread = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", false));
        correlateThread.reportInterrupts();
        correlateThread.waitForSync();
        correlateThread.makeContinueAndWaitForSync();
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        correlateThread.waitUntilDone();
        Throwable exception = correlateThread.getException();
        CompetingMessageCorrelationTest.assertNotNull((Object)exception);
        CompetingMessageCorrelationTest.assertTrue((boolean)(exception instanceof OptimisticLockingException));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.testConcurrentMessageCorrelationAndTreeCompaction.bpmn20.xml"})
    public void testConcurrentTreeCompactionAndMessageCorrelation() {
        this.runtimeService.startProcessInstanceByKey("process");
        List tasks = this.taskService.createTaskQuery().list();
        ConcurrencyTestCase.ThreadControl taskCompletionThread = this.executeControllableCommand(new ControllableCompleteTaskCommand(tasks));
        taskCompletionThread.reportInterrupts();
        taskCompletionThread.waitForSync();
        this.runtimeService.correlateMessage("Message");
        taskCompletionThread.waitUntilDone();
        Throwable exception = taskCompletionThread.getException();
        CompetingMessageCorrelationTest.assertNotNull((Object)exception);
        CompetingMessageCorrelationTest.assertTrue((boolean)(exception instanceof OptimisticLockingException));
    }

    @Deployment
    public void testConcurrentMessageCorrelationTwiceAndTreeCompaction() {
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("Message2");
        ConcurrencyTestCase.ThreadControl correlateThread = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message1", false));
        correlateThread.reportInterrupts();
        correlateThread.waitForSync();
        correlateThread.makeContinueAndWaitForSync();
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        correlateThread.waitUntilDone();
        Throwable exception = correlateThread.getException();
        CompetingMessageCorrelationTest.assertNotNull((Object)exception);
        CompetingMessageCorrelationTest.assertTrue((boolean)(exception instanceof OptimisticLockingException));
    }

    @Deployment
    public void testConcurrentEndExecutionListener() {
        InvocationLogListener.reset();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        List tasks = this.runtimeService.createExecutionQuery().messageEventSubscriptionName("Message").list();
        CompetingMessageCorrelationTest.assertEquals((int)2, (int)tasks.size());
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageEventReceivedCommand(((Execution)tasks.get(0)).getId(), "Message", true));
        thread1.reportInterrupts();
        thread1.waitForSync();
        CompetingMessageCorrelationTest.assertEquals((int)1, (int)InvocationLogListener.getInvocations());
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageEventReceivedCommand(((Execution)tasks.get(1)).getId(), "Message", false));
        thread2.waitForSync();
        thread2.waitUntilDone();
        CompetingMessageCorrelationTest.assertEquals((int)2, (int)InvocationLogListener.getInvocations());
        thread1.makeContinueAndWaitForSync();
        CompetingMessageCorrelationTest.assertEquals((int)2, (int)InvocationLogListener.getInvocations());
        thread1.waitUntilDone();
        Throwable exception = thread1.getException();
        CompetingMessageCorrelationTest.assertNotNull((Object)exception);
        CompetingMessageCorrelationTest.assertTrue((boolean)(exception instanceof OptimisticLockingException));
        CompetingMessageCorrelationTest.assertEquals((int)2, (int)InvocationLogListener.getInvocations());
    }

    public static class ControllableCompleteTaskCommand
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        protected List<Task> tasks;

        public ControllableCompleteTaskCommand(List<Task> tasks) {
            this.tasks = tasks;
        }

        public Void execute(CommandContext commandContext) {
            for (Task task : this.tasks) {
                CompleteTaskCmd completeTaskCmd = new CompleteTaskCmd(task.getId(), null);
                completeTaskCmd.execute(commandContext);
            }
            this.monitor.sync();
            return null;
        }
    }

    protected static class ControllableMessageEventReceivedCommand
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        protected final String executionId;
        protected final String messageName;
        protected final boolean shouldWaitInListener;

        public ControllableMessageEventReceivedCommand(String executionId, String messageName, boolean shouldWaitInListener) {
            this.executionId = executionId;
            this.messageName = messageName;
            this.shouldWaitInListener = shouldWaitInListener;
        }

        public Void execute(CommandContext commandContext) {
            if (this.shouldWaitInListener) {
                WaitingListener.setMonitor(this.monitor);
            }
            MessageEventReceivedCmd receivedCmd = new MessageEventReceivedCmd(this.messageName, this.executionId, null);
            receivedCmd.execute(commandContext);
            this.monitor.sync();
            return null;
        }
    }

    protected static class ControllableMessageCorrelationCommand
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        protected String messageName;
        protected boolean exclusive;
        protected String processInstanceId;

        public ControllableMessageCorrelationCommand(String messageName, boolean exclusive) {
            this.messageName = messageName;
            this.exclusive = exclusive;
        }

        public ControllableMessageCorrelationCommand(String messageName, String processInstanceId, boolean exclusive) {
            this(messageName, exclusive);
            this.processInstanceId = processInstanceId;
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            MessageCorrelationBuilderImpl correlationBuilder = new MessageCorrelationBuilderImpl(commandContext, this.messageName);
            if (this.processInstanceId != null) {
                correlationBuilder.processInstanceId(this.processInstanceId);
            }
            if (this.exclusive) {
                correlationBuilder.correlateExclusively();
            } else {
                correlationBuilder.correlate();
            }
            this.monitor.sync();
            return null;
        }
    }

    public static class WaitingListener
    implements ExecutionListener {
        protected static ConcurrencyTestCase.ThreadControl monitor;

        public void notify(DelegateExecution execution) throws Exception {
            if (monitor != null) {
                ConcurrencyTestCase.ThreadControl localMonitor = monitor;
                monitor = null;
                localMonitor.sync();
            }
        }

        public static void setMonitor(ConcurrencyTestCase.ThreadControl monitor) {
            WaitingListener.monitor = monitor;
        }
    }

    public static class InvocationLogListener
    implements JavaDelegate {
        protected static AtomicInteger invocations = new AtomicInteger(0);

        public void execute(DelegateExecution execution) throws Exception {
            invocations.incrementAndGet();
        }

        public static void reset() {
            invocations.set(0);
        }

        public static int getInvocations() {
            return invocations.get();
        }
    }
}

