/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.entity;

import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;

public class JobEntityTest
extends PluggableProcessEngineTestCase {
    public void testInsertJobWithExceptionMessage() {
        String fittingThreeByteMessage = this.repeatCharacter("\u9faf", JobEntity.MAX_EXCEPTION_MESSAGE_LENGTH);
        MessageEntity threeByteJobEntity = new MessageEntity();
        threeByteJobEntity.setExceptionMessage(fittingThreeByteMessage);
        this.insertJob((JobEntity)threeByteJobEntity);
        this.deleteJob((JobEntity)threeByteJobEntity);
    }

    public void testJobExceptionMessageCutoff() {
        MessageEntity threeByteJobEntity = new MessageEntity();
        String message = this.repeatCharacter("a", JobEntity.MAX_EXCEPTION_MESSAGE_LENGTH * 2);
        threeByteJobEntity.setExceptionMessage(message);
        JobEntityTest.assertEquals((int)JobEntity.MAX_EXCEPTION_MESSAGE_LENGTH, (int)threeByteJobEntity.getExceptionMessage().length());
    }

    protected void insertJob(final JobEntity jobEntity) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getJobManager().insert((DbEntity)jobEntity);
                return null;
            }
        });
    }

    protected void deleteJob(final JobEntity jobEntity) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getJobManager().delete((DbEntity)jobEntity);
                return null;
            }
        });
    }

    protected String repeatCharacter(String encodedCharacter, int numCharacters) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numCharacters; ++i) {
            sb.append(encodedCharacter);
        }
        return sb.toString();
    }
}

