/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import org.camunda.bpm.engine.migration.MigrationInstructionInstanceValidationFailure;
import org.camunda.bpm.engine.migration.MigrationInstructionInstanceValidationReport;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MigrationInstructionInstanceValidationReportAssert {
    protected MigrationInstructionInstanceValidationReport actual;

    public MigrationInstructionInstanceValidationReportAssert(MigrationInstructionInstanceValidationReport report) {
        this.actual = report;
    }

    public MigrationInstructionInstanceValidationReportAssert isNotNull() {
        Assert.assertNotNull((String)"Expected report to be not null", (Object)this.actual);
        return this;
    }

    public MigrationInstructionInstanceValidationReportAssert hasProcessInstance(ProcessInstance processInstance) {
        return this.hasProcessInstanceId(processInstance.getId());
    }

    public MigrationInstructionInstanceValidationReportAssert hasProcessInstanceId(String processInstanceId) {
        this.isNotNull();
        Assert.assertEquals((String)"Expected report to be for process instance", (Object)processInstanceId, (Object)this.actual.getProcessInstanceId());
        return this;
    }

    public MigrationInstructionInstanceValidationReportAssert hasFailures() {
        this.isNotNull();
        Assert.assertTrue((String)"Expected report to contain failures", (boolean)this.actual.getValidationFailures().isEmpty());
        return this;
    }

    public MigrationInstructionInstanceValidationReportAssert hasFailures(int numberOfFailures) {
        this.isNotNull();
        Assert.assertEquals((String)"Expected report to contain failures", (long)numberOfFailures, (long)this.actual.getValidationFailures().size());
        return this;
    }

    public MigrationInstructionInstanceValidationReportAssert hasFailure(String activityId, String errorMessage) {
        this.isNotNull();
        boolean failureFound = false;
        for (MigrationInstructionInstanceValidationFailure failure : this.actual.getValidationFailures()) {
            if (!((String)failure.getMigrationInstruction().getSourceActivityIds().get(0)).equals(activityId)) continue;
            Assert.assertThat((Object)failure.getErrorMessage(), (Matcher)CoreMatchers.containsString((String)errorMessage));
            Assert.assertNotNull((Object)failure.getActivityInstanceIds());
            Assert.assertEquals((long)1L, (long)failure.getActivityInstanceIds().size());
            failureFound = true;
            break;
        }
        if (!failureFound) {
            Assert.fail((String)("Unable to find failure for activity id '" + activityId + "'"));
        }
        return this;
    }

    public static MigrationInstructionInstanceValidationReportAssert assertThat(MigrationInstructionInstanceValidationReport report) {
        return new MigrationInstructionInstanceValidationReportAssert(report);
    }
}

