/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.migration.MigrationInstruction;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.junit.Assert;

public class MigrationPlanAssert {
    protected MigrationPlan actual;

    public MigrationPlanAssert(MigrationPlan actual) {
        this.actual = actual;
    }

    public MigrationPlanAssert isNotNull() {
        Assert.assertNotNull((String)"The migration plan is null", (Object)this.actual);
        return this;
    }

    public MigrationPlanAssert hasSourceProcessDefinition(ProcessDefinition sourceProcessDefinition) {
        return this.hasSourceProcessDefinitionId(sourceProcessDefinition.getId());
    }

    public MigrationPlanAssert hasSourceProcessDefinitionId(String sourceProcessDefinitionId) {
        this.isNotNull();
        Assert.assertEquals((String)"The source process definition id does not match", (Object)sourceProcessDefinitionId, (Object)this.actual.getSourceProcessDefinitionId());
        return this;
    }

    public MigrationPlanAssert hasTargetProcessDefinition(ProcessDefinition targetProcessDefinition) {
        return this.hasTargetProcessDefinitionId(targetProcessDefinition.getId());
    }

    public MigrationPlanAssert hasTargetProcessDefinitionId(String targetProcessDefinitionId) {
        this.isNotNull();
        Assert.assertEquals((String)"The target process definition id does not match", (Object)targetProcessDefinitionId, (Object)this.actual.getTargetProcessDefinitionId());
        return this;
    }

    public MigrationPlanAssert hasInstructions(MigrationInstructionAssert ... instructionAsserts) {
        this.isNotNull();
        ArrayList notExpected = new ArrayList(this.actual.getInstructions());
        ArrayList notFound = new ArrayList();
        Collections.addAll(notFound, instructionAsserts);
        for (MigrationInstructionAssert instructionAssert : instructionAsserts) {
            for (MigrationInstruction instruction : this.actual.getInstructions()) {
                if (!((Object)instructionAssert.sourceActivityIds).equals(instruction.getSourceActivityIds())) continue;
                notFound.remove(instructionAssert);
                notExpected.remove(instruction);
                Assert.assertEquals((String)("Target activity ids do not match for instruction " + instruction), instructionAssert.targetActivityIds, (Object)instruction.getTargetActivityIds());
            }
        }
        if (!notExpected.isEmpty() || !notFound.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("\nActual migration instructions:\n\t").append(this.actual.getInstructions()).append("\n");
            if (!notExpected.isEmpty()) {
                builder.append("Unexpected migration instructions:\n\t").append(notExpected).append("\n");
            }
            if (!notFound.isEmpty()) {
                builder.append("Migration instructions missing:\n\t").append(notFound);
            }
            Assert.fail((String)builder.toString());
        }
        return this;
    }

    public MigrationPlanAssert hasEmptyInstructions() {
        this.isNotNull();
        List instructions = this.actual.getInstructions();
        Assert.assertTrue((String)("Expected migration plan has no instructions but has: " + instructions), (boolean)instructions.isEmpty());
        return this;
    }

    public static MigrationPlanAssert assertThat(MigrationPlan migrationPlan) {
        return new MigrationPlanAssert(migrationPlan);
    }

    public static MigrationInstructionAssert migrate(String ... sourceActivityIds) {
        return new MigrationInstructionAssert().from(sourceActivityIds);
    }

    public static class MigrationInstructionAssert {
        protected List<String> sourceActivityIds = new ArrayList<String>();
        protected List<String> targetActivityIds = new ArrayList<String>();

        public MigrationInstructionAssert from(String ... sourceActivityIds) {
            Collections.addAll(this.sourceActivityIds, sourceActivityIds);
            return this;
        }

        public MigrationInstructionAssert to(String ... targetActivityIds) {
            Collections.addAll(this.targetActivityIds, targetActivityIds);
            return this;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MigrationInstructionAssert[sourceActivities=[");
            this.joinActivityIds(builder, this.sourceActivityIds);
            builder.append("], targetActivityIds=[");
            this.joinActivityIds(builder, this.targetActivityIds);
            return builder.append("]]").toString();
        }

        protected void joinActivityIds(StringBuilder builder, List<String> activityIds) {
            for (int i = 0; i < activityIds.size(); ++i) {
                builder.append(activityIds.get(i));
                if (i >= activityIds.size() - 1) continue;
                builder.append(", ");
            }
        }
    }
}

