/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import org.camunda.bpm.engine.impl.migration.validation.MigrationPlanValidationReportImpl;
import org.camunda.bpm.engine.migration.MigrationPlanValidationFailure;
import org.camunda.bpm.engine.migration.MigrationPlanValidationReport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MigrationPlanValidationReportAssert {
    protected MigrationPlanValidationReport actual;

    public MigrationPlanValidationReportAssert(MigrationPlanValidationReport report) {
        this.actual = report;
    }

    public MigrationPlanValidationReportAssert isNotNull() {
        Assert.assertNotNull((String)"Expected report to be not null", (Object)this.actual);
        return this;
    }

    public MigrationPlanValidationReportAssert hasFailures() {
        this.isNotNull();
        Assert.assertTrue((String)"Expected report to contain failures", (boolean)((MigrationPlanValidationReportImpl)this.actual).hasFailures());
        return this;
    }

    public MigrationPlanValidationReportAssert hasFailures(int numberOfFailures) {
        this.isNotNull();
        Assert.assertEquals((String)"Expected report to contain failures", (long)numberOfFailures, (long)this.actual.getValidationFailures().size());
        return this;
    }

    public MigrationPlanValidationReportAssert hasFailure(String activityId, String errorMessage) {
        this.isNotNull();
        boolean failureFound = false;
        for (MigrationPlanValidationFailure failure : this.actual.getValidationFailures()) {
            if (!failure.getMigrationInstruction().getSourceActivityIds().contains(activityId)) continue;
            Assert.assertThat((Object)failure.getErrorMessage(), (Matcher)CoreMatchers.containsString((String)errorMessage));
            failureFound = true;
            break;
        }
        if (!failureFound) {
            Assert.fail((String)("Unable to find failure for activity id '" + activityId + "'"));
        }
        return this;
    }

    public static MigrationPlanValidationReportAssert assertThat(MigrationPlanValidationReport report) {
        return new MigrationPlanValidationReportAssert(report);
    }
}

