/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.io.Serializable;
import java.util.List;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.EventSubscriptionQuery;

public class EventSubscriptionQueryImpl
extends AbstractQuery<EventSubscriptionQuery, EventSubscription>
implements Serializable,
EventSubscriptionQuery {
    private static final long serialVersionUID = 1L;
    protected String eventSubscriptionId;
    protected String eventName;
    protected String eventType;
    protected String executionId;
    protected String processInstanceId;
    protected String activityId;
    protected String[] tenantIds;

    public EventSubscriptionQueryImpl() {
    }

    public EventSubscriptionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public EventSubscriptionQuery eventSubscriptionId(String id) {
        EnsureUtil.ensureNotNull("event subscription id", (Object)id);
        this.eventSubscriptionId = id;
        return this;
    }

    @Override
    public EventSubscriptionQuery eventName(String eventName) {
        EnsureUtil.ensureNotNull("event name", (Object)eventName);
        this.eventName = eventName;
        return this;
    }

    @Override
    public EventSubscriptionQueryImpl executionId(String executionId) {
        EnsureUtil.ensureNotNull("execution id", (Object)executionId);
        this.executionId = executionId;
        return this;
    }

    @Override
    public EventSubscriptionQuery processInstanceId(String processInstanceId) {
        EnsureUtil.ensureNotNull("process instance id", (Object)processInstanceId);
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public EventSubscriptionQueryImpl activityId(String activityId) {
        EnsureUtil.ensureNotNull("activity id", (Object)activityId);
        this.activityId = activityId;
        return this;
    }

    @Override
    public EventSubscriptionQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        return this;
    }

    @Override
    public EventSubscriptionQueryImpl eventType(String eventType) {
        EnsureUtil.ensureNotNull("event type", (Object)eventType);
        this.eventType = eventType;
        return this;
    }

    @Override
    public EventSubscriptionQuery orderByCreated() {
        return (EventSubscriptionQuery)this.orderBy(EventSubscriptionQueryProperty.CREATED);
    }

    @Override
    public EventSubscriptionQuery orderByTenantId() {
        return (EventSubscriptionQuery)this.orderBy(EventSubscriptionQueryProperty.TENANT_ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getEventSubscriptionManager().findEventSubscriptionCountByQueryCriteria(this);
    }

    @Override
    public List<EventSubscription> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getEventSubscriptionManager().findEventSubscriptionsByQueryCriteria(this, page);
    }

    public String getEventSubscriptionId() {
        return this.eventSubscriptionId;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getActivityId() {
        return this.activityId;
    }
}

