/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.JobQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.CompareUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;

public class JobQueryImpl
extends AbstractQuery<JobQuery, Job>
implements JobQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String activityId;
    protected String id;
    protected String jobDefinitionId;
    protected String processInstanceId;
    protected String executionId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected boolean retriesLeft;
    protected boolean executable;
    protected boolean onlyTimers;
    protected boolean onlyMessages;
    protected Date duedateHigherThan;
    protected Date duedateLowerThan;
    protected Date duedateHigherThanOrEqual;
    protected Date duedateLowerThanOrEqual;
    protected Long priorityHigherThanOrEqual;
    protected Long priorityLowerThanOrEqual;
    protected boolean withException;
    protected String exceptionMessage;
    protected boolean noRetriesLeft;
    protected SuspensionState suspensionState;
    protected String[] tenantIds;

    public JobQueryImpl() {
    }

    public JobQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public JobQuery jobId(String jobId) {
        EnsureUtil.ensureNotNull("Provided job id", (Object)jobId);
        this.id = jobId;
        return this;
    }

    @Override
    public JobQuery jobDefinitionId(String jobDefinitionId) {
        EnsureUtil.ensureNotNull("Provided job definition id", (Object)jobDefinitionId);
        this.jobDefinitionId = jobDefinitionId;
        return this;
    }

    @Override
    public JobQueryImpl processInstanceId(String processInstanceId) {
        EnsureUtil.ensureNotNull("Provided process instance id", (Object)processInstanceId);
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public JobQueryImpl executionId(String executionId) {
        EnsureUtil.ensureNotNull("Provided execution id", (Object)executionId);
        this.executionId = executionId;
        return this;
    }

    @Override
    public JobQuery processDefinitionId(String processDefinitionId) {
        EnsureUtil.ensureNotNull("Provided process definition id", (Object)processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public JobQuery processDefinitionKey(String processDefinitionKey) {
        EnsureUtil.ensureNotNull("Provided process instance key", (Object)processDefinitionKey);
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public JobQuery activityId(String activityId) {
        EnsureUtil.ensureNotNull("Provided activity id", (Object)activityId);
        this.activityId = activityId;
        return this;
    }

    @Override
    public JobQuery withRetriesLeft() {
        this.retriesLeft = true;
        return this;
    }

    @Override
    public JobQuery executable() {
        this.executable = true;
        return this;
    }

    @Override
    public JobQuery timers() {
        if (this.onlyMessages) {
            throw new ProcessEngineException("Cannot combine onlyTimers() with onlyMessages() in the same query");
        }
        this.onlyTimers = true;
        return this;
    }

    @Override
    public JobQuery messages() {
        if (this.onlyTimers) {
            throw new ProcessEngineException("Cannot combine onlyTimers() with onlyMessages() in the same query");
        }
        this.onlyMessages = true;
        return this;
    }

    @Override
    public JobQuery duedateHigherThan(Date date) {
        EnsureUtil.ensureNotNull("Provided date", (Object)date);
        this.duedateHigherThan = date;
        return this;
    }

    @Override
    public JobQuery duedateLowerThan(Date date) {
        EnsureUtil.ensureNotNull("Provided date", (Object)date);
        this.duedateLowerThan = date;
        return this;
    }

    @Override
    public JobQuery duedateHigherThen(Date date) {
        return this.duedateHigherThan(date);
    }

    @Override
    public JobQuery duedateHigherThenOrEquals(Date date) {
        EnsureUtil.ensureNotNull("Provided date", (Object)date);
        this.duedateHigherThanOrEqual = date;
        return this;
    }

    @Override
    public JobQuery duedateLowerThen(Date date) {
        return this.duedateLowerThan(date);
    }

    @Override
    public JobQuery duedateLowerThenOrEquals(Date date) {
        EnsureUtil.ensureNotNull("Provided date", (Object)date);
        this.duedateLowerThanOrEqual = date;
        return this;
    }

    @Override
    public JobQuery priorityHigherThanOrEquals(long priority) {
        this.priorityHigherThanOrEqual = priority;
        return this;
    }

    @Override
    public JobQuery priorityLowerThanOrEquals(long priority) {
        this.priorityLowerThanOrEqual = priority;
        return this;
    }

    @Override
    public JobQuery withException() {
        this.withException = true;
        return this;
    }

    @Override
    public JobQuery exceptionMessage(String exceptionMessage) {
        EnsureUtil.ensureNotNull("Provided exception message", (Object)exceptionMessage);
        this.exceptionMessage = exceptionMessage;
        return this;
    }

    @Override
    public JobQuery noRetriesLeft() {
        this.noRetriesLeft = true;
        return this;
    }

    @Override
    public JobQuery active() {
        this.suspensionState = SuspensionState.ACTIVE;
        return this;
    }

    @Override
    public JobQuery suspended() {
        this.suspensionState = SuspensionState.SUSPENDED;
        return this;
    }

    @Override
    protected boolean hasExcludingConditions() {
        return super.hasExcludingConditions() || CompareUtil.areNotInAscendingOrder((Comparable[])new Long[]{this.priorityHigherThanOrEqual, this.priorityLowerThanOrEqual}) || this.hasExcludingDueDateParameters();
    }

    private boolean hasExcludingDueDateParameters() {
        ArrayList<Date> dueDates = new ArrayList<Date>();
        if (this.duedateHigherThan != null && this.duedateHigherThanOrEqual != null) {
            dueDates.add(CompareUtil.min(this.duedateHigherThan, this.duedateHigherThanOrEqual));
            dueDates.add(CompareUtil.max(this.duedateHigherThan, this.duedateHigherThanOrEqual));
        } else if (this.duedateHigherThan != null) {
            dueDates.add(this.duedateHigherThan);
        } else if (this.duedateHigherThanOrEqual != null) {
            dueDates.add(this.duedateHigherThanOrEqual);
        }
        if (this.duedateLowerThan != null && this.duedateLowerThanOrEqual != null) {
            dueDates.add(CompareUtil.min(this.duedateLowerThan, this.duedateLowerThanOrEqual));
            dueDates.add(CompareUtil.max(this.duedateLowerThan, this.duedateLowerThanOrEqual));
        } else if (this.duedateLowerThan != null) {
            dueDates.add(this.duedateLowerThan);
        } else if (this.duedateLowerThanOrEqual != null) {
            dueDates.add(this.duedateLowerThanOrEqual);
        }
        return CompareUtil.areNotInAscendingOrder(dueDates);
    }

    @Override
    public JobQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        return this;
    }

    @Override
    public JobQuery orderByJobDuedate() {
        return (JobQuery)this.orderBy(JobQueryProperty.DUEDATE);
    }

    @Override
    public JobQuery orderByExecutionId() {
        return (JobQuery)this.orderBy(JobQueryProperty.EXECUTION_ID);
    }

    @Override
    public JobQuery orderByJobId() {
        return (JobQuery)this.orderBy(JobQueryProperty.JOB_ID);
    }

    @Override
    public JobQuery orderByProcessInstanceId() {
        return (JobQuery)this.orderBy(JobQueryProperty.PROCESS_INSTANCE_ID);
    }

    @Override
    public JobQuery orderByProcessDefinitionId() {
        return (JobQuery)this.orderBy(JobQueryProperty.PROCESS_DEFINITION_ID);
    }

    @Override
    public JobQuery orderByProcessDefinitionKey() {
        return (JobQuery)this.orderBy(JobQueryProperty.PROCESS_DEFINITION_KEY);
    }

    @Override
    public JobQuery orderByJobRetries() {
        return (JobQuery)this.orderBy(JobQueryProperty.RETRIES);
    }

    @Override
    public JobQuery orderByJobPriority() {
        return (JobQuery)this.orderBy(JobQueryProperty.PRIORITY);
    }

    @Override
    public JobQuery orderByTenantId() {
        return (JobQuery)this.orderBy(JobQueryProperty.TENANT_ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getJobManager().findJobCountByQueryCriteria(this);
    }

    @Override
    public List<Job> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getJobManager().findJobsByQueryCriteria(this, page);
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public boolean getRetriesLeft() {
        return this.retriesLeft;
    }

    public boolean getExecutable() {
        return this.executable;
    }

    public Date getNow() {
        return ClockUtil.getCurrentTime();
    }

    public boolean isWithException() {
        return this.withException;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }
}

