/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.QueryOperator;
import org.camunda.bpm.engine.impl.TaskQueryProperty;
import org.camunda.bpm.engine.impl.TaskQueryVariableValue;
import org.camunda.bpm.engine.impl.VariableOrderProperty;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.CompositePermissionCheck;
import org.camunda.bpm.engine.impl.db.PermissionCheck;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.util.CompareUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.variable.serializer.VariableSerializers;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.variable.type.ValueType;

public class TaskQueryImpl
extends AbstractQuery<TaskQuery, Task>
implements TaskQuery {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String name;
    protected String nameLike;
    protected String description;
    protected String descriptionLike;
    protected Integer priority;
    protected Integer minPriority;
    protected Integer maxPriority;
    protected String assignee;
    protected String assigneeLike;
    protected String involvedUser;
    protected String owner;
    protected Boolean unassigned;
    protected boolean noDelegationState = false;
    protected DelegationState delegationState;
    protected String candidateUser;
    protected String candidateGroup;
    protected List<String> candidateGroups;
    protected Boolean includeAssignedTasks;
    protected String processInstanceId;
    protected String executionId;
    protected String[] activityInstanceIdIn;
    protected String[] tenantIds;
    protected Date createTime;
    protected Date createTimeBefore;
    protected Date createTimeAfter;
    protected String key;
    protected String keyLike;
    protected String[] taskDefinitionKeys;
    protected String processDefinitionKey;
    protected String[] processDefinitionKeys;
    protected String processDefinitionId;
    protected String processDefinitionName;
    protected String processDefinitionNameLike;
    protected String processInstanceBusinessKey;
    protected String[] processInstanceBusinessKeys;
    protected String processInstanceBusinessKeyLike;
    protected List<TaskQueryVariableValue> variables = new ArrayList<TaskQueryVariableValue>();
    protected Date dueDate;
    protected Date dueBefore;
    protected Date dueAfter;
    protected Date followUpDate;
    protected Date followUpBefore;
    protected boolean followUpNullAccepted = false;
    protected Date followUpAfter;
    protected boolean excludeSubtasks = false;
    protected SuspensionState suspensionState;
    protected boolean initializeFormKeys = false;
    protected boolean taskNameCaseInsensitive = false;
    protected String parentTaskId;
    protected String caseDefinitionKey;
    protected String caseDefinitionId;
    protected String caseDefinitionName;
    protected String caseDefinitionNameLike;
    protected String caseInstanceId;
    protected String caseInstanceBusinessKey;
    protected String caseInstanceBusinessKeyLike;
    protected String caseExecutionId;
    protected CompositePermissionCheck taskPermissionChecks = new CompositePermissionCheck();

    public TaskQueryImpl() {
    }

    public TaskQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public TaskQueryImpl taskId(String taskId) {
        EnsureUtil.ensureNotNull("Task id", (Object)taskId);
        this.taskId = taskId;
        return this;
    }

    @Override
    public TaskQueryImpl taskName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public TaskQueryImpl taskNameLike(String nameLike) {
        EnsureUtil.ensureNotNull("Task nameLike", (Object)nameLike);
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public TaskQueryImpl taskDescription(String description) {
        EnsureUtil.ensureNotNull("Description", (Object)description);
        this.description = description;
        return this;
    }

    @Override
    public TaskQuery taskDescriptionLike(String descriptionLike) {
        EnsureUtil.ensureNotNull("Task descriptionLike", (Object)descriptionLike);
        this.descriptionLike = descriptionLike;
        return this;
    }

    @Override
    public TaskQuery taskPriority(Integer priority) {
        EnsureUtil.ensureNotNull("Priority", (Object)priority);
        this.priority = priority;
        return this;
    }

    @Override
    public TaskQuery taskMinPriority(Integer minPriority) {
        EnsureUtil.ensureNotNull("Min Priority", (Object)minPriority);
        this.minPriority = minPriority;
        return this;
    }

    @Override
    public TaskQuery taskMaxPriority(Integer maxPriority) {
        EnsureUtil.ensureNotNull("Max Priority", (Object)maxPriority);
        this.maxPriority = maxPriority;
        return this;
    }

    @Override
    public TaskQueryImpl taskAssignee(String assignee) {
        EnsureUtil.ensureNotNull("Assignee", (Object)assignee);
        this.assignee = assignee;
        this.expressions.remove("taskAssignee");
        return this;
    }

    @Override
    public TaskQuery taskAssigneeExpression(String assigneeExpression) {
        EnsureUtil.ensureNotNull("Assignee expression", (Object)assigneeExpression);
        this.expressions.put("taskAssignee", assigneeExpression);
        return this;
    }

    @Override
    public TaskQuery taskAssigneeLike(String assignee) {
        EnsureUtil.ensureNotNull("Assignee", (Object)assignee);
        this.assigneeLike = assignee;
        this.expressions.remove("taskAssigneeLike");
        return this;
    }

    @Override
    public TaskQuery taskAssigneeLikeExpression(String assigneeLikeExpression) {
        EnsureUtil.ensureNotNull("Assignee like expression", (Object)assigneeLikeExpression);
        this.expressions.put("taskAssigneeLike", assigneeLikeExpression);
        return this;
    }

    @Override
    public TaskQueryImpl taskOwner(String owner) {
        EnsureUtil.ensureNotNull("Owner", (Object)owner);
        this.owner = owner;
        this.expressions.remove("taskOwner");
        return this;
    }

    @Override
    public TaskQuery taskOwnerExpression(String ownerExpression) {
        EnsureUtil.ensureNotNull("Owner expression", (Object)ownerExpression);
        this.expressions.put("taskOwner", ownerExpression);
        return this;
    }

    @Override
    @Deprecated
    public TaskQuery taskUnnassigned() {
        return this.taskUnassigned();
    }

    @Override
    public TaskQuery taskUnassigned() {
        this.unassigned = true;
        return this;
    }

    @Override
    public TaskQuery taskDelegationState(DelegationState delegationState) {
        if (delegationState == null) {
            this.noDelegationState = true;
        } else {
            this.delegationState = delegationState;
        }
        return this;
    }

    @Override
    public TaskQueryImpl taskCandidateUser(String candidateUser) {
        EnsureUtil.ensureNotNull("Candidate user", (Object)candidateUser);
        if (this.candidateGroup != null || this.expressions.containsKey("taskCandidateGroup")) {
            throw new ProcessEngineException("Invalid query usage: cannot set both candidateUser and candidateGroup");
        }
        if (this.candidateGroups != null || this.expressions.containsKey("taskCandidateGroupIn")) {
            throw new ProcessEngineException("Invalid query usage: cannot set both candidateUser and candidateGroupIn");
        }
        this.candidateUser = candidateUser;
        this.expressions.remove("taskCandidateUser");
        return this;
    }

    @Override
    public TaskQuery taskCandidateUserExpression(String candidateUserExpression) {
        EnsureUtil.ensureNotNull("Candidate user expression", (Object)candidateUserExpression);
        if (this.candidateGroup != null || this.expressions.containsKey("taskCandidateGroup")) {
            throw new ProcessEngineException("Invalid query usage: cannot set both candidateUser and candidateGroup");
        }
        if (this.candidateGroups != null || this.expressions.containsKey("taskCandidateGroupIn")) {
            throw new ProcessEngineException("Invalid query usage: cannot set both candidateUser and candidateGroupIn");
        }
        this.expressions.put("taskCandidateUser", candidateUserExpression);
        return this;
    }

    @Override
    public TaskQueryImpl taskInvolvedUser(String involvedUser) {
        EnsureUtil.ensureNotNull("Involved user", (Object)involvedUser);
        this.involvedUser = involvedUser;
        this.expressions.remove("taskInvolvedUser");
        return this;
    }

    @Override
    public TaskQuery taskInvolvedUserExpression(String involvedUserExpression) {
        EnsureUtil.ensureNotNull("Involved user expression", (Object)involvedUserExpression);
        this.expressions.put("taskInvolvedUser", involvedUserExpression);
        return this;
    }

    @Override
    public TaskQueryImpl taskCandidateGroup(String candidateGroup) {
        EnsureUtil.ensureNotNull("Candidate group", (Object)candidateGroup);
        if (this.candidateUser != null || this.expressions.containsKey("taskCandidateUser")) {
            throw new ProcessEngineException("Invalid query usage: cannot set both candidateGroup and candidateUser");
        }
        if (this.candidateGroups != null || this.expressions.containsKey("taskCandidateGroupIn")) {
            throw new ProcessEngineException("Invalid query usage: cannot set both candidateGroup and candidateGroupIn");
        }
        this.candidateGroup = candidateGroup;
        this.expressions.remove("taskCandidateGroup");
        return this;
    }

    @Override
    public TaskQuery taskCandidateGroupExpression(String candidateGroupExpression) {
        EnsureUtil.ensureNotNull("Candidate group expression", (Object)candidateGroupExpression);
        if (this.candidateUser != null || this.expressions.containsKey("taskCandidateUser")) {
            throw new ProcessEngineException("Invalid query usage: cannot set both candidateGroup and candidateUser");
        }
        if (this.candidateGroups != null || this.expressions.containsKey("taskCandidateGroupIn")) {
            throw new ProcessEngineException("Invalid query usage: cannot set both candidateGroup and candidateGroupIn");
        }
        this.expressions.put("taskCandidateGroup", candidateGroupExpression);
        return this;
    }

    @Override
    public TaskQuery taskCandidateGroupIn(List<String> candidateGroups) {
        EnsureUtil.ensureNotEmpty("Candidate group list", candidateGroups);
        if (this.candidateUser != null || this.expressions.containsKey("taskCandidateUser")) {
            throw new ProcessEngineException("Invalid query usage: cannot set both candidateGroupIn and candidateUser");
        }
        if (this.candidateGroup != null || this.expressions.containsKey("taskCandidateGroup")) {
            throw new ProcessEngineException("Invalid query usage: cannot set both candidateGroupIn and candidateGroup");
        }
        this.candidateGroups = candidateGroups;
        this.expressions.remove("taskCandidateGroupIn");
        return this;
    }

    @Override
    public TaskQuery taskCandidateGroupInExpression(String candidateGroupsExpression) {
        EnsureUtil.ensureNotEmpty("Candidate group list expression", candidateGroupsExpression);
        if (this.candidateUser != null || this.expressions.containsKey("taskCandidateUser")) {
            throw new ProcessEngineException("Invalid query usage: cannot set both candidateGroupIn and candidateUser");
        }
        if (this.candidateGroup != null || this.expressions.containsKey("taskCandidateGroup")) {
            throw new ProcessEngineException("Invalid query usage: cannot set both candidateGroupIn and candidateGroup");
        }
        this.expressions.put("taskCandidateGroupIn", candidateGroupsExpression);
        return this;
    }

    @Override
    public TaskQuery includeAssignedTasks() {
        if (!(this.candidateUser != null || this.candidateGroup != null || this.candidateGroups != null || this.expressions.containsKey("taskCandidateUser") || this.expressions.containsKey("taskCandidateGroup") || this.expressions.containsKey("taskCandidateGroupIn"))) {
            throw new ProcessEngineException("Invalid query usage: candidateUser, candidateGroup, candidateGroupIn has to be called before 'includeAssignedTasks'.");
        }
        this.includeAssignedTasks = true;
        return this;
    }

    public TaskQuery includeAssignedTasksInternal() {
        this.includeAssignedTasks = true;
        return this;
    }

    @Override
    public TaskQueryImpl processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public TaskQueryImpl processInstanceBusinessKey(String processInstanceBusinessKey) {
        this.processInstanceBusinessKey = processInstanceBusinessKey;
        return this;
    }

    @Override
    public TaskQuery processInstanceBusinessKeyIn(String ... processInstanceBusinessKeys) {
        this.processInstanceBusinessKeys = processInstanceBusinessKeys;
        return this;
    }

    @Override
    public TaskQuery processInstanceBusinessKeyLike(String processInstanceBusinessKey) {
        this.processInstanceBusinessKeyLike = processInstanceBusinessKey;
        return this;
    }

    @Override
    public TaskQueryImpl executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Override
    public TaskQuery activityInstanceIdIn(String ... activityInstanceIds) {
        this.activityInstanceIdIn = activityInstanceIds;
        return this;
    }

    @Override
    public TaskQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        return this;
    }

    @Override
    public TaskQueryImpl taskCreatedOn(Date createTime) {
        this.createTime = createTime;
        this.expressions.remove("taskCreatedOn");
        return this;
    }

    @Override
    public TaskQuery taskCreatedOnExpression(String createTimeExpression) {
        this.expressions.put("taskCreatedOn", createTimeExpression);
        return this;
    }

    @Override
    public TaskQuery taskCreatedBefore(Date before) {
        this.createTimeBefore = before;
        this.expressions.remove("taskCreatedBefore");
        return this;
    }

    @Override
    public TaskQuery taskCreatedBeforeExpression(String beforeExpression) {
        this.expressions.put("taskCreatedBefore", beforeExpression);
        return this;
    }

    @Override
    public TaskQuery taskCreatedAfter(Date after) {
        this.createTimeAfter = after;
        this.expressions.remove("taskCreatedAfter");
        return this;
    }

    @Override
    public TaskQuery taskCreatedAfterExpression(String afterExpression) {
        this.expressions.put("taskCreatedAfter", afterExpression);
        return this;
    }

    @Override
    public TaskQuery taskDefinitionKey(String key) {
        this.key = key;
        return this;
    }

    @Override
    public TaskQuery taskDefinitionKeyLike(String keyLike) {
        this.keyLike = keyLike;
        return this;
    }

    @Override
    public TaskQuery taskDefinitionKeyIn(String ... taskDefinitionKeys) {
        this.taskDefinitionKeys = taskDefinitionKeys;
        return this;
    }

    @Override
    public TaskQuery taskParentTaskId(String taskParentTaskId) {
        this.parentTaskId = taskParentTaskId;
        return this;
    }

    @Override
    public TaskQuery caseInstanceId(String caseInstanceId) {
        EnsureUtil.ensureNotNull("caseInstanceId", (Object)caseInstanceId);
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Override
    public TaskQuery caseInstanceBusinessKey(String caseInstanceBusinessKey) {
        EnsureUtil.ensureNotNull("caseInstanceBusinessKey", (Object)caseInstanceBusinessKey);
        this.caseInstanceBusinessKey = caseInstanceBusinessKey;
        return this;
    }

    @Override
    public TaskQuery caseInstanceBusinessKeyLike(String caseInstanceBusinessKeyLike) {
        EnsureUtil.ensureNotNull("caseInstanceBusinessKeyLike", (Object)caseInstanceBusinessKeyLike);
        this.caseInstanceBusinessKeyLike = caseInstanceBusinessKeyLike;
        return this;
    }

    @Override
    public TaskQuery caseExecutionId(String caseExecutionId) {
        EnsureUtil.ensureNotNull("caseExecutionId", (Object)caseExecutionId);
        this.caseExecutionId = caseExecutionId;
        return this;
    }

    @Override
    public TaskQuery caseDefinitionId(String caseDefinitionId) {
        EnsureUtil.ensureNotNull("caseDefinitionId", (Object)caseDefinitionId);
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    @Override
    public TaskQuery caseDefinitionKey(String caseDefinitionKey) {
        EnsureUtil.ensureNotNull("caseDefinitionKey", (Object)caseDefinitionKey);
        this.caseDefinitionKey = caseDefinitionKey;
        return this;
    }

    @Override
    public TaskQuery caseDefinitionName(String caseDefinitionName) {
        EnsureUtil.ensureNotNull("caseDefinitionName", (Object)caseDefinitionName);
        this.caseDefinitionName = caseDefinitionName;
        return this;
    }

    @Override
    public TaskQuery caseDefinitionNameLike(String caseDefinitionNameLike) {
        EnsureUtil.ensureNotNull("caseDefinitionNameLike", (Object)caseDefinitionNameLike);
        this.caseDefinitionNameLike = caseDefinitionNameLike;
        return this;
    }

    @Override
    public TaskQuery taskVariableValueEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.EQUALS, true, false);
        return this;
    }

    @Override
    public TaskQuery taskVariableValueNotEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.NOT_EQUALS, true, false);
        return this;
    }

    @Override
    public TaskQuery taskVariableValueLike(String variableName, String variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.LIKE, true, false);
        return this;
    }

    @Override
    public TaskQuery taskVariableValueGreaterThan(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.GREATER_THAN, true, false);
        return this;
    }

    @Override
    public TaskQuery taskVariableValueGreaterThanOrEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.GREATER_THAN_OR_EQUAL, true, false);
        return this;
    }

    @Override
    public TaskQuery taskVariableValueLessThan(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.LESS_THAN, true, false);
        return this;
    }

    @Override
    public TaskQuery taskVariableValueLessThanOrEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.LESS_THAN_OR_EQUAL, true, false);
        return this;
    }

    @Override
    public TaskQuery processVariableValueEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.EQUALS, false, true);
        return this;
    }

    @Override
    public TaskQuery processVariableValueNotEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.NOT_EQUALS, false, true);
        return this;
    }

    @Override
    public TaskQuery processVariableValueLike(String variableName, String variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.LIKE, false, true);
        return this;
    }

    @Override
    public TaskQuery processVariableValueGreaterThan(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.GREATER_THAN, false, true);
        return this;
    }

    @Override
    public TaskQuery processVariableValueGreaterThanOrEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.GREATER_THAN_OR_EQUAL, false, true);
        return this;
    }

    @Override
    public TaskQuery processVariableValueLessThan(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.LESS_THAN, false, true);
        return this;
    }

    @Override
    public TaskQuery processVariableValueLessThanOrEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.LESS_THAN_OR_EQUAL, false, true);
        return this;
    }

    @Override
    public TaskQuery caseInstanceVariableValueEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.EQUALS, false, false);
        return this;
    }

    @Override
    public TaskQuery caseInstanceVariableValueNotEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.NOT_EQUALS, false, false);
        return this;
    }

    @Override
    public TaskQuery caseInstanceVariableValueLike(String variableName, String variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.LIKE, false, false);
        return this;
    }

    @Override
    public TaskQuery caseInstanceVariableValueGreaterThan(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.GREATER_THAN, false, false);
        return this;
    }

    @Override
    public TaskQuery caseInstanceVariableValueGreaterThanOrEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.GREATER_THAN_OR_EQUAL, false, false);
        return this;
    }

    @Override
    public TaskQuery caseInstanceVariableValueLessThan(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.LESS_THAN, false, false);
        return this;
    }

    @Override
    public TaskQuery caseInstanceVariableValueLessThanOrEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.LESS_THAN_OR_EQUAL, false, false);
        return this;
    }

    @Override
    public TaskQuery processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public TaskQuery processDefinitionKeyIn(String ... processDefinitionKeys) {
        this.processDefinitionKeys = processDefinitionKeys;
        return this;
    }

    @Override
    public TaskQuery processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public TaskQuery processDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
        return this;
    }

    @Override
    public TaskQuery processDefinitionNameLike(String processDefinitionName) {
        this.processDefinitionNameLike = processDefinitionName;
        return this;
    }

    @Override
    public TaskQuery dueDate(Date dueDate) {
        this.dueDate = dueDate;
        this.expressions.remove("dueDate");
        return this;
    }

    @Override
    public TaskQuery dueDateExpression(String dueDateExpression) {
        this.expressions.put("dueDate", dueDateExpression);
        return this;
    }

    @Override
    public TaskQuery dueBefore(Date dueBefore) {
        this.dueBefore = dueBefore;
        this.expressions.remove("dueBefore");
        return this;
    }

    @Override
    public TaskQuery dueBeforeExpression(String dueDate) {
        this.expressions.put("dueBefore", dueDate);
        return this;
    }

    @Override
    public TaskQuery dueAfter(Date dueAfter) {
        this.dueAfter = dueAfter;
        this.expressions.remove("dueAfter");
        return this;
    }

    @Override
    public TaskQuery dueAfterExpression(String dueDateExpression) {
        this.expressions.put("dueAfter", dueDateExpression);
        return this;
    }

    @Override
    public TaskQuery followUpDate(Date followUpDate) {
        this.followUpDate = followUpDate;
        this.expressions.remove("followUpDate");
        return this;
    }

    @Override
    public TaskQuery followUpDateExpression(String followUpDateExpression) {
        this.expressions.put("followUpDate", followUpDateExpression);
        return this;
    }

    @Override
    public TaskQuery followUpBefore(Date followUpBefore) {
        this.followUpBefore = followUpBefore;
        this.followUpNullAccepted = false;
        this.expressions.remove("followUpBefore");
        return this;
    }

    @Override
    public TaskQuery followUpBeforeExpression(String followUpBeforeExpression) {
        this.followUpNullAccepted = false;
        this.expressions.put("followUpBefore", followUpBeforeExpression);
        return this;
    }

    @Override
    public TaskQuery followUpBeforeOrNotExistent(Date followUpDate) {
        this.followUpBefore = followUpDate;
        this.followUpNullAccepted = true;
        this.expressions.remove("followUpBeforeOrNotExistent");
        return this;
    }

    @Override
    public TaskQuery followUpBeforeOrNotExistentExpression(String followUpDateExpression) {
        this.expressions.put("followUpBeforeOrNotExistent", followUpDateExpression);
        this.followUpNullAccepted = true;
        return this;
    }

    public void setFollowUpNullAccepted(boolean followUpNullAccepted) {
        this.followUpNullAccepted = followUpNullAccepted;
    }

    @Override
    public TaskQuery followUpAfter(Date followUpAfter) {
        this.followUpAfter = followUpAfter;
        this.expressions.remove("followUpAfter");
        return this;
    }

    @Override
    public TaskQuery followUpAfterExpression(String followUpAfterExpression) {
        this.expressions.put("followUpAfter", followUpAfterExpression);
        return this;
    }

    @Override
    public TaskQuery excludeSubtasks() {
        this.excludeSubtasks = true;
        return this;
    }

    @Override
    public TaskQuery active() {
        this.suspensionState = SuspensionState.ACTIVE;
        return this;
    }

    @Override
    public TaskQuery suspended() {
        this.suspensionState = SuspensionState.SUSPENDED;
        return this;
    }

    @Override
    public TaskQuery initializeFormKeys() {
        this.initializeFormKeys = true;
        return this;
    }

    public TaskQuery taskNameCaseInsensitive() {
        this.taskNameCaseInsensitive = true;
        return this;
    }

    @Override
    protected boolean hasExcludingConditions() {
        return super.hasExcludingConditions() || CompareUtil.areNotInAscendingOrder((Comparable[])new Integer[]{this.minPriority, this.priority, this.maxPriority}) || CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{this.dueAfter, this.dueDate, this.dueBefore}) || CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{this.followUpAfter, this.followUpDate, this.followUpBefore}) || CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{this.createTimeAfter, this.createTime, this.createTimeBefore}) || CompareUtil.elementIsNotContainedInArray(this.key, this.taskDefinitionKeys) || CompareUtil.elementIsNotContainedInArray(this.processDefinitionKey, this.processDefinitionKeys) || CompareUtil.elementIsNotContainedInArray(this.processInstanceBusinessKey, this.processInstanceBusinessKeys);
    }

    public List<String> getCandidateGroups() {
        if (this.candidateGroup != null) {
            return Collections.singletonList(this.candidateGroup);
        }
        if (this.candidateUser != null) {
            return this.getGroupsForCandidateUser(this.candidateUser);
        }
        if (this.candidateGroups != null) {
            return this.candidateGroups;
        }
        return null;
    }

    public List<String> getCandidateGroupsInternal() {
        return this.candidateGroups;
    }

    protected List<String> getGroupsForCandidateUser(String candidateUser) {
        List groups = Context.getCommandContext().getReadOnlyIdentityProvider().createGroupQuery().groupMember(candidateUser).list();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    protected void ensureVariablesInitialized() {
        VariableSerializers types = Context.getProcessEngineConfiguration().getVariableSerializers();
        for (TaskQueryVariableValue var : this.variables) {
            var.initialize(types);
        }
    }

    public void addVariable(String name, Object value, QueryOperator operator, boolean isTaskVariable, boolean isProcessInstanceVariable) {
        EnsureUtil.ensureNotNull("name", (Object)name);
        if (value == null || this.isBoolean(value)) {
            switch (operator) {
                case GREATER_THAN: {
                    throw new ProcessEngineException("Booleans and null cannot be used in 'greater than' condition");
                }
                case LESS_THAN: {
                    throw new ProcessEngineException("Booleans and null cannot be used in 'less than' condition");
                }
                case GREATER_THAN_OR_EQUAL: {
                    throw new ProcessEngineException("Booleans and null cannot be used in 'greater than or equal' condition");
                }
                case LESS_THAN_OR_EQUAL: {
                    throw new ProcessEngineException("Booleans and null cannot be used in 'less than or equal' condition");
                }
                case LIKE: {
                    throw new ProcessEngineException("Booleans and null cannot be used in 'like' condition");
                }
            }
        }
        this.addVariable(new TaskQueryVariableValue(name, value, operator, isTaskVariable, isProcessInstanceVariable));
    }

    protected void addVariable(TaskQueryVariableValue taskQueryVariableValue) {
        this.variables.add(taskQueryVariableValue);
    }

    private boolean isBoolean(Object value) {
        if (value == null) {
            return false;
        }
        return Boolean.class.isAssignableFrom(value.getClass()) || Boolean.TYPE.isAssignableFrom(value.getClass());
    }

    @Override
    public TaskQuery orderByTaskId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.TASK_ID);
    }

    @Override
    public TaskQuery orderByTaskName() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.NAME);
    }

    @Override
    public TaskQuery orderByTaskNameCaseInsensitive() {
        this.taskNameCaseInsensitive();
        return (TaskQuery)this.orderBy(TaskQueryProperty.NAME_CASE_INSENSITIVE);
    }

    @Override
    public TaskQuery orderByTaskDescription() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.DESCRIPTION);
    }

    @Override
    public TaskQuery orderByTaskPriority() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.PRIORITY);
    }

    @Override
    public TaskQuery orderByProcessInstanceId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.PROCESS_INSTANCE_ID);
    }

    @Override
    public TaskQuery orderByCaseInstanceId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.CASE_INSTANCE_ID);
    }

    @Override
    public TaskQuery orderByExecutionId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.EXECUTION_ID);
    }

    @Override
    public TaskQuery orderByTenantId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.TENANT_ID);
    }

    @Override
    public TaskQuery orderByCaseExecutionId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.CASE_EXECUTION_ID);
    }

    @Override
    public TaskQuery orderByTaskAssignee() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.ASSIGNEE);
    }

    @Override
    public TaskQuery orderByTaskCreateTime() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.CREATE_TIME);
    }

    @Override
    public TaskQuery orderByDueDate() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.DUE_DATE);
    }

    @Override
    public TaskQuery orderByFollowUpDate() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.FOLLOW_UP_DATE);
    }

    @Override
    public TaskQuery orderByProcessVariable(String variableName, ValueType valueType) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        EnsureUtil.ensureNotNull("valueType", (Object)valueType);
        this.orderBy(VariableOrderProperty.forProcessInstanceVariable(variableName, valueType));
        return this;
    }

    @Override
    public TaskQuery orderByExecutionVariable(String variableName, ValueType valueType) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        EnsureUtil.ensureNotNull("valueType", (Object)valueType);
        this.orderBy(VariableOrderProperty.forExecutionVariable(variableName, valueType));
        return this;
    }

    @Override
    public TaskQuery orderByTaskVariable(String variableName, ValueType valueType) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        EnsureUtil.ensureNotNull("valueType", (Object)valueType);
        this.orderBy(VariableOrderProperty.forTaskVariable(variableName, valueType));
        return this;
    }

    @Override
    public TaskQuery orderByCaseExecutionVariable(String variableName, ValueType valueType) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        EnsureUtil.ensureNotNull("valueType", (Object)valueType);
        this.orderBy(VariableOrderProperty.forCaseExecutionVariable(variableName, valueType));
        return this;
    }

    @Override
    public TaskQuery orderByCaseInstanceVariable(String variableName, ValueType valueType) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        EnsureUtil.ensureNotNull("valueType", (Object)valueType);
        this.orderBy(VariableOrderProperty.forCaseInstanceVariable(variableName, valueType));
        return this;
    }

    @Override
    public List<Task> executeList(CommandContext commandContext, Page page) {
        this.ensureVariablesInitialized();
        this.checkQueryOk();
        List<Task> taskList = commandContext.getTaskManager().findTasksByQueryCriteria(this);
        if (this.initializeFormKeys) {
            for (Task task : taskList) {
                ((TaskEntity)task).initializeFormKey();
            }
        }
        return taskList;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        this.checkQueryOk();
        return commandContext.getTaskManager().findTaskCountByQueryCriteria(this);
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public String getAssigneeLike() {
        return this.assigneeLike;
    }

    public String getInvolvedUser() {
        return this.involvedUser;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean isUnassigned() {
        if (this.unassigned == null) {
            return false;
        }
        return this.unassigned;
    }

    public Boolean isUnassignedInternal() {
        return this.unassigned;
    }

    public DelegationState getDelegationState() {
        return this.delegationState;
    }

    public boolean isNoDelegationState() {
        return this.noDelegationState;
    }

    public String getDelegationStateString() {
        return this.delegationState != null ? this.delegationState.toString() : null;
    }

    public String getCandidateUser() {
        return this.candidateUser;
    }

    public String getCandidateGroup() {
        return this.candidateGroup;
    }

    public boolean isIncludeAssignedTasks() {
        return this.includeAssignedTasks != null ? this.includeAssignedTasks : false;
    }

    public Boolean isIncludeAssignedTasksInternal() {
        return this.includeAssignedTasks;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String[] getActivityInstanceIdIn() {
        return this.activityInstanceIdIn;
    }

    public String[] getTenantIds() {
        return this.tenantIds;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionLike() {
        return this.descriptionLike;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Integer getMinPriority() {
        return this.minPriority;
    }

    public Integer getMaxPriority() {
        return this.maxPriority;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getCreateTimeBefore() {
        return this.createTimeBefore;
    }

    public Date getCreateTimeAfter() {
        return this.createTimeAfter;
    }

    public String getKey() {
        return this.key;
    }

    public String[] getKeys() {
        return this.taskDefinitionKeys;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public List<TaskQueryVariableValue> getVariables() {
        return this.variables;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String[] getProcessDefinitionKeys() {
        return this.processDefinitionKeys;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public String getProcessDefinitionNameLike() {
        return this.processDefinitionNameLike;
    }

    public String getProcessInstanceBusinessKey() {
        return this.processInstanceBusinessKey;
    }

    public String[] getProcessInstanceBusinessKeys() {
        return this.processInstanceBusinessKeys;
    }

    public String getProcessInstanceBusinessKeyLike() {
        return this.processInstanceBusinessKeyLike;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public Date getDueBefore() {
        return this.dueBefore;
    }

    public Date getDueAfter() {
        return this.dueAfter;
    }

    public Date getFollowUpDate() {
        return this.followUpDate;
    }

    public Date getFollowUpBefore() {
        return this.followUpBefore;
    }

    public Date getFollowUpAfter() {
        return this.followUpAfter;
    }

    public boolean isExcludeSubtasks() {
        return this.excludeSubtasks;
    }

    public SuspensionState getSuspensionState() {
        return this.suspensionState;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getCaseInstanceBusinessKey() {
        return this.caseInstanceBusinessKey;
    }

    public String getCaseInstanceBusinessKeyLike() {
        return this.caseInstanceBusinessKeyLike;
    }

    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public String getCaseDefinitionName() {
        return this.caseDefinitionName;
    }

    public String getCaseDefinitionNameLike() {
        return this.caseDefinitionNameLike;
    }

    public boolean isInitializeFormKeys() {
        return this.initializeFormKeys;
    }

    public boolean isTaskNameCaseInsensitive() {
        return this.taskNameCaseInsensitive;
    }

    @Override
    public TaskQuery extend(TaskQuery extending) {
        TaskQueryImpl extendingQuery = (TaskQueryImpl)extending;
        TaskQueryImpl extendedQuery = new TaskQueryImpl();
        extendedQuery.validators = new HashSet(this.validators);
        if (extendingQuery.getName() != null) {
            extendedQuery.taskName(extendingQuery.getName());
        } else if (this.getName() != null) {
            extendedQuery.taskName(this.getName());
        }
        if (extendingQuery.getNameLike() != null) {
            extendedQuery.taskNameLike(extendingQuery.getNameLike());
        } else if (this.getNameLike() != null) {
            extendedQuery.taskNameLike(this.getNameLike());
        }
        if (extendingQuery.getAssignee() != null) {
            extendedQuery.taskAssignee(extendingQuery.getAssignee());
        } else if (this.getAssignee() != null) {
            extendedQuery.taskAssignee(this.getAssignee());
        }
        if (extendingQuery.getAssigneeLike() != null) {
            extendedQuery.taskAssigneeLike(extendingQuery.getAssigneeLike());
        } else if (this.getAssigneeLike() != null) {
            extendedQuery.taskAssigneeLike(this.getAssigneeLike());
        }
        if (extendingQuery.getInvolvedUser() != null) {
            extendedQuery.taskInvolvedUser(extendingQuery.getInvolvedUser());
        } else if (this.getInvolvedUser() != null) {
            extendedQuery.taskInvolvedUser(this.getInvolvedUser());
        }
        if (extendingQuery.getOwner() != null) {
            extendedQuery.taskOwner(extendingQuery.getOwner());
        } else if (this.getOwner() != null) {
            extendedQuery.taskOwner(this.getOwner());
        }
        if (extendingQuery.isUnassigned() || this.isUnassigned()) {
            extendedQuery.taskUnassigned();
        }
        if (extendingQuery.getDelegationState() != null) {
            extendedQuery.taskDelegationState(extendingQuery.getDelegationState());
        } else if (this.getDelegationState() != null) {
            extendedQuery.taskDelegationState(this.getDelegationState());
        }
        if (extendingQuery.getCandidateUser() != null) {
            extendedQuery.taskCandidateUser(extendingQuery.getCandidateUser());
        } else if (this.getCandidateUser() != null) {
            extendedQuery.taskCandidateUser(this.getCandidateUser());
        }
        if (extendingQuery.getCandidateGroup() != null) {
            extendedQuery.taskCandidateGroup(extendingQuery.getCandidateGroup());
        } else if (this.getCandidateGroup() != null) {
            extendedQuery.taskCandidateGroup(this.getCandidateGroup());
        }
        if (extendingQuery.getCandidateGroupsInternal() != null) {
            extendedQuery.taskCandidateGroupIn(extendingQuery.getCandidateGroupsInternal());
        } else if (this.getCandidateGroupsInternal() != null) {
            extendedQuery.taskCandidateGroupIn(this.getCandidateGroupsInternal());
        }
        if (extendingQuery.getProcessInstanceId() != null) {
            extendedQuery.processInstanceId(extendingQuery.getProcessInstanceId());
        } else if (this.getProcessInstanceId() != null) {
            extendedQuery.processInstanceId(this.getProcessInstanceId());
        }
        if (extendingQuery.getExecutionId() != null) {
            extendedQuery.executionId(extendingQuery.getExecutionId());
        } else if (this.getExecutionId() != null) {
            extendedQuery.executionId(this.getExecutionId());
        }
        if (extendingQuery.getActivityInstanceIdIn() != null) {
            extendedQuery.activityInstanceIdIn(extendingQuery.getActivityInstanceIdIn());
        } else if (this.getActivityInstanceIdIn() != null) {
            extendedQuery.activityInstanceIdIn(this.getActivityInstanceIdIn());
        }
        if (extendingQuery.getTaskId() != null) {
            extendedQuery.taskId(extendingQuery.getTaskId());
        } else if (this.getTaskId() != null) {
            extendedQuery.taskId(this.getTaskId());
        }
        if (extendingQuery.getDescription() != null) {
            extendedQuery.taskDescription(extendingQuery.getDescription());
        } else if (this.getDescription() != null) {
            extendedQuery.taskDescription(this.getDescription());
        }
        if (extendingQuery.getDescriptionLike() != null) {
            extendedQuery.taskDescriptionLike(extendingQuery.getDescriptionLike());
        } else if (this.getDescriptionLike() != null) {
            extendedQuery.taskDescriptionLike(this.getDescriptionLike());
        }
        if (extendingQuery.getPriority() != null) {
            extendedQuery.taskPriority(extendingQuery.getPriority());
        } else if (this.getPriority() != null) {
            extendedQuery.taskPriority(this.getPriority());
        }
        if (extendingQuery.getMinPriority() != null) {
            extendedQuery.taskMinPriority(extendingQuery.getMinPriority());
        } else if (this.getMinPriority() != null) {
            extendedQuery.taskMinPriority(this.getMinPriority());
        }
        if (extendingQuery.getMaxPriority() != null) {
            extendedQuery.taskMaxPriority(extendingQuery.getMaxPriority());
        } else if (this.getMaxPriority() != null) {
            extendedQuery.taskMaxPriority(this.getMaxPriority());
        }
        if (extendingQuery.getCreateTime() != null) {
            extendedQuery.taskCreatedOn(extendingQuery.getCreateTime());
        } else if (this.getCreateTime() != null) {
            extendedQuery.taskCreatedOn(this.getCreateTime());
        }
        if (extendingQuery.getCreateTimeBefore() != null) {
            extendedQuery.taskCreatedBefore(extendingQuery.getCreateTimeBefore());
        } else if (this.getCreateTimeBefore() != null) {
            extendedQuery.taskCreatedBefore(this.getCreateTimeBefore());
        }
        if (extendingQuery.getCreateTimeAfter() != null) {
            extendedQuery.taskCreatedAfter(extendingQuery.getCreateTimeAfter());
        } else if (this.getCreateTimeAfter() != null) {
            extendedQuery.taskCreatedAfter(this.getCreateTimeAfter());
        }
        if (extendingQuery.getKey() != null) {
            extendedQuery.taskDefinitionKey(extendingQuery.getKey());
        } else if (this.getKey() != null) {
            extendedQuery.taskDefinitionKey(this.getKey());
        }
        if (extendingQuery.getKeyLike() != null) {
            extendedQuery.taskDefinitionKeyLike(extendingQuery.getKeyLike());
        } else if (this.getKeyLike() != null) {
            extendedQuery.taskDefinitionKeyLike(this.getKeyLike());
        }
        if (extendingQuery.getKeys() != null) {
            extendedQuery.taskDefinitionKeyIn(extendingQuery.getKeys());
        } else if (this.getKeys() != null) {
            extendedQuery.taskDefinitionKeyIn(this.getKeys());
        }
        if (extendingQuery.getParentTaskId() != null) {
            extendedQuery.taskParentTaskId(extendingQuery.getParentTaskId());
        } else if (this.getParentTaskId() != null) {
            extendedQuery.taskParentTaskId(this.getParentTaskId());
        }
        if (extendingQuery.getProcessDefinitionKey() != null) {
            extendedQuery.processDefinitionKey(extendingQuery.getProcessDefinitionKey());
        } else if (this.getProcessDefinitionKey() != null) {
            extendedQuery.processDefinitionKey(this.getProcessDefinitionKey());
        }
        if (extendingQuery.getProcessDefinitionKeys() != null) {
            extendedQuery.processDefinitionKeyIn(extendingQuery.getProcessDefinitionKeys());
        } else if (this.getProcessDefinitionKeys() != null) {
            extendedQuery.processDefinitionKeyIn(this.getProcessDefinitionKeys());
        }
        if (extendingQuery.getProcessDefinitionId() != null) {
            extendedQuery.processDefinitionId(extendingQuery.getProcessDefinitionId());
        } else if (this.getProcessDefinitionId() != null) {
            extendedQuery.processDefinitionId(this.getProcessDefinitionId());
        }
        if (extendingQuery.getProcessDefinitionName() != null) {
            extendedQuery.processDefinitionName(extendingQuery.getProcessDefinitionName());
        } else if (this.getProcessDefinitionName() != null) {
            extendedQuery.processDefinitionName(this.getProcessDefinitionName());
        }
        if (extendingQuery.getProcessDefinitionNameLike() != null) {
            extendedQuery.processDefinitionNameLike(extendingQuery.getProcessDefinitionNameLike());
        } else if (this.getProcessDefinitionNameLike() != null) {
            extendedQuery.processDefinitionNameLike(this.getProcessDefinitionNameLike());
        }
        if (extendingQuery.getProcessInstanceBusinessKey() != null) {
            extendedQuery.processInstanceBusinessKey(extendingQuery.getProcessInstanceBusinessKey());
        } else if (this.getProcessInstanceBusinessKey() != null) {
            extendedQuery.processInstanceBusinessKey(this.getProcessInstanceBusinessKey());
        }
        if (extendingQuery.getProcessInstanceBusinessKeyLike() != null) {
            extendedQuery.processInstanceBusinessKeyLike(extendingQuery.getProcessInstanceBusinessKeyLike());
        } else if (this.getProcessInstanceBusinessKeyLike() != null) {
            extendedQuery.processInstanceBusinessKeyLike(this.getProcessInstanceBusinessKeyLike());
        }
        if (extendingQuery.getDueDate() != null) {
            extendedQuery.dueDate(extendingQuery.getDueDate());
        } else if (this.getDueDate() != null) {
            extendedQuery.dueDate(this.getDueDate());
        }
        if (extendingQuery.getDueBefore() != null) {
            extendedQuery.dueBefore(extendingQuery.getDueBefore());
        } else if (this.getDueBefore() != null) {
            extendedQuery.dueBefore(this.getDueBefore());
        }
        if (extendingQuery.getDueAfter() != null) {
            extendedQuery.dueAfter(extendingQuery.getDueAfter());
        } else if (this.getDueAfter() != null) {
            extendedQuery.dueAfter(this.getDueAfter());
        }
        if (extendingQuery.getFollowUpDate() != null) {
            extendedQuery.followUpDate(extendingQuery.getFollowUpDate());
        } else if (this.getFollowUpDate() != null) {
            extendedQuery.followUpDate(this.getFollowUpDate());
        }
        if (extendingQuery.getFollowUpBefore() != null) {
            extendedQuery.followUpBefore(extendingQuery.getFollowUpBefore());
        } else if (this.getFollowUpBefore() != null) {
            extendedQuery.followUpBefore(this.getFollowUpBefore());
        }
        if (extendingQuery.getFollowUpAfter() != null) {
            extendedQuery.followUpAfter(extendingQuery.getFollowUpAfter());
        } else if (this.getFollowUpAfter() != null) {
            extendedQuery.followUpAfter(this.getFollowUpAfter());
        }
        if (extendingQuery.isFollowUpNullAccepted() || this.isFollowUpNullAccepted()) {
            extendedQuery.setFollowUpNullAccepted(true);
        }
        if (extendingQuery.isExcludeSubtasks() || this.isExcludeSubtasks()) {
            extendedQuery.excludeSubtasks();
        }
        if (extendingQuery.getSuspensionState() != null) {
            if (extendingQuery.getSuspensionState().equals(SuspensionState.ACTIVE)) {
                extendedQuery.active();
            } else if (extendingQuery.getSuspensionState().equals(SuspensionState.SUSPENDED)) {
                extendedQuery.suspended();
            }
        } else if (this.getSuspensionState() != null) {
            if (this.getSuspensionState().equals(SuspensionState.ACTIVE)) {
                extendedQuery.active();
            } else if (this.getSuspensionState().equals(SuspensionState.SUSPENDED)) {
                extendedQuery.suspended();
            }
        }
        if (extendingQuery.getCaseInstanceId() != null) {
            extendedQuery.caseInstanceId(extendingQuery.getCaseInstanceId());
        } else if (this.getCaseInstanceId() != null) {
            extendedQuery.caseInstanceId(this.getCaseInstanceId());
        }
        if (extendingQuery.getCaseInstanceBusinessKey() != null) {
            extendedQuery.caseInstanceBusinessKey(extendingQuery.getCaseInstanceBusinessKey());
        } else if (this.getCaseInstanceBusinessKey() != null) {
            extendedQuery.caseInstanceBusinessKey(this.getCaseInstanceBusinessKey());
        }
        if (extendingQuery.getCaseInstanceBusinessKeyLike() != null) {
            extendedQuery.caseInstanceBusinessKeyLike(extendingQuery.getCaseInstanceBusinessKeyLike());
        } else if (this.getCaseInstanceBusinessKeyLike() != null) {
            extendedQuery.caseInstanceBusinessKeyLike(this.getCaseInstanceBusinessKeyLike());
        }
        if (extendingQuery.getCaseExecutionId() != null) {
            extendedQuery.caseExecutionId(extendingQuery.getCaseExecutionId());
        } else if (this.getCaseExecutionId() != null) {
            extendedQuery.caseExecutionId(this.getCaseExecutionId());
        }
        if (extendingQuery.getCaseDefinitionId() != null) {
            extendedQuery.caseDefinitionId(extendingQuery.getCaseDefinitionId());
        } else if (this.getCaseDefinitionId() != null) {
            extendedQuery.caseDefinitionId(this.getCaseDefinitionId());
        }
        if (extendingQuery.getCaseDefinitionKey() != null) {
            extendedQuery.caseDefinitionKey(extendingQuery.getCaseDefinitionKey());
        } else if (this.getCaseDefinitionKey() != null) {
            extendedQuery.caseDefinitionKey(this.getCaseDefinitionKey());
        }
        if (extendingQuery.getCaseDefinitionName() != null) {
            extendedQuery.caseDefinitionName(extendingQuery.getCaseDefinitionName());
        } else if (this.getCaseDefinitionName() != null) {
            extendedQuery.caseDefinitionName(this.getCaseDefinitionName());
        }
        if (extendingQuery.getCaseDefinitionNameLike() != null) {
            extendedQuery.caseDefinitionNameLike(extendingQuery.getCaseDefinitionNameLike());
        } else if (this.getCaseDefinitionNameLike() != null) {
            extendedQuery.caseDefinitionNameLike(this.getCaseDefinitionNameLike());
        }
        if (extendingQuery.isInitializeFormKeys() || this.isInitializeFormKeys()) {
            extendedQuery.initializeFormKeys();
        }
        if (extendingQuery.isTaskNameCaseInsensitive() || this.isTaskNameCaseInsensitive()) {
            extendedQuery.taskNameCaseInsensitive();
        }
        this.mergeVariables(extendedQuery, extendingQuery);
        this.mergeExpressions(extendedQuery, extendingQuery);
        if (extendingQuery.isIncludeAssignedTasks() || this.isIncludeAssignedTasks()) {
            extendedQuery.includeAssignedTasks();
        }
        this.mergeOrdering(extendedQuery, extendingQuery);
        return extendedQuery;
    }

    protected void mergeVariables(TaskQueryImpl extendedQuery, TaskQueryImpl extendingQuery) {
        List<TaskQueryVariableValue> extendingVariables = extendingQuery.getVariables();
        HashSet<TaskQueryVariableValueComparable> extendingVariablesComparable = new HashSet<TaskQueryVariableValueComparable>();
        for (TaskQueryVariableValue extendingVariable : extendingVariables) {
            extendedQuery.addVariable(extendingVariable);
            extendingVariablesComparable.add(new TaskQueryVariableValueComparable(extendingVariable));
        }
        for (TaskQueryVariableValue originalVariable : this.getVariables()) {
            if (extendingVariablesComparable.contains(new TaskQueryVariableValueComparable(originalVariable))) continue;
            extendedQuery.addVariable(originalVariable);
        }
    }

    public boolean isFollowUpNullAccepted() {
        return this.followUpNullAccepted;
    }

    public CompositePermissionCheck getTaskPermissionChecks() {
        return this.taskPermissionChecks;
    }

    public void setTaskPermissionChecks(List<PermissionCheck> taskPermissionChecks) {
        this.taskPermissionChecks.setAtomicChecks(taskPermissionChecks);
    }

    public void addTaskPermissionCheck(PermissionCheck permissionCheck) {
        this.taskPermissionChecks.addAtomicCheck(permissionCheck);
    }

    protected class TaskQueryVariableValueComparable {
        protected TaskQueryVariableValue variableValue;

        public TaskQueryVariableValueComparable(TaskQueryVariableValue variableValue) {
            this.variableValue = variableValue;
        }

        public TaskQueryVariableValue getVariableValue() {
            return this.variableValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskQueryVariableValue other = ((TaskQueryVariableValueComparable)o).getVariableValue();
            return this.variableValue.getName().equals(other.getName()) && this.variableValue.isProcessInstanceVariable() == other.isProcessInstanceVariable() && this.variableValue.isLocal() == other.isLocal();
        }

        public int hashCode() {
            int result = this.variableValue.getName() != null ? this.variableValue.getName().hashCode() : 0;
            result = 31 * result + (this.variableValue.isProcessInstanceVariable() ? 1 : 0);
            result = 31 * result + (this.variableValue.isLocal() ? 1 : 0);
            return result;
        }
    }
}

